/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.util.cli;

import fiji.plugin.trackmate.util.cli.CLIConfigurator;
import fiji.plugin.trackmate.util.cli.CommandCLIConfigurator;
import fiji.plugin.trackmate.util.cli.CondaCLIConfigurator;
import fiji.plugin.trackmate.util.cli.Configurator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

public class CommandBuilder
implements Configurator.ArgumentVisitor {
    private final List<String> tokens = new ArrayList<String>();
    private final Map<Configurator.Argument<?, ?>, Function<Object, List<String>>> translators;

    protected CommandBuilder(Map<Configurator.Argument<?, ?>, Function<Object, List<String>>> translators) {
        this.translators = translators;
    }

    public String toString() {
        return StringUtils.join(this.tokens, (String)" ");
    }

    private void check(Configurator.Argument<?, ?> arg) {
        if (arg.isInCLI() && arg.getArgument() == null) {
            throw new IllegalArgumentException("Incorrect configuration for argument '" + arg.getName() + "'. The command argument is not set.");
        }
    }

    @Override
    public void visit(CommandCLIConfigurator.ExecutablePath executablePath) {
        if (executablePath.getValue() == null) {
            throw new IllegalArgumentException("Executable path is not set.");
        }
        this.tokens.addAll(this.translators.getOrDefault(executablePath, v -> Collections.singletonList(String.valueOf(v))).apply(executablePath.getValue()));
    }

    @Override
    public void visit(CondaCLIConfigurator.CondaEnvironmentCommand condaEnv) {
        if (condaEnv.getValue() == null) {
            throw new IllegalArgumentException("Conda environment is not set.");
        }
        this.tokens.addAll(this.translators.getOrDefault(condaEnv, v -> Collections.singletonList(String.valueOf(v))).apply(condaEnv.getValue()));
    }

    @Override
    public void visit(Configurator.Flag flag) {
        this.check(flag);
        boolean val = flag.isSet() ? ((Boolean)flag.getValue()).booleanValue() : ((Boolean)flag.getDefaultValue()).booleanValue();
        String a = flag.getArgument();
        List vals = this.translators.getOrDefault(flag, v -> Collections.singletonList(String.valueOf(v))).apply(val);
        if (a.endsWith("=")) {
            this.tokens.add(a + String.join((CharSequence)",", vals));
        } else if (val) {
            this.tokens.add(a);
            if (this.translators.containsKey(flag)) {
                this.tokens.addAll(vals);
            }
        }
    }

    @Override
    public void visit(Configurator.IntArgument arg) {
        this.check(arg);
        if (arg.isRequired() && !arg.isSet()) {
            throw new IllegalArgumentException("Required argument '" + arg.getName() + "' is not set.");
        }
        if (!arg.isSet() && !arg.hasDefaultValue()) {
            return;
        }
        int val = !arg.isSet() ? (Integer)arg.getDefaultValue() : (Integer)arg.getValue();
        if (arg.hasMin() && val < (Integer)arg.getMin()) {
            throw new IllegalArgumentException("Value " + val + " for argument '" + arg.getName() + "' is smaller than the min: " + String.valueOf(arg.getMin()));
        }
        if (arg.hasMax() && (Integer)arg.getMax() != Integer.MAX_VALUE && val > (Integer)arg.getMax()) {
            throw new IllegalArgumentException("Value " + val + " for argument '" + arg.getName() + "' is larger than the max: " + String.valueOf(arg.getMax()));
        }
        String a = arg.getArgument();
        List vals = this.translators.getOrDefault(arg, v -> Collections.singletonList(String.valueOf(v))).apply(val);
        if (a.endsWith("=")) {
            this.tokens.add(a + String.join((CharSequence)",", vals));
        } else {
            this.tokens.add(a);
            this.tokens.addAll(vals);
        }
    }

    @Override
    public void visit(Configurator.DoubleArgument arg) {
        this.check(arg);
        if (arg.isRequired() && !arg.isSet()) {
            throw new IllegalArgumentException("Required argument '" + arg.getName() + "' is not set.");
        }
        if (!arg.isSet() && !arg.hasDefaultValue()) {
            return;
        }
        double val = !arg.isSet() ? (Double)arg.getDefaultValue() : (Double)arg.getValue();
        if (arg.hasMin() && val < (Double)arg.getMin()) {
            throw new IllegalArgumentException("Value " + val + " for argument '" + arg.getName() + "' is smaller than the min: " + String.valueOf(arg.getMin()));
        }
        if (arg.hasMax() && val > (Double)arg.getMax()) {
            throw new IllegalArgumentException("Value " + val + " for argument '" + arg.getName() + "' is larger than the max: " + String.valueOf(arg.getMax()));
        }
        String a = arg.getArgument();
        List vals = this.translators.getOrDefault(arg, v -> Collections.singletonList(String.valueOf(v))).apply(val);
        if (a.endsWith("=")) {
            this.tokens.add(a + String.join((CharSequence)",", vals));
        } else {
            this.tokens.add(a);
            this.tokens.addAll(vals);
        }
    }

    private void visitString(Configurator.AbstractStringArgument<?> arg) {
        this.check(arg);
        if (arg.isRequired() && !arg.isSet()) {
            throw new IllegalArgumentException("Required argument '" + arg.getName() + "' is not set.");
        }
        if (!arg.isSet() && !arg.hasDefaultValue()) {
            return;
        }
        String val = !arg.isSet() ? (String)arg.getDefaultValue() : (String)arg.getValue();
        String a = arg.getArgument();
        List vals = this.translators.getOrDefault(arg, v -> Collections.singletonList(String.valueOf(v))).apply(val);
        if (a.endsWith("=")) {
            this.tokens.add(a + String.join((CharSequence)",", vals));
        } else {
            if (!a.isEmpty()) {
                this.tokens.add(a);
            }
            this.tokens.addAll(vals);
        }
    }

    @Override
    public void visit(Configurator.StringArgument stringArgument) {
        this.visitString(stringArgument);
    }

    @Override
    public void visit(Configurator.PathArgument pathArgument) {
        this.visitString(pathArgument);
    }

    @Override
    public void visit(Configurator.ChoiceArgument arg) {
        this.check(arg);
        if (arg.isRequired() && !arg.isSet()) {
            throw new IllegalArgumentException("Required argument '" + arg.getName() + "' is not set.");
        }
        if (!arg.isSet()) {
            return;
        }
        String a = arg.getArgument();
        List vals = this.translators.getOrDefault(arg, v -> Collections.singletonList(String.valueOf(v))).apply(arg.getValue());
        if (a.endsWith("=")) {
            this.tokens.add(a + String.join((CharSequence)",", vals));
        } else {
            this.tokens.add(a);
            this.tokens.addAll(vals);
        }
    }

    public static List<String> build(CLIConfigurator cli) {
        CommandBuilder cb = new CommandBuilder(cli.cliTranslators);
        cli.getCommandArg().accept(cb);
        cli.getSelectedArguments().stream().filter(a -> a.isInCLI()).forEach(arg -> arg.accept(cb));
        return cb.tokens;
    }
}

