/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.it.jacs.shared.ffmpeg;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bytedeco.javacpp.BytePointer;
import org.janelia.it.jacs.shared.ffmpeg.FFMPGByteAcceptor;

public class PPMFileAcceptor
implements FFMPGByteAcceptor {
    private int frameNum;
    private int pixelBytes;

    @Override
    public void setFrameNum(int frameNum) {
        this.frameNum = frameNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(BytePointer data, int linesize, int width, int height) {
        String FILENAME_FORMAT = "image%05d.ppm";
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(String.format("image%05d.ppm", this.frameNum));
            ((OutputStream)stream).write(("P6\n" + width + " " + height + "\n255\n").getBytes());
            byte[] bytes = new byte[width * this.pixelBytes];
            for (int y = 0; y < height; ++y) {
                data.position((long)(y * linesize)).get(bytes);
                ((OutputStream)stream).write(bytes);
            }
            this.closeStream(stream);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            this.closeStream(stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(byte[] bytes, int linesize, int width, int height) {
        String FILENAME_FORMAT = "image%05d.ppm";
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(String.format("image%05d.ppm", this.frameNum));
            ((OutputStream)stream).write(("P6\n" + width + " " + height + "\n255\n").getBytes());
            for (int y = 0; y < height; ++y) {
                ((OutputStream)stream).write(bytes, y * linesize, linesize);
            }
            this.closeStream(stream);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            this.closeStream(stream);
        }
    }

    @Override
    public void setPixelBytes(int pixelBytes) {
        this.pixelBytes = pixelBytes;
    }

    protected void closeStream(OutputStream stream) throws RuntimeException {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }
}

