/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.struct;

import org.scijava.common3.Types;
import org.scijava.struct.Member;
import org.scijava.struct.MemberInstance;
import org.scijava.struct.ValueAccessible;

public class ValueAccessibleMemberInstance<T>
implements MemberInstance<T> {
    private Member<T> member;
    private ValueAccessible<T> access;
    private Object object;

    public <M extends Member<T> & ValueAccessible<T>> ValueAccessibleMemberInstance(M member, Object object) {
        this.member = member;
        this.access = member;
        this.object = object;
    }

    @Override
    public Member<T> member() {
        return this.member;
    }

    @Override
    public boolean isReadable() {
        return true;
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public T get() {
        return this.access.get(this.object);
    }

    @Override
    public void set(Object value) {
        Class<T> type;
        if (!Types.isAssignable(value != null ? value.getClass() : null, type = this.member().rawType())) {
            throw new IllegalArgumentException("value of type " + Types.name(value.getClass()) + " is not assignable to " + Types.name(type));
        }
        Object tValue = value;
        this.access.set(tValue, this.object);
    }
}

