/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.matcher.impl;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import org.scijava.common3.Any;
import org.scijava.common3.Types;

public final class MatchingUtils {
    private MatchingUtils() {
    }

    static int checkGenericOutputsAssignability(Type[] froms, Type[] tos, HashMap<TypeVariable<?>, TypeVarInfo> typeBounds) {
        for (int i = 0; i < froms.length; ++i) {
            Type from = froms[i];
            Type to = tos[i];
            if (Any.is((Object)to)) continue;
            if (from instanceof TypeVariable) {
                TypeVarInfo typeVarInfo = typeBounds.get(from);
                if (typeVarInfo == null) {
                    TypeVariable fromTypeVar = (TypeVariable)from;
                    TypeVarInfo fromInfo = new TypeVarInfo(fromTypeVar);
                    fromInfo.fixBounds(to, true);
                    typeBounds.put(fromTypeVar, fromInfo);
                    from = to;
                } else if (typeVarInfo.allowType(to, true)) {
                    from = to;
                }
            }
            if (Types.isAssignable((Type)Types.raw((Type)from), (Type)Types.raw((Type)to))) continue;
            return i;
        }
        return -1;
    }

    public static int isApplicable(Type[] args, Type[] params) {
        HashMap typeBounds = new HashMap();
        return MatchingUtils.isApplicable(args, params, typeBounds);
    }

    public static int isApplicable(Type[] args, Type[] params, Map<TypeVariable<?>, TypeVarInfo> typeBounds) {
        if (args.length != params.length) {
            throw new IllegalArgumentException("src and dest lengths differ");
        }
        for (int i = 0; i < params.length; ++i) {
            Type arg = args[i];
            Type param = params[i];
            if (MatchingUtils.isApplicableToRawTypes(arg, Any.class)) continue;
            if (!MatchingUtils.isApplicableToRawTypes(arg, param)) {
                return i;
            }
            if (!(param instanceof ParameterizedType ? !MatchingUtils.isApplicableToParameterizedTypes(arg, (ParameterizedType)param, typeBounds) : (param instanceof TypeVariable ? !MatchingUtils.isApplicableToTypeVariable(arg, (TypeVariable)param, typeBounds) : (param instanceof WildcardType ? !MatchingUtils.isApplicableToWildcardType(arg, (WildcardType)param) : param instanceof GenericArrayType && !MatchingUtils.isApplicableToGenericArrayType(arg, (GenericArrayType)param, typeBounds))))) continue;
            return i;
        }
        return -1;
    }

    private static boolean isApplicableToRawTypes(Type arg, Type param) {
        if (Any.is((Object)arg)) {
            return true;
        }
        List srcClasses = Types.raws((Type)arg);
        List destClasses = Types.raws((Type)param);
        for (Class destClass : destClasses) {
            Optional<Class> first = srcClasses.stream().filter(srcClass -> Types.isAssignable((Type)srcClass, (Type)destClass)).findFirst();
            if (!first.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static boolean isApplicableToParameterizedTypes(Type arg, ParameterizedType param, Map<TypeVariable<?>, TypeVarInfo> typeBounds) {
        if (arg instanceof Class) {
            Class paramRaw = Types.raw((Type)param);
            return Types.isAssignable((Type)arg, (Type)paramRaw);
        }
        Type[] destTypes = param.getActualTypeArguments();
        Type[] srcTypes = new Type[destTypes.length];
        Type superType = Types.superTypeOf((Type)arg, (Class)Types.raw((Type)param));
        if (!(superType instanceof ParameterizedType)) {
            return false;
        }
        srcTypes = ((ParameterizedType)superType).getActualTypeArguments();
        ArrayList<Integer> ignoredIndices = new ArrayList<Integer>();
        for (int i = 0; i < destTypes.length; ++i) {
            Type destType = destTypes[i];
            if (!(destType instanceof TypeVariable)) continue;
            Type srcType = srcTypes[i];
            TypeVariable destTypeVar = (TypeVariable)destType;
            if (Any.is((Object)srcType)) continue;
            if (!MatchingUtils.isApplicableToTypeParameter(srcType, destTypeVar, typeBounds)) {
                return false;
            }
            ignoredIndices.add(i);
        }
        return MatchingUtils.isApplicable(srcTypes = MatchingUtils.filterIndices(srcTypes, ignoredIndices), destTypes = MatchingUtils.filterIndices(destTypes, ignoredIndices), typeBounds) == -1;
    }

    private static boolean isApplicableToTypeParameter(Type arg, TypeVariable<?> param, Map<TypeVariable<?>, TypeVarInfo> typeBounds) {
        if (!typeBounds.containsKey(param)) {
            typeBounds.put(param, new TypeVarInfo((TypeVariable)param){

                @Override
                public boolean allowType(Type type, boolean refuseWildcards) {
                    return super.allowType(type, true);
                }
            });
        }
        if (!typeBounds.get(param).fixBounds(arg, true)) {
            return false;
        }
        return MatchingUtils.isApplicableToTypeVariableBounds(arg, param, typeBounds);
    }

    private static boolean isApplicableToTypeVariable(Type arg, TypeVariable<?> param, Map<TypeVariable<?>, TypeVarInfo> typeBounds) {
        if (!typeBounds.containsKey(param)) {
            typeBounds.put(param, new TypeVarInfo(param));
        }
        if (!typeBounds.get(param).allowType(arg, false)) {
            return false;
        }
        return MatchingUtils.isApplicableToTypeVariableBounds(arg, param, typeBounds);
    }

    private static boolean isApplicableToTypeVariableBounds(Type arg, TypeVariable<?> param, Map<TypeVariable<?>, TypeVarInfo> typeBounds) {
        Type[] paramBounds;
        for (Type paramBound : paramBounds = typeBounds.get(param).upperBounds) {
            if (!(paramBound instanceof ParameterizedType)) continue;
            ParameterizedType paramBoundType = (ParameterizedType)paramBound;
            Type[] paramBoundTypes = paramBoundType.getActualTypeArguments();
            Type[] argTypes = Types.typeParamsOf((Type)arg, (Class)Types.raw((Type)paramBoundType));
            for (int i = 0; i < paramBoundTypes.length; ++i) {
                Type argType;
                Type type = argType = i < argTypes.length ? argTypes[i] : null;
                if (argType == null) {
                    return false;
                }
                if (paramBoundTypes[i] instanceof TypeVariable && !MatchingUtils.isApplicableToTypeParameter(argType, (TypeVariable)paramBoundTypes[i], typeBounds)) {
                    return false;
                }
                if (MatchingUtils.isApplicable(new Type[]{argType}, new Type[]{paramBoundTypes[i]}, typeBounds) == -1) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isApplicableToWildcardType(Type arg, WildcardType param) {
        Type[] upperBounds = param.getUpperBounds();
        Type[] lowerBounds = param.getLowerBounds();
        Class argType = Types.raw((Type)arg);
        for (Type upperBound : upperBounds) {
            Class upperType = Types.raw((Type)upperBound);
            if (Types.isAssignable((Type)argType, (Type)upperType)) continue;
            return false;
        }
        for (Type lowerBound : lowerBounds) {
            Class lowerType = Types.raw((Type)lowerBound);
            if (Types.isAssignable((Type)lowerType, (Type)argType)) continue;
            return false;
        }
        return true;
    }

    private static boolean isApplicableToGenericArrayType(Type arg, GenericArrayType param, Map<TypeVariable<?>, TypeVarInfo> typeBounds) {
        TypeVariable paramType;
        ParameterizedType paramType2;
        ParameterizedType argType;
        Type argComponent = Types.component((Type)arg);
        Type paramComponent = Types.component((Type)param);
        if (paramComponent instanceof ParameterizedType ? !MatchingUtils.isApplicableToParameterizedTypes(argType = (ParameterizedType)argComponent, paramType2 = (ParameterizedType)paramComponent, typeBounds) : paramComponent instanceof TypeVariable && !MatchingUtils.isApplicableToTypeVariable(argComponent, paramType = (TypeVariable)paramComponent, typeBounds)) {
            return false;
        }
        Class argClass = Types.raw((Type)argComponent);
        Class paramClass = Types.raw((Type)paramComponent);
        return Types.isAssignable((Type)argClass, (Type)paramClass);
    }

    private static Type[] filterIndices(Type[] types, List<Integer> indices) {
        return (Type[])IntStream.range(0, types.length).filter(i -> !indices.contains(i)).mapToObj(i -> types[i]).toArray(Type[]::new);
    }

    public static class TypeVarInfo {
        private final TypeVariable<?> var;
        private final Type[] upperBounds;
        private Set<Type> types;

        public TypeVarInfo(TypeVariable<?> var) {
            this.var = var;
            this.upperBounds = var.getBounds();
            this.types = new HashSet<Type>();
        }

        public boolean typesContainWildcard() {
            return this.types.stream().anyMatch(t -> t instanceof WildcardType);
        }

        public boolean wildcardAllowedInParameterizedType(Type type) {
            if (this.typesContainWildcard()) {
                return false;
            }
            return this.types.isEmpty() || !(type instanceof WildcardType);
        }

        public boolean allowType(Type type, boolean refuseWildcards) {
            if (refuseWildcards && !this.wildcardAllowedInParameterizedType(type)) {
                return false;
            }
            Class typeClass = Types.raw((Type)type);
            for (Type upperBound : this.upperBounds) {
                if (Types.raw((Type)upperBound).isAssignableFrom(typeClass)) continue;
                return false;
            }
            this.types.add(type);
            return true;
        }

        public boolean fixBounds(Type bound, boolean refuseWildcards) {
            if (refuseWildcards && !this.wildcardAllowedInParameterizedType(bound)) {
                return false;
            }
            for (int i = 0; i < this.upperBounds.length; ++i) {
                if (!Types.raw((Type)this.upperBounds[i]).isAssignableFrom(Types.raw((Type)bound))) {
                    return false;
                }
                this.upperBounds[i] = bound;
            }
            Set<Type> temp = this.types;
            temp.add(bound);
            this.types = new HashSet<Type>();
            for (Type type : temp) {
                if (this.allowType(type, false)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append(this.getClass().getSimpleName());
            s.append(": ");
            s.append(this.var.getName());
            s.append("\n\t\t");
            s.append("of Types:\n\t\t\t");
            for (Type t : this.types) {
                s.append(t.getTypeName());
                s.append("\n\t\t\t");
            }
            s.delete(s.length() - 1, s.length());
            s.append("with upper Bounds:\n\t\t\t");
            for (Type t : this.upperBounds) {
                s.append(t.getTypeName());
                s.append("\n\t\t\t");
            }
            s.delete(s.length() - 3, s.length());
            s.append("\n");
            return s.toString();
        }
    }
}

