/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.struct;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.scijava.ops.engine.exceptions.impl.OpDependencyPositionException;
import org.scijava.ops.engine.struct.MethodParameterOpDependencyMember;
import org.scijava.ops.spi.OpDependency;
import org.scijava.struct.MemberParser;

public class MethodOpDependencyMemberParser
implements MemberParser<Method, MethodParameterOpDependencyMember<?>> {
    public List<MethodParameterOpDependencyMember<?>> parse(Method source, Type structType) {
        if (source == null) {
            return null;
        }
        source.setAccessible(true);
        ArrayList items = new ArrayList();
        MethodOpDependencyMemberParser.parseMethodOpDependencies(items, source);
        return items;
    }

    private static void parseMethodOpDependencies(List<MethodParameterOpDependencyMember<?>> items, Method annotatedMethod) {
        Parameter[] methodParams;
        Boolean[] isDependency = (Boolean[])Arrays.stream(annotatedMethod.getParameters()).map(param -> param.isAnnotationPresent(OpDependency.class)).toArray(Boolean[]::new);
        for (int i = 0; i < isDependency.length - 1; ++i) {
            if (isDependency[i].booleanValue() || !isDependency[i + 1].booleanValue()) continue;
            throw new OpDependencyPositionException(annotatedMethod);
        }
        for (Parameter methodParam : methodParams = annotatedMethod.getParameters()) {
            OpDependency dependency = methodParam.getAnnotation(OpDependency.class);
            if (dependency == null) continue;
            String name = methodParam.getName();
            Type methodParamType = methodParam.getParameterizedType();
            items.add(new MethodParameterOpDependencyMember(name, "", methodParamType, dependency));
        }
    }
}

