/*
 * Decompiled with CFR 0.152.
 */
package org.apposed.appose.builder;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apposed.appose.Builder;
import org.apposed.appose.Environment;
import org.apposed.appose.builder.BaseBuilder;
import org.apposed.appose.builder.Pixi;
import org.apposed.appose.scheme.Schemes;
import org.apposed.appose.util.FilePaths;

public final class PixiBuilder
extends BaseBuilder<PixiBuilder> {
    private final List<String> condaPackages = new ArrayList<String>();
    private final List<String> pypiPackages = new ArrayList<String>();

    public PixiBuilder() {
    }

    public PixiBuilder(String source) throws IOException {
        this.file(source);
    }

    public PixiBuilder(String source, String scheme) throws IOException {
        this.file(source);
        this.scheme = scheme;
    }

    public PixiBuilder conda(String ... packages) {
        this.condaPackages.addAll(Arrays.asList(packages));
        return this;
    }

    public PixiBuilder pypi(String ... packages) {
        this.pypiPackages.addAll(Arrays.asList(packages));
        return this;
    }

    @Override
    public String name() {
        return "pixi";
    }

    @Override
    public Environment build() throws IOException {
        File envDir = this.envDir();
        if (new File(envDir, "conda-meta").exists() && !new File(envDir, ".pixi").exists()) {
            throw new IOException("Cannot use PixiBuilder: environment already managed by Mamba/Conda at " + envDir);
        }
        if (new File(envDir, "pyvenv.cfg").exists()) {
            throw new IOException("Cannot use PixiBuilder: environment already managed by uv/venv at " + envDir);
        }
        Pixi pixi = new Pixi();
        pixi.setOutputConsumer(msg -> this.outputSubscribers.forEach(sub -> sub.accept(msg)));
        pixi.setErrorConsumer(msg -> this.errorSubscribers.forEach(sub -> sub.accept(msg)));
        pixi.setDownloadProgressConsumer((cur, max) -> this.progressSubscribers.forEach(subscriber -> subscriber.accept("Downloading pixi", (long)cur, (long)max)));
        pixi.setEnvVars(this.envVars);
        pixi.setFlags(this.flags);
        try {
            boolean isPixiDir;
            pixi.install();
            boolean bl = isPixiDir = new File(envDir, "pixi.toml").isFile() || new File(envDir, "pyproject.toml").isFile() || new File(envDir, ".pixi").isDirectory();
            if (isPixiDir && this.sourceContent == null && this.condaPackages.isEmpty() && this.pypiPackages.isEmpty()) {
                return this.createEnvironment(pixi, envDir);
            }
            if (this.sourceContent != null) {
                if (isPixiDir) {
                    return this.createEnvironment(pixi, envDir);
                }
                if (this.scheme == null) {
                    this.scheme = Schemes.fromContent(this.sourceContent).name();
                }
                if (!envDir.exists() && !envDir.mkdirs()) {
                    throw new IOException("Failed to create environment directory: " + envDir);
                }
                if ("pixi.toml".equals(this.scheme)) {
                    File pixiTomlFile = new File(envDir, "pixi.toml");
                    Files.write(pixiTomlFile.toPath(), this.sourceContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                } else if ("pyproject.toml".equals(this.scheme)) {
                    File pyprojectTomlFile = new File(envDir, "pyproject.toml");
                    Files.write(pyprojectTomlFile.toPath(), this.sourceContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                } else if ("environment.yml".equals(this.scheme)) {
                    File environmentYamlFile = new File(envDir, "environment.yml");
                    Files.write(environmentYamlFile.toPath(), this.sourceContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                    pixi.exec("init", "--import", environmentYamlFile.getAbsolutePath(), envDir.getAbsolutePath());
                }
                if (!this.channels.isEmpty()) {
                    pixi.addChannels(envDir, this.channels.toArray(new String[0]));
                }
            } else {
                boolean progBuild;
                if (isPixiDir) {
                    return this.createEnvironment(pixi, envDir);
                }
                if (!envDir.exists() && !envDir.mkdirs()) {
                    throw new IOException("Failed to create environment directory: " + envDir);
                }
                pixi.init(envDir);
                if (this.condaPackages.isEmpty() && this.pypiPackages.isEmpty()) {
                    throw new IllegalStateException("Cannot build empty environment programmatically. Either provide a source file via Appose.pixi(source), or add packages via .conda() or .pypi().");
                }
                if (!this.channels.isEmpty()) {
                    pixi.addChannels(envDir, this.channels.toArray(new String[0]));
                }
                if (!this.condaPackages.isEmpty()) {
                    pixi.addCondaPackages(envDir, this.condaPackages.toArray(new String[0]));
                }
                if (!this.pypiPackages.isEmpty()) {
                    pixi.addPypiPackages(envDir, this.pypiPackages.toArray(new String[0]));
                }
                boolean bl2 = progBuild = !this.condaPackages.isEmpty() || !this.pypiPackages.isEmpty();
                if (progBuild) {
                    boolean hasAppose;
                    boolean bl3 = hasAppose = this.condaPackages.stream().anyMatch(pkg -> pkg.matches("^appose\\b.*")) || this.pypiPackages.stream().anyMatch(pkg -> pkg.matches("^appose\\b.*"));
                    if (!hasAppose) {
                        throw new IllegalStateException("Appose package must be explicitly included when building programmatically. Add .conda(\"appose\") or .pypi(\"appose\") to your builder.");
                    }
                }
            }
            return this.createEnvironment(pixi, envDir);
        }
        catch (InterruptedException | URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Environment wrap(File envDir) throws IOException {
        FilePaths.ensureDirectory(envDir);
        File pixiToml = new File(envDir, "pixi.toml");
        if (pixiToml.exists() && pixiToml.isFile()) {
            this.sourceContent = new String(Files.readAllBytes(pixiToml.toPath()), StandardCharsets.UTF_8);
            this.scheme = "pixi.toml";
        } else {
            File pyprojectToml = new File(envDir, "pyproject.toml");
            if (pyprojectToml.exists() && pyprojectToml.isFile()) {
                this.sourceContent = new String(Files.readAllBytes(pyprojectToml.toPath()), StandardCharsets.UTF_8);
                this.scheme = "pyproject.toml";
            }
        }
        this.base(envDir);
        return this.build();
    }

    @Override
    public PixiBuilder channels(String ... channels) {
        return (PixiBuilder)super.channels(channels);
    }

    private Environment createEnvironment(Pixi pixi, File envDir) {
        final String base = envDir.getAbsolutePath();
        File manifestFile = new File(envDir, "pyproject.toml");
        if (!manifestFile.exists()) {
            manifestFile = new File(envDir, "pixi.toml");
        }
        final List<String> launchArgs = Arrays.asList(pixi.command, "run", "--manifest-path", manifestFile.getAbsolutePath());
        final List<String> binPaths = Arrays.asList(envDir.toPath().resolve(".pixi").resolve("envs").resolve("default").resolve("bin").toString());
        return new Environment(){

            @Override
            public String base() {
                return base;
            }

            @Override
            public List<String> binPaths() {
                return binPaths;
            }

            @Override
            public List<String> launchArgs() {
                return launchArgs;
            }

            @Override
            public Map<String, String> envVars() {
                return PixiBuilder.this.envVars;
            }

            @Override
            public Builder<?> builder() {
                return PixiBuilder.this;
            }
        };
    }
}

