/*
 * Decompiled with CFR 0.152.
 */
package org.apposed.appose.builder;

import java.io.File;
import java.io.IOException;
import org.apposed.appose.Builder;
import org.apposed.appose.BuilderFactory;
import org.apposed.appose.builder.PixiBuilder;

public class PixiBuilderFactory
implements BuilderFactory {
    @Override
    public Builder<?> createBuilder() {
        return new PixiBuilder();
    }

    @Override
    public Builder<?> createBuilder(String source) throws IOException {
        return new PixiBuilder(source);
    }

    @Override
    public Builder<?> createBuilder(String source, String scheme) throws IOException {
        return new PixiBuilder(source, scheme);
    }

    @Override
    public String name() {
        return "pixi";
    }

    @Override
    public boolean supportsScheme(String scheme) {
        switch (scheme) {
            case "pixi.toml": 
            case "environment.yml": 
            case "conda": 
            case "pypi": {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsSource(String source) {
        return source.endsWith("pixi.toml") || source.endsWith(".yml") || source.endsWith(".yaml");
    }

    @Override
    public double priority() {
        return 100.0;
    }

    @Override
    public boolean canWrap(File envDir) {
        return new File(envDir, ".pixi").isDirectory() || new File(envDir, "pixi.toml").isFile();
    }
}

