/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.usermodel;

import java.io.IOException;
import loci.poi.hssf.record.EmbeddedObjectRefSubRecord;
import loci.poi.hssf.record.ObjRecord;
import loci.poi.poifs.filesystem.DirectoryEntry;
import loci.poi.poifs.filesystem.Entry;
import loci.poi.poifs.filesystem.POIFSFileSystem;
import loci.poi.util.HexDump;

public class HSSFObjectData {
    private ObjRecord record;
    private POIFSFileSystem poifs;

    public HSSFObjectData(ObjRecord record, POIFSFileSystem poifs) {
        this.record = record;
        this.poifs = poifs;
    }

    public DirectoryEntry getDirectory() throws IOException {
        for (Object subRecord : this.record.getSubRecords()) {
            if (!(subRecord instanceof EmbeddedObjectRefSubRecord)) continue;
            int streamId = ((EmbeddedObjectRefSubRecord)subRecord).getStreamId();
            String streamName = "MBD" + HexDump.toHex(streamId);
            Entry entry = this.poifs.getRoot().getEntry(streamName);
            if (entry instanceof DirectoryEntry) {
                return (DirectoryEntry)entry;
            }
            throw new IOException("Stream " + streamName + " was not an OLE2 directory");
        }
        throw new IllegalStateException("Object data does not contain a reference to an embedded object OLE2 directory");
    }
}

