/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugins.scripteditor.jython;

import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.FunctionCompletion;
import org.fife.ui.autocomplete.ParameterizedCompletion;

public class CustomFunctionCompletion
extends FunctionCompletion {
    public CustomFunctionCompletion(CompletionProvider provider, String name, String returnType) {
        super(provider, name, returnType);
    }

    public String getName() {
        return super.getName() + "()";
    }

    protected String getSuperName() {
        return super.getName();
    }

    public String getDefinitionString() {
        StringBuilder sb = new StringBuilder();
        String type = this.getType();
        if (type != null) {
            sb.append(type).append(' ');
        }
        sb.append(super.getName());
        CompletionProvider provider = this.getProvider();
        char start = provider.getParameterListStart();
        if (start != '\u0000') {
            sb.append(start);
        }
        for (int i = 0; i < this.getParamCount(); ++i) {
            ParameterizedCompletion.Parameter param = this.getParam(i);
            type = param.getType();
            String name = param.getName();
            if (type != null) {
                sb.append(type);
                if (name != null) {
                    sb.append(' ');
                }
            }
            if (name != null) {
                sb.append(name);
            }
            if (i >= super.getParamCount() - 1) continue;
            sb.append(provider.getParameterListSeparator());
        }
        char end = provider.getParameterListEnd();
        if (end != '\u0000') {
            sb.append(end);
        }
        return sb.toString();
    }

    public String getSummary() {
        return super.getShortDescription();
    }

    public int compareTo(Completion c2) {
        if (c2 == this) {
            return 0;
        }
        if (c2 instanceof CustomFunctionCompletion) {
            CustomFunctionCompletion other = (CustomFunctionCompletion)c2;
            int r = this.getSuperName().compareToIgnoreCase(other.getSuperName());
            if (0 == r) {
                if (this.getParamCount() == other.getParamCount()) {
                    for (int i = 0; i < this.getParamCount(); ++i) {
                        r = this.getParam(i).getType().compareTo(other.getParam(i).getType());
                        if (0 == r) continue;
                        return r;
                    }
                    return 0;
                }
                return this.getParamCount() < other.getParamCount() ? -1 : 1;
            }
            return r;
        }
        return this.getSuperName().compareToIgnoreCase(c2.getReplacementText());
    }
}

