/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import org.ojalgo.OjAlgoUtils;
import org.ojalgo.array.BasicArray;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.Primitive64Array;
import org.ojalgo.array.SegmentedArray;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.scalar.Scalar;

final class DenseCapacityStrategy<N extends Number> {
    static long CHUNK = 4096L / Primitive64Array.ELEMENT_SIZE;
    static long INITIAL = 4L;
    static long LIMIT = Long.MAX_VALUE;
    static long SEGMENT = 32768L;
    private long myChunk = CHUNK;
    private final DenseArray.Factory<N> myDenseFactory;
    private long myInitial = INITIAL;
    private long myLimit = LIMIT;
    private long mySegment = SEGMENT;

    static int capacity(long count) {
        double tmpInitialCapacity = count;
        while (tmpInitialCapacity > 2.147483639E9) {
            tmpInitialCapacity = PrimitiveFunction.SQRT.invoke(tmpInitialCapacity);
        }
        tmpInitialCapacity = PrimitiveFunction.SQRT.invoke(tmpInitialCapacity);
        return 2 * (int)tmpInitialCapacity;
    }

    DenseCapacityStrategy(DenseArray.Factory<N> denseFactory) {
        this.myDenseFactory = denseFactory;
        long tmpHalfTopLevelCacheElements = OjAlgoUtils.ENVIRONMENT.cache / 2L / denseFactory.getElementSize();
        this.segment(tmpHalfTopLevelCacheElements);
        long tmpMemoryPageElements = 4096L / denseFactory.getElementSize();
        this.chunk(tmpMemoryPageElements);
    }

    protected AggregatorSet<N> aggregator() {
        return this.myDenseFactory.aggregator();
    }

    protected FunctionSet<N> function() {
        return this.myDenseFactory.function();
    }

    protected Scalar.Factory<N> scalar() {
        return this.myDenseFactory.scalar();
    }

    long chunk() {
        return this.myChunk;
    }

    DenseCapacityStrategy<N> chunk(long chunk) {
        int power = PrimitiveMath.powerOf2Smaller(Math.min(chunk, this.mySegment));
        this.myChunk = 1L << power;
        return this;
    }

    DenseArray.Factory<N> getDenseFactory() {
        return this.myDenseFactory;
    }

    int grow(int current) {
        return (int)this.grow((long)current);
    }

    long grow(long current) {
        long retVal;
        long required = current + 1L;
        if (required > this.myLimit) {
            throw new IllegalStateException("Requires a count/size greater than the limit!");
        }
        if (required >= this.myChunk) {
            for (retVal = this.myChunk; retVal < required; retVal += this.myChunk) {
            }
        } else {
            long maybe = retVal;
            while ((maybe = Math.round((double)retVal / PrimitiveMath.GOLDEN_RATIO)) >= required) {
                retVal = maybe;
            }
        }
        return retVal;
    }

    int initial() {
        return (int)this.myInitial;
    }

    DenseCapacityStrategy<N> initial(long initial) {
        this.myInitial = Math.max(1L, initial);
        return this;
    }

    boolean isChunked(long count) {
        return count > this.myChunk;
    }

    boolean isSegmented(long count) {
        return count > this.mySegment;
    }

    long limit() {
        return this.myLimit;
    }

    DenseCapacityStrategy<N> limit(long limit) {
        this.myLimit = limit;
        return this;
    }

    DenseArray<N> make(long size) {
        return this.myDenseFactory.make(size);
    }

    DenseArray<N> makeChunk() {
        return this.make(this.myChunk);
    }

    DenseArray<N> makeInitial() {
        return this.make(this.myInitial);
    }

    DenseArray<N> makeSegment() {
        return this.make(this.mySegment);
    }

    SegmentedArray<N> makeSegmented(BasicArray<N> segment) {
        if (segment.count() == this.mySegment) {
            return this.myDenseFactory.wrapAsSegments(segment, this.makeChunk());
        }
        throw new IllegalStateException();
    }

    SegmentedArray<N> makeSegmented(long count) {
        return this.myDenseFactory.makeSegmented(count);
    }

    long segment() {
        return this.mySegment;
    }

    DenseCapacityStrategy<N> segment(long segment) {
        int power = PrimitiveMath.powerOf2Smaller(Math.max(this.myChunk, segment));
        this.mySegment = 1L << power;
        return this;
    }
}

