/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.util.Arrays;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.DoubleStream;
import java.util.stream.StreamSupport;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Mutate1D;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.PlainArray;
import org.ojalgo.array.PrimitiveArray;
import org.ojalgo.array.Raw1D;
import org.ojalgo.array.blas.AMAX;
import org.ojalgo.array.blas.AXPY;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.FunctionUtils;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.ParameterFunction;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.function.aggregator.PrimitiveAggregator;
import org.ojalgo.machine.JavaType;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.scalar.Scalar;

public class Primitive64Array
extends PrimitiveArray {
    public static final DenseArray.Factory<Double> FACTORY = new DenseArray.Factory<Double>(){

        @Override
        public AggregatorSet<Double> aggregator() {
            return PrimitiveAggregator.getSet();
        }

        @Override
        public FunctionSet<Double> function() {
            return PrimitiveFunction.getSet();
        }

        @Override
        public Scalar.Factory<Double> scalar() {
            return PrimitiveScalar.FACTORY;
        }

        @Override
        long getElementSize() {
            return ELEMENT_SIZE;
        }

        @Override
        PlainArray<Double> make(long size) {
            return Primitive64Array.make((int)size);
        }
    };
    static final long ELEMENT_SIZE = JavaType.DOUBLE.memory();
    public final double[] data;

    public static final Primitive64Array make(int size) {
        return new Primitive64Array(size);
    }

    public static final Primitive64Array wrap(double ... data) {
        return new Primitive64Array(data);
    }

    private static void add(double[] data, int first, int limit, int step, double left, double[] right) {
        for (int i = first; i < limit; i += step) {
            data[i] = left + right[i];
        }
    }

    private static void add(double[] data, int first, int limit, int step, double[] left, double right) {
        for (int i = first; i < limit; i += step) {
            data[i] = left[i] + right;
        }
    }

    private static void add(double[] data, int first, int limit, int step, double[] left, double[] right) {
        for (int i = first; i < limit; i += step) {
            data[i] = left[i] + right[i];
        }
    }

    private static void divide(double[] data, int first, int limit, int step, double left, double[] right) {
        for (int i = first; i < limit; i += step) {
            data[i] = left / right[i];
        }
    }

    private static void divide(double[] data, int first, int limit, int step, double[] left, double right) {
        for (int i = first; i < limit; i += step) {
            data[i] = left[i] / right;
        }
    }

    private static void divide(double[] data, int first, int limit, int step, double[] left, double[] right) {
        for (int i = first; i < limit; i += step) {
            data[i] = left[i] / right[i];
        }
    }

    private static void multiply(double[] data, int first, int limit, int step, double left, double[] right) {
        for (int i = first; i < limit; i += step) {
            data[i] = left * right[i];
        }
    }

    private static void multiply(double[] data, int first, int limit, int step, double[] left, double right) {
        for (int i = first; i < limit; i += step) {
            data[i] = left[i] * right;
        }
    }

    private static void multiply(double[] data, int first, int limit, int step, double[] left, double[] right) {
        for (int i = first; i < limit; i += step) {
            data[i] = left[i] * right[i];
        }
    }

    private static void negate(double[] data, int first, int limit, int step, double[] values) {
        for (int i = first; i < limit; i += step) {
            data[i] = -values[i];
        }
    }

    private static void subtract(double[] data, int first, int limit, int step, double left, double[] right) {
        for (int i = first; i < limit; i += step) {
            data[i] = left - right[i];
        }
    }

    private static void subtract(double[] data, int first, int limit, int step, double[] left, double right) {
        for (int i = first; i < limit; i += step) {
            data[i] = left[i] - right;
        }
    }

    private static void subtract(double[] data, int first, int limit, int step, double[] left, double[] right) {
        for (int i = first; i < limit; i += step) {
            data[i] = left[i] - right[i];
        }
    }

    protected static void exchange(double[] data, int firstA, int firstB, int step, int count) {
        int tmpIndexA = firstA;
        int tmpIndexB = firstB;
        for (int i = 0; i < count; ++i) {
            double tmpVal = data[tmpIndexA];
            data[tmpIndexA] = data[tmpIndexB];
            data[tmpIndexB] = tmpVal;
            tmpIndexA += step;
            tmpIndexB += step;
        }
    }

    protected static void fill(double[] data, Access1D<?> values) {
        int tmpLimit = (int)Math.min((long)data.length, values.count());
        for (int i = 0; i < tmpLimit; ++i) {
            data[i] = values.doubleValue(i);
        }
    }

    protected static void fill(double[] data, int first, int limit, int step, double value) {
        for (int i = first; i < limit; i += step) {
            data[i] = value;
        }
    }

    protected static void fill(double[] data, int first, int limit, int step, NullaryFunction<Double> supplier) {
        for (int i = first; i < limit; i += step) {
            data[i] = supplier.doubleValue();
        }
    }

    protected static void invoke(double[] data, int first, int limit, int step, Access1D<Double> left, BinaryFunction<Double> function, Access1D<Double> right) {
        if (left instanceof Primitive64Array && right instanceof Primitive64Array) {
            Primitive64Array.invoke(data, first, limit, step, ((Primitive64Array)left).data, function, ((Primitive64Array)right).data);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(left.doubleValue(i), right.doubleValue(i));
            }
        }
    }

    protected static void invoke(double[] data, int first, int limit, int step, Access1D<Double> left, BinaryFunction<Double> function, double right) {
        if (left instanceof Primitive64Array) {
            Primitive64Array.invoke(data, first, limit, step, ((Primitive64Array)left).data, function, right);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(left.doubleValue(i), right);
            }
        }
    }

    protected static void invoke(double[] data, int first, int limit, int step, Access1D<Double> values, ParameterFunction<Double> function, int aParam) {
        if (values instanceof Primitive64Array) {
            Primitive64Array.invoke(data, first, limit, step, ((Primitive64Array)values).data, function, aParam);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(values.doubleValue(i), aParam);
            }
        }
    }

    protected static void invoke(double[] data, int first, int limit, int step, Access1D<Double> values, UnaryFunction<Double> function) {
        if (values instanceof Primitive64Array) {
            Primitive64Array.invoke(data, first, limit, step, ((Primitive64Array)values).data, function);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(values.doubleValue(i));
            }
        }
    }

    protected static void invoke(double[] data, int first, int limit, int step, double left, BinaryFunction<Double> function, Access1D<Double> right) {
        if (right instanceof Primitive64Array) {
            Primitive64Array.invoke(data, first, limit, step, left, function, ((Primitive64Array)right).data);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(left, right.doubleValue(i));
            }
        }
    }

    protected static void invoke(double[] data, int first, int limit, int step, VoidFunction<Double> aVisitor) {
        for (int i = first; i < limit; i += step) {
            aVisitor.invoke(data[i]);
        }
    }

    static void invoke(double[] data, int first, int limit, int step, double left, BinaryFunction<Double> function, double[] right) {
        if (function == PrimitiveFunction.ADD) {
            Primitive64Array.add(data, first, limit, step, left, right);
        } else if (function == PrimitiveFunction.DIVIDE) {
            Primitive64Array.divide(data, first, limit, step, left, right);
        } else if (function == PrimitiveFunction.MULTIPLY) {
            Primitive64Array.multiply(data, first, limit, step, left, right);
        } else if (function == PrimitiveFunction.SUBTRACT) {
            Primitive64Array.subtract(data, first, limit, step, left, right);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(left, right[i]);
            }
        }
    }

    static void invoke(double[] data, int first, int limit, int step, double[] left, BinaryFunction<Double> function, double right) {
        if (function == PrimitiveFunction.ADD) {
            Primitive64Array.add(data, first, limit, step, left, right);
        } else if (function == PrimitiveFunction.DIVIDE) {
            Primitive64Array.divide(data, first, limit, step, left, right);
        } else if (function == PrimitiveFunction.MULTIPLY) {
            Primitive64Array.multiply(data, first, limit, step, left, right);
        } else if (function == PrimitiveFunction.SUBTRACT) {
            Primitive64Array.subtract(data, first, limit, step, left, right);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(left[i], right);
            }
        }
    }

    static void invoke(double[] data, int first, int limit, int step, double[] left, BinaryFunction<Double> function, double[] right) {
        if (function == PrimitiveFunction.ADD) {
            Primitive64Array.add(data, first, limit, step, left, right);
        } else if (function == PrimitiveFunction.DIVIDE) {
            Primitive64Array.divide(data, first, limit, step, left, right);
        } else if (function == PrimitiveFunction.MULTIPLY) {
            Primitive64Array.multiply(data, first, limit, step, left, right);
        } else if (function == PrimitiveFunction.SUBTRACT) {
            Primitive64Array.subtract(data, first, limit, step, left, right);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(left[i], right[i]);
            }
        }
    }

    static void invoke(double[] data, int first, int limit, int step, double[] values, ParameterFunction<Double> function, int aParam) {
        for (int i = first; i < limit; i += step) {
            data[i] = function.invoke(values[i], aParam);
        }
    }

    static void invoke(double[] data, int first, int limit, int step, double[] values, UnaryFunction<Double> function) {
        if (function == PrimitiveFunction.NEGATE) {
            Primitive64Array.negate(data, first, limit, step, values);
        } else if (function instanceof BinaryFunction.FixedFirst) {
            BinaryFunction.FixedFirst tmpFunc = (BinaryFunction.FixedFirst)function;
            Primitive64Array.invoke(data, first, limit, step, tmpFunc.doubleValue(), tmpFunc.getFunction(), values);
        } else if (function instanceof BinaryFunction.FixedSecond) {
            BinaryFunction.FixedSecond tmpFunc = (BinaryFunction.FixedSecond)function;
            Primitive64Array.invoke(data, first, limit, step, values, tmpFunc.getFunction(), tmpFunc.doubleValue());
        } else if (function instanceof ParameterFunction.FixedParameter) {
            ParameterFunction.FixedParameter tmpFunc = (ParameterFunction.FixedParameter)function;
            Primitive64Array.invoke(data, first, limit, step, values, tmpFunc.getFunction(), tmpFunc.getParameter());
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(values[i]);
            }
        }
    }

    protected Primitive64Array(double[] data) {
        super(FACTORY, data.length);
        this.data = data;
    }

    protected Primitive64Array(int size) {
        super(FACTORY, size);
        this.data = new double[size];
    }

    @Override
    public void axpy(double a, Mutate1D y) {
        AXPY.invoke(y, a, this.data);
    }

    @Override
    public double dot(Access1D<?> vector) {
        double retVal = PrimitiveMath.ZERO;
        int limit = Math.min(this.data.length, (int)vector.count());
        for (int i = 0; i < limit; ++i) {
            retVal += this.data[i] * vector.doubleValue(i);
        }
        return retVal;
    }

    public boolean equals(Object anObj) {
        if (anObj instanceof Primitive64Array) {
            return Arrays.equals(this.data, ((Primitive64Array)anObj).data);
        }
        return super.equals(anObj);
    }

    @Override
    public void fillMatching(Access1D<?> values) {
        Primitive64Array.fill(this.data, values);
    }

    @Override
    public void fillMatching(Access1D<Double> left, BinaryFunction<Double> function, Access1D<Double> right) {
        int tmpLimit = (int)FunctionUtils.min(this.count(), left.count(), right.count());
        Primitive64Array.invoke(this.data, 0, tmpLimit, 1, left, function, right);
    }

    @Override
    public void fillMatching(UnaryFunction<Double> function, Access1D<Double> arguments) {
        int tmpLimit = (int)FunctionUtils.min(this.count(), arguments.count());
        Primitive64Array.invoke(this.data, 0, tmpLimit, 1, arguments, function);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    @Override
    public final void sortAscending() {
        Arrays.parallelSort(this.data);
    }

    @Override
    public void sortDescending() {
        Primitive64Array.negate(this.data, 0, this.data.length, 1, this.data);
        Arrays.parallelSort(this.data);
        Primitive64Array.negate(this.data, 0, this.data.length, 1, this.data);
    }

    public Spliterator.OfDouble spliterator() {
        return Spliterators.spliterator(this.data, 0, this.data.length, 1040);
    }

    public DoubleStream stream(boolean parallel) {
        return StreamSupport.doubleStream(this.spliterator(), parallel);
    }

    @Override
    protected void add(int index, double addend) {
        int n = index;
        this.data[n] = this.data[n] + addend;
    }

    @Override
    protected void add(int index, Number addend) {
        int n = index;
        this.data[n] = this.data[n] + addend.doubleValue();
    }

    protected final double[] copyOfData() {
        return Raw1D.copyOf(this.data);
    }

    @Override
    protected final double doubleValue(int index) {
        return this.data[index];
    }

    @Override
    protected final void exchange(int firstA, int firstB, int step, int count) {
        Primitive64Array.exchange(this.data, firstA, firstB, step, count);
    }

    @Override
    protected final void fill(int first, int limit, Access1D<Double> left, BinaryFunction<Double> function, Access1D<Double> right) {
        Primitive64Array.invoke(this.data, first, limit, 1, left, function, right);
    }

    @Override
    protected final void fill(int first, int limit, Access1D<Double> left, BinaryFunction<Double> function, Double right) {
        Primitive64Array.invoke(this.data, first, limit, 1, left, function, (double)right);
    }

    @Override
    protected final void fill(int first, int limit, Double left, BinaryFunction<Double> function, Access1D<Double> right) {
        Primitive64Array.invoke(this.data, first, limit, 1, (double)left, function, right);
    }

    @Override
    protected final void fill(int first, int limit, int step, Double value) {
        Primitive64Array.fill(this.data, first, limit, step, value);
    }

    @Override
    protected final void fill(int first, int limit, int step, NullaryFunction<Double> supplier) {
        Primitive64Array.fill(this.data, first, limit, step, supplier);
    }

    @Override
    protected void fillOne(int index, Access1D<?> values, long valueIndex) {
        this.data[index] = values.doubleValue(valueIndex);
    }

    @Override
    protected void fillOne(int index, Double value) {
        this.data[index] = value;
    }

    @Override
    protected void fillOne(int index, NullaryFunction<Double> supplier) {
        this.data[index] = supplier.doubleValue();
    }

    @Override
    protected final Double get(int index) {
        return this.data[index];
    }

    @Override
    protected final int indexOfLargest(int first, int limit, int step) {
        return AMAX.invoke(this.data, first, limit, step);
    }

    @Override
    protected boolean isAbsolute(int index) {
        return PrimitiveScalar.isAbsolute(this.data[index]);
    }

    @Override
    protected boolean isSmall(int index, double comparedTo) {
        return PrimitiveScalar.isSmall(comparedTo, this.data[index]);
    }

    @Override
    protected final void modify(int first, int limit, int step, Access1D<Double> left, BinaryFunction<Double> function) {
        Primitive64Array.invoke(this.data, first, limit, step, left, function, (Access1D<Double>)this);
    }

    @Override
    protected final void modify(int first, int limit, int step, BinaryFunction<Double> function, Access1D<Double> right) {
        Primitive64Array.invoke(this.data, first, limit, step, (Access1D<Double>)this, function, right);
    }

    @Override
    protected final void modify(int first, int limit, int step, BinaryFunction<Double> function, Double right) {
        Primitive64Array.invoke(this.data, first, limit, step, this.data, function, (double)right);
    }

    @Override
    protected final void modify(int first, int limit, int step, Double left, BinaryFunction<Double> function) {
        Primitive64Array.invoke(this.data, first, limit, step, (double)left, function, this.data);
    }

    @Override
    protected final void modify(int first, int limit, int step, ParameterFunction<Double> function, int parameter) {
        Primitive64Array.invoke(this.data, first, limit, step, this.data, function, parameter);
    }

    @Override
    protected final void modify(int first, int limit, int step, UnaryFunction<Double> function) {
        Primitive64Array.invoke(this.data, first, limit, step, this, function);
    }

    @Override
    protected final void modifyOne(int index, UnaryFunction<Double> modifier) {
        this.data[index] = modifier.invoke(this.data[index]);
    }

    @Override
    protected final int searchAscending(Double number) {
        return Arrays.binarySearch(this.data, number);
    }

    @Override
    protected final void set(int index, double value) {
        this.data[index] = value;
    }

    @Override
    protected final void set(int index, Number value) {
        this.data[index] = value.doubleValue();
    }

    @Override
    protected int size() {
        return this.data.length;
    }

    @Override
    protected final void visit(int first, int limit, int step, VoidFunction<Double> visitor) {
        Primitive64Array.invoke(this.data, first, limit, step, visitor);
    }

    @Override
    protected void visitOne(int index, VoidFunction<Double> visitor) {
        visitor.invoke(this.data[index]);
    }

    @Override
    void modify(long extIndex, int intIndex, Access1D<Double> left, BinaryFunction<Double> function) {
        this.data[intIndex] = function.invoke(left.doubleValue(extIndex), this.data[intIndex]);
    }

    @Override
    void modify(long extIndex, int intIndex, BinaryFunction<Double> function, Access1D<Double> right) {
        this.data[intIndex] = function.invoke(this.data[intIndex], right.doubleValue(extIndex));
    }

    @Override
    void modify(long extIndex, int intIndex, UnaryFunction<Double> function) {
        this.data[intIndex] = function.invoke(this.data[intIndex]);
    }

    Spliterator.OfDouble split() {
        return Spliterators.spliterator(this.data, 0);
    }
}

