/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.ProgrammingError;
import org.ojalgo.access.Access2D;
import org.ojalgo.array.Array1D;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.EigenvalueDecomposition;
import org.ojalgo.matrix.decomposition.HermitianEvD;
import org.ojalgo.matrix.decomposition.OldGeneralEvD;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.scalar.ComplexNumber;

abstract class DynamicEvD<N extends Number>
extends EigenvalueDecomposition<N> {
    private final EigenvalueDecomposition<N> myGeneralDelegate;
    private boolean myHermitian = false;
    private final EigenvalueDecomposition<N> myHermitianDelegate;

    private DynamicEvD(PhysicalStore.Factory<N, ? extends DecompositionStore<N>> factory) {
        this(factory, null, null);
        ProgrammingError.throwForIllegalInvocation();
    }

    protected DynamicEvD(PhysicalStore.Factory<N, ? extends DecompositionStore<N>> factory, EigenvalueDecomposition<N> hermitianDelegate, EigenvalueDecomposition<N> generalDelegate) {
        super(factory);
        this.myHermitianDelegate = hermitianDelegate;
        this.myGeneralDelegate = generalDelegate;
    }

    @Override
    public N getDeterminant() {
        if (this.myHermitian) {
            return this.myHermitianDelegate.getDeterminant();
        }
        return this.myGeneralDelegate.getDeterminant();
    }

    @Override
    public ComplexNumber getTrace() {
        if (this.myHermitian) {
            return this.myHermitianDelegate.getTrace();
        }
        return this.myGeneralDelegate.getTrace();
    }

    @Override
    public boolean isHermitian() {
        return this.myHermitian;
    }

    @Override
    public boolean isOrdered() {
        return this.myHermitian ? this.myHermitianDelegate.isOrdered() : this.myGeneralDelegate.isOrdered();
    }

    @Override
    public void reset() {
        super.reset();
        this.myGeneralDelegate.reset();
        this.myHermitianDelegate.reset();
        this.myHermitian = false;
    }

    @Override
    protected boolean doGeneral(Access2D.Collectable<N, ? super PhysicalStore<N>> matrix, boolean eigenvaluesOnly) {
        return this.myGeneralDelegate.doGeneral(matrix, eigenvaluesOnly);
    }

    @Override
    protected boolean doHermitian(Access2D.Collectable<N, ? super PhysicalStore<N>> matrix, boolean eigenvaluesOnly) {
        return this.myHermitianDelegate.doHermitian(matrix, eigenvaluesOnly);
    }

    @Override
    protected double getDimensionalEpsilon() {
        if (this.myHermitian) {
            return this.myHermitianDelegate.getDimensionalEpsilon();
        }
        return this.myGeneralDelegate.getDimensionalEpsilon();
    }

    @Override
    protected MatrixStore<N> makeD() {
        if (this.myHermitian) {
            return this.myHermitianDelegate.getD();
        }
        return this.myGeneralDelegate.getD();
    }

    @Override
    protected Array1D<ComplexNumber> makeEigenvalues() {
        if (this.myHermitian) {
            return this.myHermitianDelegate.getEigenvalues();
        }
        return this.myGeneralDelegate.getEigenvalues();
    }

    @Override
    protected MatrixStore<N> makeV() {
        if (this.myHermitian) {
            return this.myHermitianDelegate.getV();
        }
        return this.myGeneralDelegate.getV();
    }

    static final class Primitive
    extends DynamicEvD<Double> {
        Primitive() {
            super(PrimitiveDenseStore.FACTORY, new HermitianEvD.SimultaneousPrimitive(), new OldGeneralEvD.Primitive());
        }
    }
}

