/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.transformation;

import java.math.BigDecimal;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.AccessScalar;
import org.ojalgo.algebra.NormedVectorSpace;
import org.ojalgo.constant.BigMath;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.BigFunction;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.transformation.TransformationMatrix;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Scalar;

public interface Householder<N extends Number>
extends TransformationMatrix<N, PhysicalStore<N>>,
Access1D<N> {
    public int first();

    @Override
    default public void transform(PhysicalStore<N> matrix) {
        matrix.transformLeft(this, 0);
    }

    public static final class Primitive
    implements Householder<Double> {
        public double beta;
        public int first;
        public final double[] vector;

        public Primitive(Householder<Double> aTransf) {
            this((int)aTransf.count());
            this.copy(aTransf);
        }

        public Primitive(int aDim) {
            this.vector = new double[aDim];
            this.beta = PrimitiveMath.ZERO;
            this.first = 0;
        }

        private Primitive() {
            this(0);
        }

        public final Primitive copy(Householder<Double> source) {
            this.first = source.first();
            double[] tmpVector = this.vector;
            double tmpVal2 = PrimitiveMath.ZERO;
            int tmpSize = (int)source.count();
            for (int i = source.first(); i < tmpSize; ++i) {
                double tmpVal = source.doubleValue(i);
                tmpVal2 += tmpVal * tmpVal;
                tmpVector[i] = tmpVal;
            }
            this.beta = PrimitiveMath.TWO / tmpVal2;
            return this;
        }

        public final Primitive copy(Householder<Double> source, double precalculatedBeta) {
            this.first = source.first();
            double[] tmpVector = this.vector;
            int tmpSize = (int)source.count();
            for (int i = source.first(); i < tmpSize; ++i) {
                tmpVector[i] = source.doubleValue(i);
            }
            this.beta = precalculatedBeta;
            return this;
        }

        @Override
        public long count() {
            return this.vector.length;
        }

        @Override
        public double doubleValue(long anInd) {
            return this.vector[(int)anInd];
        }

        @Override
        public int first() {
            return this.first;
        }

        @Override
        public Double get(long index) {
            return this.vector[(int)index];
        }

        public String toString() {
            StringBuilder retVal = new StringBuilder("{ ");
            int tmpLastIndex = this.vector.length - 1;
            for (int i = 0; i < tmpLastIndex; ++i) {
                retVal.append(this.get(i));
                retVal.append(", ");
            }
            retVal.append(this.get(tmpLastIndex));
            retVal.append(" }");
            return retVal.toString();
        }
    }

    public static final class Generic<N extends Number>
    implements Householder<N> {
        public N beta;
        public int first;
        public final N[] vector;
        private final Scalar.Factory<N> myFactory;

        public Generic(Scalar.Factory<N> factory, Householder<N> aTransf) {
            this(factory, (int)aTransf.count());
            this.copy(aTransf);
        }

        public Generic(Scalar.Factory<N> factory, int dim) {
            this.vector = factory.newArrayInstance(dim);
            this.beta = factory.zero().get();
            this.first = 0;
            this.myFactory = factory;
        }

        private Generic() {
            this(null, 0);
        }

        public final Generic<N> copy(Householder<N> source) {
            this.first = source.first();
            N[] tmpVector = this.vector;
            double tmpVal2 = PrimitiveMath.ZERO;
            int tmpSize = (int)source.count();
            for (int i = source.first(); i < tmpSize; ++i) {
                Object tmpNmbr = source.get(i);
                double tmpVal = ((NormedVectorSpace)tmpNmbr).norm();
                tmpVal2 += tmpVal * tmpVal;
                tmpVector[i] = tmpNmbr;
            }
            this.beta = this.myFactory.cast(PrimitiveMath.TWO / tmpVal2);
            return this;
        }

        public final Generic<N> copy(Householder<N> source, N precalculatedBeta) {
            this.first = source.first();
            N[] tmpVector = this.vector;
            int tmpSize = (int)source.count();
            for (int i = source.first(); i < tmpSize; ++i) {
                tmpVector[i] = source.get(i);
            }
            this.beta = precalculatedBeta;
            return this;
        }

        @Override
        public long count() {
            return this.vector.length;
        }

        @Override
        public double doubleValue(long anInd) {
            return ((AccessScalar)this.vector[(int)anInd]).doubleValue();
        }

        @Override
        public int first() {
            return this.first;
        }

        @Override
        public N get(long index) {
            return this.vector[(int)index];
        }

        public String toString() {
            int i;
            StringBuilder retVal = new StringBuilder("{");
            int tmpFirst = this.first;
            int tmpLength = this.vector.length;
            for (i = 0; i < tmpFirst; ++i) {
                retVal.append(ComplexNumber.ZERO);
                retVal.append(", ");
            }
            for (i = this.first; i < tmpLength; ++i) {
                retVal.append(this.vector[i]);
                if (i + 1 >= tmpLength) continue;
                retVal.append(", ");
            }
            retVal.append("}");
            return retVal.toString();
        }
    }

    public static final class Complex
    implements Householder<ComplexNumber> {
        public ComplexNumber beta;
        public int first;
        public final ComplexNumber[] vector;

        public Complex(Householder<ComplexNumber> aTransf) {
            this((int)aTransf.count());
            this.copy(aTransf);
        }

        public Complex(int aDim) {
            this.vector = new ComplexNumber[aDim];
            this.beta = ComplexNumber.ZERO;
            this.first = 0;
        }

        private Complex() {
            this(0);
        }

        public final Complex copy(Householder<ComplexNumber> source) {
            this.first = source.first();
            ComplexNumber[] tmpVector = this.vector;
            double tmpVal2 = PrimitiveMath.ZERO;
            int tmpSize = (int)source.count();
            for (int i = source.first(); i < tmpSize; ++i) {
                ComplexNumber tmpNmbr = (ComplexNumber)source.get(i);
                double tmpVal = tmpNmbr.norm();
                tmpVal2 += tmpVal * tmpVal;
                tmpVector[i] = tmpNmbr;
            }
            this.beta = ComplexNumber.valueOf(PrimitiveMath.TWO / tmpVal2);
            return this;
        }

        public final Complex copy(Householder<ComplexNumber> source, ComplexNumber precalculatedBeta) {
            this.first = source.first();
            ComplexNumber[] tmpVector = this.vector;
            int tmpSize = (int)source.count();
            for (int i = source.first(); i < tmpSize; ++i) {
                tmpVector[i] = (ComplexNumber)source.get(i);
            }
            this.beta = precalculatedBeta;
            return this;
        }

        @Override
        public long count() {
            return this.vector.length;
        }

        @Override
        public double doubleValue(long anInd) {
            return this.vector[(int)anInd].doubleValue();
        }

        @Override
        public int first() {
            return this.first;
        }

        @Override
        public ComplexNumber get(long index) {
            return this.vector[(int)index];
        }

        public String toString() {
            int i;
            StringBuilder retVal = new StringBuilder("{");
            int tmpFirst = this.first;
            int tmpLength = this.vector.length;
            for (i = 0; i < tmpFirst; ++i) {
                retVal.append(ComplexNumber.ZERO);
                retVal.append(", ");
            }
            for (i = this.first; i < tmpLength; ++i) {
                retVal.append(this.vector[i]);
                if (i + 1 >= tmpLength) continue;
                retVal.append(", ");
            }
            retVal.append("}");
            return retVal.toString();
        }
    }

    public static final class Big
    implements Householder<BigDecimal> {
        public BigDecimal beta;
        public int first;
        public final BigDecimal[] vector;

        public Big(Householder<BigDecimal> aTransf) {
            this((int)aTransf.count());
            this.copy(aTransf);
        }

        public Big(int aDim) {
            this.vector = new BigDecimal[aDim];
            this.beta = BigMath.ZERO;
            this.first = 0;
        }

        private Big() {
            this(0);
        }

        public final Big copy(Householder<BigDecimal> source) {
            this.first = source.first();
            BigDecimal[] tmpVector = this.vector;
            BigDecimal tmpVal2 = BigMath.ZERO;
            int tmpSize = (int)source.count();
            for (int i = source.first(); i < tmpSize; ++i) {
                BigDecimal tmpVal = (BigDecimal)source.get(i);
                tmpVal2 = BigFunction.ADD.invoke(tmpVal2, BigFunction.MULTIPLY.invoke(tmpVal, tmpVal));
                tmpVector[i] = tmpVal;
            }
            this.beta = BigFunction.DIVIDE.invoke(BigMath.TWO, tmpVal2);
            return this;
        }

        public final Big copy(Householder<BigDecimal> source, BigDecimal precalculatedBeta) {
            this.first = source.first();
            BigDecimal[] tmpVector = this.vector;
            int tmpSize = (int)source.count();
            for (int i = source.first(); i < tmpSize; ++i) {
                tmpVector[i] = (BigDecimal)source.get(i);
            }
            this.beta = precalculatedBeta;
            return this;
        }

        @Override
        public long count() {
            return this.vector.length;
        }

        @Override
        public double doubleValue(long anInd) {
            return this.vector[(int)anInd].doubleValue();
        }

        @Override
        public int first() {
            return this.first;
        }

        @Override
        public BigDecimal get(long index) {
            return this.vector[(int)index];
        }

        public String toString() {
            int i;
            StringBuilder retVal = new StringBuilder("{");
            int tmpFirst = this.first;
            int tmpLength = this.vector.length;
            for (i = 0; i < tmpFirst; ++i) {
                retVal.append(BigMath.ZERO);
                retVal.append(", ");
            }
            for (i = this.first; i < tmpLength; ++i) {
                retVal.append(this.vector[i]);
                if (i + 1 >= tmpLength) continue;
                retVal.append(", ");
            }
            retVal.append("}");
            return retVal.toString();
        }
    }
}

