/*
 * Decompiled with CFR 0.152.
 */
package script.imglib;

import ij.IJ;
import ij.ImagePlus;
import ij.io.FileSaver;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImagePlusAdapter;
import mpicbg.imglib.image.display.imagej.ImageJFunctions;
import mpicbg.imglib.type.numeric.RealType;

public class ImgLib {
    public static <T extends RealType<T>> Image<T> open(String pathOrURL) {
        try {
            return ImgLib.wrap(IJ.openImage((String)pathOrURL));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Got I/O exception: " + e, e);
        }
    }

    public static <T extends RealType<T>> Image<T> wrap(ImagePlus imp) {
        return ImagePlusAdapter.wrap(imp);
    }

    public static final ImagePlus wrap(Image<?> img) {
        return ImageJFunctions.displayAsVirtualStack(img);
    }

    public static <T extends RealType<T>> boolean save(Image<T> image, String path) {
        int dot = path.lastIndexOf(46);
        if (dot < 0 || path.length() - dot - 1 > 4) {
            throw new RuntimeException("Could not infer file type from filename: " + path);
        }
        return ImgLib.save(image, path.substring(dot + 1), path);
    }

    public static <T extends RealType<T>> boolean save(Image<T> image, String fileType, String path) {
        ImagePlus imp = ImageJFunctions.displayAsVirtualStack(image);
        FileSaver saver = new FileSaver(imp);
        if ((fileType = fileType.toLowerCase()).equals("tif") || fileType.equals("tiff")) {
            if (image.getNumDimensions() > 2) {
                return saver.saveAsTiffStack(path);
            }
            return saver.saveAsTiff(path);
        }
        if (fileType.equals("zip")) {
            return saver.saveAsZip(path);
        }
        if (fileType.equals("gif")) {
            return saver.saveAsGif(path);
        }
        if (fileType.equals("jpg") || fileType.equals("jpeg")) {
            return saver.saveAsJpeg(path);
        }
        if (fileType.equals("bmp")) {
            return saver.saveAsBmp(path);
        }
        if (fileType.equals("pgm")) {
            return saver.saveAsPgm(path);
        }
        if (fileType.equals("png")) {
            return saver.saveAsPng(path);
        }
        if (fileType.equals("raw")) {
            return saver.saveAsRaw(path);
        }
        throw new RuntimeException("Unknown fileformat: " + fileType);
    }
}

