/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins;

import ij.IJ;
import ij.ImagePlus;
import java.io.IOException;
import loci.formats.FormatException;
import loci.plugins.in.DisplayHandler;
import loci.plugins.in.ImagePlusReader;
import loci.plugins.in.ImportProcess;
import loci.plugins.in.ImporterOptions;
import loci.plugins.in.ImporterPrompter;

public final class BF {
    private BF() {
    }

    public static void debug(String msg) {
        if (IJ.debugMode) {
            IJ.log((String)("Bio-Formats: " + msg));
        }
    }

    public static void status(boolean quiet, String msg) {
        if (quiet) {
            return;
        }
        IJ.showStatus((String)msg);
    }

    public static void warn(boolean quiet, String msg) {
        if (quiet) {
            return;
        }
        IJ.log((String)("Warning: " + msg));
    }

    public static void progress(boolean quiet, int value, int max) {
        if (quiet) {
            return;
        }
        IJ.showProgress((int)value, (int)max);
    }

    public static ImagePlus[] openImagePlus(String path) throws FormatException, IOException {
        ImporterOptions options = new ImporterOptions();
        options.setId(path);
        return BF.openImagePlus(options);
    }

    public static ImagePlus[] openThumbImagePlus(String path) throws FormatException, IOException {
        ImporterOptions options = new ImporterOptions();
        options.setId(path);
        return BF.openThumbImagePlus(options);
    }

    public static ImagePlus[] openImagePlus(ImporterOptions options) throws FormatException, IOException {
        ImportProcess process = new ImportProcess(options);
        if (!process.execute()) {
            return null;
        }
        DisplayHandler displayHandler = new DisplayHandler(process);
        if (options != null && options.isShowOMEXML()) {
            displayHandler.displayOMEXML();
        }
        ImagePlusReader reader = new ImagePlusReader(process);
        ImagePlus[] imps = reader.openImagePlus();
        if (options != null && options.showROIs()) {
            displayHandler.displayROIs(imps);
        }
        if (!options.isVirtual()) {
            process.getReader().close();
        }
        return imps;
    }

    public static ImagePlus[] openThumbImagePlus(ImporterOptions options) throws FormatException, IOException {
        options.setQuiet(true);
        options.setWindowless(true);
        ImportProcess process = new ImportProcess(options);
        new ImporterPrompter(process);
        if (!process.execute()) {
            return null;
        }
        ImagePlusReader reader = new ImagePlusReader(process);
        ImagePlus[] imps = reader.openThumbImagePlus();
        if (!options.isVirtual()) {
            process.getReader().close();
        }
        return imps;
    }
}

