/*
 * Decompiled with CFR 0.152.
 */
package io.scif.filters;

import io.scif.ByteArrayPlane;
import io.scif.ByteArrayReader;
import io.scif.FormatException;
import io.scif.ImageMetadata;
import io.scif.Plane;
import io.scif.Reader;
import io.scif.config.SCIFIOConfig;
import io.scif.filters.AbstractReaderFilter;
import io.scif.filters.ChannelFillerMetadata;
import io.scif.filters.Filter;
import io.scif.filters.MetadataWrapper;
import java.io.IOException;
import net.imagej.axis.Axes;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.display.ColorTable;
import net.imglib2.util.Intervals;
import org.scijava.io.location.Location;
import org.scijava.plugin.Plugin;
import org.scijava.util.Bytes;

@Plugin(type=Filter.class)
public class ChannelFiller
extends AbstractReaderFilter {
    private int lastImageIndex = -1;
    private long lastPlaneIndex = -1L;
    private Plane lastPlane = null;
    private Interval lastPlaneBounds = null;

    public ChannelFiller() {
        super((Class<? extends MetadataWrapper>)ChannelFillerMetadata.class);
    }

    @Override
    public boolean isCompatible(Class<?> c) {
        return ByteArrayReader.class.isAssignableFrom(c);
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex) throws FormatException, IOException {
        return this.openPlane(imageIndex, planeIndex, new SCIFIOConfig(this.getContext()));
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Plane plane) throws FormatException, IOException {
        return this.openPlane(imageIndex, planeIndex, plane, new SCIFIOConfig(this.getContext()));
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Interval bounds) throws FormatException, IOException {
        return this.openPlane(imageIndex, planeIndex, bounds, new SCIFIOConfig(this.getContext()));
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Plane plane, Interval bounds) throws FormatException, IOException {
        return this.openPlane(imageIndex, planeIndex, plane, bounds, new SCIFIOConfig(this.getContext()));
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, SCIFIOConfig config) throws FormatException, IOException {
        Interval bounds = this.planarBounds(imageIndex);
        return this.openPlane(imageIndex, planeIndex, bounds, config);
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Plane plane, SCIFIOConfig config) throws FormatException, IOException {
        Interval bounds = this.planarBounds(imageIndex);
        return this.openPlane(imageIndex, planeIndex, plane, bounds, config);
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Interval bounds, SCIFIOConfig config) throws FormatException, IOException {
        Plane plane = this.createPlane(this.getMetadata().get(imageIndex), bounds);
        return this.openPlane(imageIndex, planeIndex, plane, bounds, config);
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Plane plane, Interval bounds, SCIFIOConfig config) throws FormatException, IOException {
        if (this.getParentMeta().get(imageIndex).isFalseColor() || !this.getParentMeta().get(imageIndex).isIndexed()) {
            if (!this.haveCached(imageIndex, planeIndex, bounds)) {
                this.lastPlaneBounds = new FinalInterval(bounds);
                this.lastPlaneIndex = planeIndex;
                this.lastImageIndex = imageIndex;
                this.lastPlane = ((Reader)this.getParent()).openPlane(imageIndex, planeIndex, plane, bounds, config);
            }
            return this.lastPlane;
        }
        int lutLength = ((ChannelFillerMetadata)this.getMetadata()).getLutLength();
        if (!this.haveCached(imageIndex, planeIndex, bounds)) {
            this.updateLastPlaneInfo(imageIndex, lutLength, bounds);
            this.lastPlane = ((Reader)this.getParent()).openPlane(imageIndex, planeIndex, this.lastPlaneBounds, config);
            this.lastPlaneIndex = planeIndex;
            this.lastImageIndex = imageIndex;
            this.lastPlaneBounds = bounds;
        }
        ImageMetadata imageMetadata = this.getMetadata().get(imageIndex);
        if (!ByteArrayPlane.class.isAssignableFrom(plane.getClass())) {
            plane = new ByteArrayPlane(imageMetadata, bounds);
        }
        byte[] buf = plane.getBytes();
        int pt = 0;
        int bytesPerIndex = this.getParentMeta().get(imageIndex).getBitsPerPixel() / 8;
        ColorTable lut = this.lastPlane.getColorTable();
        byte[] index = this.lastPlane.getBytes();
        if (imageMetadata.getInterleavedAxisCount() > 0) {
            for (int i = 0; i < index.length / bytesPerIndex && pt < buf.length; ++i) {
                int iVal = Bytes.toInt((byte[])index, (int)(i * bytesPerIndex), (int)bytesPerIndex, (boolean)imageMetadata.isLittleEndian());
                for (int j = 0; j < lutLength; ++j) {
                    buf[pt++] = (byte)lut.get(j, iVal);
                }
            }
        } else {
            for (int j = 0; j < lutLength; ++j) {
                for (int i = 0; i < index.length / bytesPerIndex && pt < buf.length; ++i) {
                    int iVal = Bytes.toInt((byte[])index, (int)(i * bytesPerIndex), (int)bytesPerIndex, (boolean)imageMetadata.isLittleEndian());
                    buf[pt++] = (byte)lut.get(j, iVal);
                }
            }
        }
        plane.setColorTable(null);
        return plane;
    }

    @Override
    protected void setSourceHelper(Location source, SCIFIOConfig config) {
        try {
            this.cleanUp();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public double getPriority() {
        return 1.0;
    }

    private void updateLastPlaneInfo(int imageIndex, int lutLength, Interval bounds) {
        long[] min = Intervals.minAsLongArray((Interval)bounds);
        long[] max = Intervals.maxAsLongArray((Interval)bounds);
        int cIndex = this.getMetadata().get(imageIndex).getAxisIndex(Axes.CHANNEL);
        min[cIndex] = min[cIndex] / (long)lutLength;
        max[cIndex] = max[cIndex] / (long)lutLength;
        this.lastPlaneBounds = new FinalInterval(min, max);
    }

    private boolean haveCached(int imageIndex, long planeIndex, Interval bounds) {
        return planeIndex == this.lastPlaneIndex && imageIndex == this.lastImageIndex && this.lastPlane != null && this.lastPlaneBounds != null && Intervals.equals((Interval)bounds, (Interval)this.lastPlaneBounds);
    }

    @Override
    protected void cleanUp() throws IOException {
        super.cleanUp();
        this.lastPlaneIndex = 0L;
        this.lastImageIndex = 0;
        this.lastPlane = null;
        this.lastPlaneBounds = null;
    }
}

