/*
 * Decompiled with CFR 0.152.
 */
package io.scif.io.location;

import io.scif.util.FormatTools;
import java.net.URI;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.scijava.io.location.AbstractLocation;

public class TestImgLocation
extends AbstractLocation {
    private final Map<String, Object> map = new LinkedHashMap<String, Object>();
    private static final String[] singleValueKeys = new String[]{"planarDims", "interleavedDims", "thumbSizeX", "thumbSizeY", "pixelType", "indexed", "falseColor", "little", "metadataComplete", "thumbnail", "orderCertain", "lutLength", "scaleFactor", "images"};
    private URI uri;

    public static Builder builder() {
        return new Builder();
    }

    public static TestImgLocation defaultTestImg() {
        return new Builder().build();
    }

    public static TestImgLocation fromMap(Map<String, Object> map) {
        TestImgLocation loc = TestImgLocation.defaultTestImg();
        Map<String, Object> metaData = loc.map;
        map.forEach((key, value) -> {
            Object replaced = metaData.computeIfPresent((String)key, (k, v) -> value);
            if (replaced == null) {
                throw new IllegalArgumentException("unknown key:" + key);
            }
        });
        return loc;
    }

    private TestImgLocation(Builder builder) {
        if (builder.lengths.length != builder.axes.length) {
            throw new IllegalArgumentException("Configuration  is not valid. Can not have a differing number of axis types: " + builder.axes.length + "; and axis lengths: " + builder.lengths.length + "!");
        }
        this.map.put("name", builder.name);
        this.map.put("axes", builder.axes);
        this.map.put("lengths", builder.lengths);
        this.map.put("scales", builder.scales);
        this.map.put("units", builder.units);
        this.map.put("planarDims", builder.planarDims);
        this.map.put("interleavedDims", builder.interleavedDims);
        this.map.put("thumbSizeX", builder.thumbSizeX);
        this.map.put("thumbSizeY", builder.thumbSizeY);
        this.map.put("pixelType", builder.pixelType);
        this.map.put("indexed", builder.indexed);
        this.map.put("falseColor", builder.falseColor);
        this.map.put("little", builder.little);
        this.map.put("metadataComplete", builder.metadataComplete);
        this.map.put("thumbnail", builder.thumbnail);
        this.map.put("orderCertain", builder.orderCertain);
        this.map.put("lutLength", builder.lutLength);
        this.map.put("scaleFactor", builder.scaleFactor);
        this.map.put("images", builder.images);
    }

    public Map<String, Object> getMetadataMap() {
        return this.map;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.map == null ? 0 : this.map.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        TestImgLocation other = (TestImgLocation)((Object)obj);
        return !(this.map == null ? other.map != null : !this.map.equals(other.map));
    }

    public String getName() {
        return (String)this.map.get("name") + ".scifioTestImg";
    }

    public URI getURI() {
        if (this.uri == null) {
            this.uri = URI.create(this.getKeyValueStrings());
        }
        return this.uri;
    }

    private String getKeyValueStrings() {
        StringBuilder b = new StringBuilder();
        b.append("scifioTestImg://");
        b.append(this.map.get("name"));
        String regex = "\\[|\\]|\\s";
        b.append("?");
        Stream<Map.Entry> otherEntries = this.map.entrySet().stream().filter(e -> !((String)e.getKey()).equals("name"));
        otherEntries.forEach(e -> {
            b.append((String)e.getKey());
            b.append("=");
            Object val = e.getValue();
            if (val instanceof String[]) {
                b.append(Arrays.toString((String[])val).replaceAll("\\[|\\]|\\s", ""));
            } else if (val instanceof int[]) {
                b.append(Arrays.toString((int[])val).replaceAll("\\[|\\]|\\s", ""));
            } else if (val instanceof long[]) {
                b.append(Arrays.toString((long[])val).replaceAll("\\[|\\]|\\s", ""));
            } else if (val instanceof double[]) {
                b.append(Arrays.toString((double[])val).replaceAll("\\[|\\]|\\s", ""));
            } else if (val instanceof List) {
                b.append(val.toString().replaceAll("\\[|\\]|\\s", ""));
            } else {
                b.append(val.toString());
            }
            b.append("&");
        });
        b.replace(b.length() - 1, b.length(), "");
        return b.toString();
    }

    public String toString() {
        return this.getURI().toString();
    }

    public static class Builder {
        private String name = "testImage";
        private String[] axes = new String[]{"X", "Y"};
        private long[] lengths = new long[]{512L, 512L};
        private double[] scales = new double[]{1.0, 1.0};
        private String[] units = new String[]{"um", "um"};
        private int planarDims = -1;
        private int interleavedDims = -1;
        private int thumbSizeX = 0;
        private int thumbSizeY = 0;
        private String pixelType = FormatTools.getPixelTypeString(1);
        private boolean indexed = false;
        private boolean falseColor = false;
        private boolean little = true;
        private boolean metadataComplete = true;
        private boolean thumbnail = false;
        private boolean orderCertain = true;
        private int lutLength = 3;
        private int scaleFactor = 1;
        private int images = 1;

        public TestImgLocation build() {
            return new TestImgLocation(this);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder axes(String ... axes) {
            this.axes = axes;
            return this;
        }

        public Builder lengths(long ... lengths) {
            this.lengths = lengths;
            return this;
        }

        public Builder scales(double ... scales) {
            this.scales = scales;
            return this;
        }

        public Builder units(String ... units) {
            this.units = units;
            return this;
        }

        public Builder planarDims(int planarDims) {
            this.planarDims = planarDims;
            return this;
        }

        public Builder interleavedDims(int interleavedDims) {
            this.interleavedDims = interleavedDims;
            return this;
        }

        public Builder thumbSizeX(int thumbSizeX) {
            this.thumbSizeX = thumbSizeX;
            return this;
        }

        public Builder thumbSizeY(int thumbSizeY) {
            this.thumbSizeY = thumbSizeY;
            return this;
        }

        public Builder pixelType(String pixelType) {
            this.pixelType = pixelType;
            return this;
        }

        public Builder indexed(boolean indexed) {
            this.indexed = indexed;
            return this;
        }

        public Builder falseColor(boolean falseColor) {
            this.falseColor = falseColor;
            return this;
        }

        public Builder little(boolean little) {
            this.little = little;
            return this;
        }

        public Builder metadataComplete(boolean metadataComplete) {
            this.metadataComplete = metadataComplete;
            return this;
        }

        public Builder thumbnail(boolean thumbnail) {
            this.thumbnail = thumbnail;
            return this;
        }

        public Builder orderCertain(boolean orderCertain) {
            this.orderCertain = orderCertain;
            return this;
        }

        public Builder lutLength(int lutLength) {
            this.lutLength = lutLength;
            return this;
        }

        public Builder scaleFactor(int scaleFactor) {
            this.scaleFactor = scaleFactor;
            return this;
        }

        public Builder images(int images) {
            this.images = images;
            return this;
        }
    }
}

