/*
 * Decompiled with CFR 0.152.
 */
package process3d;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.Toolbar;
import ij.plugin.MacroInstaller;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;

public class Flood_Fill
implements PlugIn {
    private static boolean debug = false;
    private static int tol = 0;
    public static final String MACRO_CMD = "var leftClick=16, alt=9;\nmacro 'Flood Fill Tool - C111O11ffC100T6c0aF' {\n while (true) {\n  getCursorLoc(x, y, z, flags);\n  if (flags&leftClick==0) exit();\n  call('process3d.Flood_Fill.fill', x,y,z);\n  exit(); }\n}\n\n";

    public void run(String arg) {
        MacroInstaller installer = new MacroInstaller();
        installer.install(MACRO_CMD);
    }

    public static synchronized void fill(String x, String y, String z) {
        Flood_Fill.fill(Integer.parseInt(x), Integer.parseInt(y), Integer.parseInt(z));
    }

    public static synchronized void fill(int sx, int sy, int sz) {
        Flood_Fill.fill(IJ.getImage(), sx, sy, sz, Toolbar.getForegroundColor().getRGB());
    }

    public static synchronized void fill(ImagePlus imp, int sx, int sy, int sz, int color) {
        IJ.showStatus((String)"Flood fill");
        long start = System.currentTimeMillis();
        int w = imp.getWidth();
        int h = imp.getHeight();
        int d = imp.getStackSize();
        int wh = w * h;
        ImageProcessor[] b = new ImageProcessor[d];
        for (int z = 0; z < d; ++z) {
            b[z] = imp.getStack().getProcessor(z + 1);
        }
        Difference diff = null;
        if (b[0] instanceof ByteProcessor) {
            diff = new DifferenceInt();
        } else if (b[0] instanceof ShortProcessor) {
            diff = new DifferenceInt();
        } else if (b[0] instanceof FloatProcessor) {
            diff = new DifferenceFloat();
        } else if (b[0] instanceof ColorProcessor) {
            diff = new DifferenceRGB();
        }
        int colorToFill = b[sz].get(sx, sy);
        Stack stack = new Stack();
        stack.push(sz * wh + sy * w + sx);
        while (!stack.isEmpty()) {
            int py;
            int pi;
            int px;
            int p = stack.pop();
            int pz = p / wh;
            int by = b[pz].get(px = (pi = p % wh) % w, py = pi / w);
            if (diff.getDifference(by, colorToFill) > (float)tol) continue;
            b[pz].set(px, py, color);
            int pzwh = pz * wh;
            if (px > 0 && b[pz].get(px - 1, py) != color) {
                stack.push(pzwh + pi - 1);
            }
            if (px < w - 1 && b[pz].get(px + 1, py) != color) {
                stack.push(pzwh + pi + 1);
            }
            if (py > 0 && b[pz].get(px, py - 1) != color) {
                stack.push(pzwh + pi - w);
            }
            if (py < h - 1 && b[pz].get(px, py + 1) != color) {
                stack.push(pzwh + pi + w);
            }
            if (pz > 0 && b[pz - 1].get(px, py) != color) {
                stack.push((pz - 1) * wh + pi);
            }
            if (pz >= d - 1 || b[pz + 1].get(px, py) == color) continue;
            stack.push((pz + 1) * wh + pi);
        }
        imp.updateAndDraw();
        long end = System.currentTimeMillis();
        System.out.println("Needed " + (end - start) / 1000L + " seconds");
        IJ.showStatus((String)"");
    }

    static final class Stack {
        private int[] array = new int[1000000];
        private int size = 0;

        Stack() {
        }

        public void push(int n) {
            if (this.size == this.array.length) {
                int[] tmp = new int[this.array.length + 1000000];
                System.arraycopy(this.array, 0, tmp, 0, this.array.length);
                this.array = tmp;
            }
            this.array[this.size] = n;
            ++this.size;
        }

        public int pop() {
            --this.size;
            return this.array[this.size];
        }

        public int size() {
            return this.size;
        }

        public boolean isEmpty() {
            return this.size == 0;
        }
    }

    static final class DifferenceFloat
    implements Difference {
        DifferenceFloat() {
        }

        @Override
        public float getDifference(int p1, int p2) {
            return Math.abs(Float.intBitsToFloat(p2) - Float.intBitsToFloat(p1));
        }
    }

    static final class DifferenceRGB
    implements Difference {
        DifferenceRGB() {
        }

        @Override
        public final float getDifference(int p1, int p2) {
            return (float)Math.abs((p1 & 0xFF0000) >> 16 - (p2 & 0xFF0000) >> 16) + (float)Math.abs((p1 & 0xFF00) >> 8 - (p2 & 0xFF00) >> 8) + (float)Math.abs((p1 & 0xFF) - (p2 & 0xFF));
        }
    }

    static final class DifferenceInt
    implements Difference {
        DifferenceInt() {
        }

        @Override
        public float getDifference(int p1, int p2) {
            return Math.abs(p2 - p1);
        }
    }

    static interface Difference {
        public float getDifference(int var1, int var2);
    }
}

