/*
 * Decompiled with CFR 0.152.
 */
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

public class IntField
extends TextField
implements FocusListener {
    private int value;
    private int minValue;
    private int maxValue;
    private String actionCommand;

    public IntField() {
        this(0);
    }

    public IntField(int value) {
        this(value, Integer.MIN_VALUE, Integer.MAX_VALUE, 3, "IntField value changed");
    }

    public IntField(int value, int minValue, int maxValue) {
        this(value, minValue, maxValue, Math.max(Integer.toString(minValue).length(), Integer.toString(maxValue).length()), "IntField value changed");
    }

    public IntField(int value, int minValue, int maxValue, int columns) {
        this(value, minValue, maxValue, columns, "IntField value changed");
    }

    public IntField(int value, int minValue, int maxValue, int columns, String actionCommand) {
        super(Integer.toString(value), columns);
        if (columns <= 0) {
            throw new IllegalArgumentException("Too few Columns in IntField.");
        }
        if (value < minValue || value > maxValue) {
            throw new IllegalArgumentException("value, minValue and maxValue of IntField are inconsistent.");
        }
        this.value = value;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.actionCommand = actionCommand;
        this.enableEvents(128L);
        this.addFocusListener(this);
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int newValue) {
        this.setValue(newValue, false);
    }

    public void setValue(int newValue, boolean sendEvent) {
        if (newValue >= this.minValue && newValue <= this.maxValue) {
            if (newValue != this.value) {
                if (sendEvent) {
                    this.setText(Integer.toString(newValue));
                    this.processEvent(new ActionEvent(this, 1001, this.actionCommand));
                } else {
                    this.value = newValue;
                    this.setText(Integer.toString(newValue));
                }
            }
        } else {
            throw new IllegalArgumentException("value out of range: " + newValue);
        }
    }

    public void setActionCommand(String newCommand) {
        this.actionCommand = newCommand;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    @Override
    protected void processActionEvent(ActionEvent e) {
        if (e.getSource() == this) {
            int tempValue;
            try {
                tempValue = Integer.parseInt(this.getText());
            }
            catch (NumberFormatException ex) {
                this.setText(Integer.toString(this.value));
                return;
            }
            if (tempValue >= this.minValue && tempValue <= this.maxValue && tempValue != this.value) {
                this.value = tempValue;
                super.processActionEvent(new ActionEvent(this, e.getID(), this.actionCommand, e.getModifiers()));
            }
            this.setText(Integer.toString(this.value));
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() == this) {
            this.processEvent(new ActionEvent(this, 1001, this.actionCommand));
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }
}

