/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.parser;

import com.google.common.base.Strings;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.scijava.ops.parser.InvalidOpException;
import org.scijava.ops.parser.OpParameter;
import org.yaml.snakeyaml.Yaml;

public final class OpParser {
    private static final String NS_KEY = "namespace";
    private static final String VERSION_KEY = "version";
    private static final String AUTHOR_KEY = "authors";
    private static final String PRIORITY_KEY = "priority";
    private static final String ALIAS_KEY = "alias";
    private static final String TYPE_KEY = "type";
    private static final String DESCRIPTION_KEY = "description";

    public static void main(String ... args) throws ClassNotFoundException {
        if (args.length < 1) {
            throw new RuntimeException("OpParser requires at least one argument: a YAML file containing mappings of fully-qualified class names to subsequent mappings of static methods (without params) inthat class to op names.");
        }
        String opYaml = OpParser.parseOpDocument(args[0]);
        try {
            OpParser.outputYamlDoc(opYaml);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String parseOpDocument(String inputYamlPath) throws ClassNotFoundException {
        Map opsYaml;
        Yaml configYaml = new Yaml();
        String namespace = null;
        ArrayList<OpData> ops = new ArrayList<OpData>();
        List<Object> authors = new ArrayList();
        String version = "unknown";
        try (FileReader reader = new FileReader(inputYamlPath);){
            opsYaml = (Map)configYaml.load(reader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (opsYaml.containsKey(NS_KEY)) {
            namespace = (String)opsYaml.remove(NS_KEY);
        }
        if (opsYaml.containsKey(VERSION_KEY)) {
            version = (String)opsYaml.remove(VERSION_KEY);
        }
        if (opsYaml.containsKey(AUTHOR_KEY)) {
            authors = OpParser.getListHelper(AUTHOR_KEY, opsYaml);
            opsYaml.remove(AUTHOR_KEY);
        }
        for (Map.Entry opDeclaration : opsYaml.entrySet()) {
            String className = (String)opDeclaration.getKey();
            Class<?> clazz = Class.forName(className);
            Multimap<String, Method> methods = OpParser.makeMultimap(clazz);
            Map opMethods = (Map)opDeclaration.getValue();
            for (Map.Entry opMethod : opMethods.entrySet()) {
                String methodName = (String)opMethod.getKey();
                ArrayList<String> opNames = new ArrayList<String>();
                Map opMetadata = (Map)opMethod.getValue();
                String opType = opMetadata.getOrDefault(TYPE_KEY, "");
                String description = opMetadata.getOrDefault(DESCRIPTION_KEY, "");
                double priority = Double.parseDouble(opMetadata.getOrDefault(PRIORITY_KEY, "0.0"));
                if (opMetadata.containsKey(ALIAS_KEY)) {
                    Object alias = opMetadata.get(ALIAS_KEY);
                    if (alias instanceof String) {
                        opNames.add((String)alias);
                    } else if (alias instanceof List) {
                        opNames.addAll((List)alias);
                    }
                } else {
                    opNames.add("ext." + methodName);
                }
                ArrayList<String> opAuthors = authors;
                if (opMetadata.containsKey(AUTHOR_KEY)) {
                    opAuthors = OpParser.getListHelper(AUTHOR_KEY, opMetadata);
                }
                if (namespace != null) {
                    opNames.add(namespace + "." + methodName);
                }
                if (!methods.containsKey(methodName)) {
                    throw new InvalidOpException("No method named " + methodName + " in class " + className);
                }
                for (Method method : methods.get(methodName)) {
                    HashMap<String, Object> tags = new HashMap<String, Object>();
                    ArrayList<OpParameter> params = new ArrayList<OpParameter>();
                    String opSource = OpParser.parseOpSource(className, methodName, method.getParameterTypes());
                    OpParser.parseParams(method, params, tags, opType);
                    OpData data = new OpData(opSource, version, opNames, params, tags, opAuthors, priority, description);
                    ops.add(data);
                }
            }
        }
        List data = ops.stream().map(OpData::dumpData).collect(Collectors.toList());
        return new Yaml().dump(data);
    }

    private static List<String> getListHelper(String key, Map<String, Object> map) {
        Object value = map.get(key);
        if (value instanceof List) {
            return (List)value;
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add((String)value);
        return result;
    }

    private static String parseOpSource(String className, String methodName, Class<?>[] parameterTypes) {
        return "javaMethod:/" + URLEncoder.encode(className + "." + methodName + Arrays.stream(parameterTypes).map(Class::getName).collect(Collectors.joining(",", "(", ")")), StandardCharsets.UTF_8);
    }

    private static void parseParams(Method method, List<OpParameter> params, Map<String, Object> tags, String type) {
        int containerIndex = -1;
        if (!Strings.isNullOrEmpty(type)) {
            containerIndex = Integer.parseInt(type.substring(type.length() - 1)) - 1;
        }
        Class<?>[] types = method.getParameterTypes();
        for (int i = 0; i < types.length; ++i) {
            String className = types[i].getName();
            OpParameter.IO_TYPE ioType = OpParameter.IO_TYPE.INPUT;
            String paramName = method.getParameters()[i].getName();
            if (i == containerIndex) {
                ioType = OpParameter.IO_TYPE.CONTAINER;
                tags.put(TYPE_KEY, type);
            }
            params.add(new OpParameter(paramName, className, ioType, ""));
        }
        if (containerIndex < 0) {
            method.getReturnType();
            OpParameter.IO_TYPE ioType = OpParameter.IO_TYPE.OUTPUT;
            String paramName = "output";
            params.add(new OpParameter(paramName, method.getReturnType().getName(), ioType, ""));
        }
    }

    private static Multimap<String, Method> makeMultimap(Class<?> clazz) {
        SetMultimap multimap = MultimapBuilder.treeKeys().treeSetValues(OpParser::compareParamCount).build();
        for (Method m : clazz.getMethods()) {
            multimap.put(m.getName(), m);
        }
        return multimap;
    }

    private static int compareParamCount(Method m1, Method m2) {
        int result = Integer.compare(m1.getParameterCount(), m2.getParameterCount());
        for (int i = 0; result == 0 && i < m1.getParameterCount(); ++i) {
            result = m1.getParameterTypes()[i].getName().compareTo(m2.getParameterTypes()[i].getName());
        }
        return result;
    }

    private static void outputYamlDoc(String opYaml) throws IOException {
        File f = new File("ops.yaml");
        try (FileOutputStream os = new FileOutputStream(f);){
            ((OutputStream)os).write(opYaml.getBytes(StandardCharsets.UTF_8));
        }
    }

    private static class OpData {
        private final Map<String, Object> tags;
        private final List<String> names;
        private final List<OpParameter> params;
        private final String source;
        private final String version;
        private final double priority;
        private final String description;
        private final List<String> authors;

        public OpData(String source, String version, List<String> names, List<OpParameter> params, Map<String, Object> tags, List<String> authors, double priority, String description) {
            this.source = source;
            this.version = version;
            this.names = names;
            this.params = params;
            this.tags = tags;
            this.authors = authors;
            this.priority = priority;
            this.description = description;
            this.validateOpData();
        }

        private void validateOpData() {
            if (Objects.isNull(this.names) || this.names.isEmpty()) {
                throw new InvalidOpException("Invalid Op defined in : " + this.source + ". Op names cannot be empty!");
            }
            int outputs = 0;
            for (OpParameter p : this.params) {
                if (!p.ioType.equals((Object)OpParameter.IO_TYPE.OUTPUT)) continue;
                ++outputs;
            }
            if (outputs > 1) {
                throw new InvalidOpException("Invalid Op defined in : " + this.source + ". Ops cannot have more than one output!");
            }
        }

        public Map<String, Object> dumpData() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("source", this.source);
            map.put(OpParser.VERSION_KEY, this.version);
            map.put("names", this.names.toArray(String[]::new));
            map.put(OpParser.DESCRIPTION_KEY, this.description);
            map.put(OpParser.PRIORITY_KEY, this.priority);
            map.put(OpParser.AUTHOR_KEY, this.authors.toArray(String[]::new));
            List foo = this.params.stream().map(OpParameter::data).collect(Collectors.toList());
            map.put("parameters", foo.toArray(Map[]::new));
            map.put("tags", this.tags);
            return Collections.singletonMap("op", map);
        }
    }
}

