/*
 * Decompiled with CFR 0.152.
 */
package VolumeJ;

import VolumeJ.VJInterpolator;
import VolumeJ.VJTrilinear;
import VolumeJ.VJUserInterface;
import VolumeJ.VJVoxelLoc;
import volume.Volume;

public class VJProjection {
    private static final int BYTE = 1;
    private static final int SHORT = 2;
    private static final int FLOAT = 4;
    private static final int INT = 3;
    protected int type;
    protected float[] theta;
    protected Object[] sliceArray;
    protected int n;
    protected int sliceWidth;
    protected int sliceHeight;

    public VJProjection(double deltaAngle, Object[] sliceArray, int n, int width, int height) {
        this.sliceArray = sliceArray;
        this.n = n;
        this.sliceWidth = width;
        this.sliceHeight = height;
        this.type = this.getType(sliceArray);
        this.buildAngles(deltaAngle, n);
    }

    public Object[] getImageArray() {
        return this.sliceArray;
    }

    public int getWidth() {
        return this.sliceWidth;
    }

    public int getHeight() {
        return this.sliceHeight;
    }

    protected int getType(Object[] array) {
        if (array[0] instanceof byte[]) {
            return 1;
        }
        if (array[0] instanceof short[]) {
            return 2;
        }
        if (array[0] instanceof float[]) {
            return 4;
        }
        if (array[0] instanceof int[]) {
            return 3;
        }
        return 0;
    }

    protected void buildAngles(double deltaAngle, int n) {
        float angle = 0.0f;
        this.theta = new float[n];
        for (int i = 0; i < n; ++i) {
            this.theta[i] = angle;
            angle = (float)((double)angle + deltaAngle);
        }
    }

    public int n() {
        return this.n;
    }

    public void backproject(Volume v) {
        int width = v.getWidth();
        int cvx = v.getWidth() / 2;
        int cvy = v.getHeight() / 2;
        int cvz = v.getDepth() / 2;
        int cix = this.sliceWidth / 2;
        VJTrilinear interpolator = new VJTrilinear();
        for (int i = 0; i < this.n; ++i) {
            float currentTheta = this.theta[i];
            float costheta = (float)Math.cos(currentTheta);
            float sintheta = (float)Math.sin(currentTheta);
            for (int z = 0; z < v.getDepth(); ++z) {
                for (int y = 0; y < v.getHeight(); ++y) {
                    for (int x = 0; x < v.getWidth(); ++x) {
                        StringBuffer sb = new StringBuffer("Backproject ");
                        sb.append(this.theta[i]);
                        sb.append("degrees ");
                        sb.append(z * 100 / v.getDepth());
                        sb.append("%");
                        VJUserInterface.status(sb.toString());
                        VJVoxelLoc vl = new VJVoxelLoc(x, y, z);
                        if (!((VJInterpolator)interpolator).isValid(vl, v)) continue;
                        float vx = x - cvx;
                        float vy = y - cvy;
                        float d = vx * costheta + vy * sintheta;
                        float imagex = d + (float)cix;
                        int imageix = (int)imagex;
                        float dx = imagex - (float)imageix;
                        if (!VJTrilinear.valid(v.getWidth(), v.getHeight(), imageix, y)) continue;
                        float value = this.type == 1 ? VJTrilinear.value((byte[])this.sliceArray[i], width, imageix, z, dx, 0.0f) : (this.type == 2 ? VJTrilinear.value((short[])this.sliceArray[i], width, imageix, z, dx, 0.0f) : (this.type == 4 ? VJTrilinear.value((float[])this.sliceArray[i], width, imageix, z, dx, 0.0f) : 0.0f));
                        float sum = ((Number)v.get(x, y, z)).floatValue() + value;
                        v.set(new Float(sum), x, y, z);
                    }
                }
            }
        }
    }
}

