/*
 * Decompiled with CFR 0.152.
 */
package volume;

import volume.Gaussian3D;

public class DoG3D
extends Gaussian3D {
    public DoG3D(double sigma) {
        this.sigma = sigma;
        if (sigma != 0.0) {
            int width = (int)(6.0 * (sigma * 1.6) + 1.0);
            if (width % 2 == 0) {
                ++width;
            }
            this.halfwidth = width / 2;
            this.k = new double[this.halfwidth * 2 + 1][this.halfwidth * 2 + 1][this.halfwidth * 2 + 1];
            for (int n = -this.halfwidth; n <= this.halfwidth; ++n) {
                for (int m = -this.halfwidth; m <= this.halfwidth; ++m) {
                    for (int l = -this.halfwidth; l <= this.halfwidth; ++l) {
                        this.k[n + this.halfwidth][m + this.halfwidth][l + this.halfwidth] = this.function(l, m, n);
                    }
                }
            }
        } else {
            this.halfwidth = 0;
        }
    }

    @Override
    protected double function(double x, double y, double z) {
        return 1.0 / (Math.pow(Math.PI * 2, 2.0) * Math.pow(this.sigma, 3.0)) * Math.exp(-(x * x + y * y + z * z) / (2.0 * Math.pow(this.sigma, 2.0))) - 1.0 / (Math.pow(Math.PI * 2, 2.0) * Math.pow(this.sigma * 1.6, 3.0)) * Math.exp(-(x * x + y * y + z * z) / (2.0 * Math.pow(this.sigma * 1.6, 2.0)));
    }

    @Override
    public String toString() {
        return "DoG 2D " + this.sigma;
    }
}

