/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.audioengines.javasound;

import org.jogamp.java3d.audioengines.AudioEngine3D;
import org.jogamp.java3d.audioengines.AudioEngine3DL2;
import org.jogamp.java3d.audioengines.AudioEngineThread;
import org.jogamp.java3d.audioengines.javasound.JSAuralParameters;
import org.jogamp.java3d.audioengines.javasound.JSSample;

class JSThread
extends AudioEngineThread {
    int totalChannels = 0;
    boolean rampGain = false;
    boolean rampRate = false;
    AudioEngine3D audioEngine = null;

    JSThread(ThreadGroup t, AudioEngine3DL2 engine) {
        super(t, "J3D-JavaSoundThread");
        this.audioEngine = engine;
        this.totalChannels = 32;
    }

    @Override
    public synchronized void doWork() {
        int numSamples = this.audioEngine.getSampleListSize();
        JSSample sample = null;
        int numRateRamps = 0;
        for (int index = 0; index < numSamples; ++index) {
            sample = (JSSample)this.audioEngine.getSample(index);
            if (sample == null || !sample.getRampRateFlag()) continue;
            boolean endOfRampReached = this.adjustRate(sample);
            sample.setRampRateFlag(!endOfRampReached);
            if (endOfRampReached) continue;
            ++numRateRamps;
        }
        if (numRateRamps > 0) {
            this.rampRate = true;
            this.runMonitor(2, 0L, null);
        } else {
            this.rampRate = false;
        }
    }

    int getTotalChannels() {
        return this.totalChannels;
    }

    boolean adjustRate(JSSample sample) {
        double maxRateChangeDown = 0.00130213;
        double maxRateChangeUp = 0.00260417;
        double lastActualRateRatio = sample.getCurrentRateRatio();
        double requestedRateRatio = sample.getTargetRateRatio();
        boolean endOfRamp = false;
        if (lastActualRateRatio > 0.0) {
            double sampleRateRatio = requestedRateRatio;
            double diff = 0.0;
            diff = requestedRateRatio - lastActualRateRatio;
            if (diff > 0.0) {
                if (diff >= maxRateChangeUp) {
                    sampleRateRatio = lastActualRateRatio + maxRateChangeUp;
                    endOfRamp = false;
                } else {
                    sampleRateRatio = requestedRateRatio;
                    endOfRamp = true;
                }
            } else if (diff < 0.0) {
                if (-diff >= maxRateChangeDown) {
                    sampleRateRatio = lastActualRateRatio - maxRateChangeDown;
                    endOfRamp = false;
                } else {
                    sampleRateRatio = requestedRateRatio;
                    endOfRamp = true;
                }
            } else {
                return true;
            }
            this.setSampleRate(sample, (float)sampleRateRatio);
        } else {
            this.setSampleRate(sample, (float)requestedRateRatio);
            endOfRamp = false;
        }
        return endOfRamp;
    }

    void setSampleRate(JSSample sample, JSAuralParameters attribs) {
    }

    void setSampleGain(JSSample sample, JSAuralParameters attribs) {
    }

    void setSampleDelay(JSSample sample, JSAuralParameters attribs) {
    }

    void setTargetGain(JSSample sample, float scaleFactor) {
    }

    void setRate(JSSample sample, float rateScaleFactor) {
        this.setSampleRate(sample, rateScaleFactor);
        sample.setRampRateFlag(false);
    }

    void setTargetRate(JSSample sample, float rateScaleFactor) {
        sample.setRampRateFlag(true);
        sample.setTargetRateRatio(rateScaleFactor);
        this.rampRate = true;
        this.runMonitor(2, 0L, null);
    }

    void setSampleGain(JSSample sample, float gain) {
    }

    void setSampleRate(JSSample sample, float scaleFactor) {
        sample.setCurrentRateRatio(scaleFactor);
    }

    boolean startSample(JSSample sample) {
        return true;
    }

    boolean stopSample(JSSample sample) {
        return true;
    }

    void pauseSample(JSSample sample) {
    }

    void unpauseSample(JSSample sample) {
    }

    void muteSample(JSSample sample) {
    }

    void unmuteSample(JSSample sample) {
    }

    int startStreams() {
        return 0;
    }

    int startStream() {
        return 0;
    }

    int startClips() {
        return 0;
    }

    int startClip() {
        return 0;
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    boolean close() {
        return false;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void cleanup() {
        super.cleanup();
    }
}

