/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.universe;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import org.jogamp.java3d.BoundingSphere;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.utils.universe.ConfigCommand;
import org.jogamp.java3d.utils.universe.ConfigContainer;
import org.jogamp.vecmath.Matrix3d;
import org.jogamp.vecmath.Matrix4d;
import org.jogamp.vecmath.Point2d;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Point4d;
import org.jogamp.vecmath.Vector3d;

class ConfigSexpression {
    private ArrayList elements = new ArrayList();

    ConfigSexpression() {
    }

    private void syntaxError(StreamTokenizer st, String file, String s) {
        System.out.println(s + ":\nat line " + st.lineno() + " in " + file);
        this.print();
        System.out.print("\n\n");
    }

    private int myNextToken(StreamTokenizer st, String file) {
        int tok = 0;
        try {
            tok = st.nextToken();
        }
        catch (IOException e) {
            throw new RuntimeException(e + "\nwhile reading " + file);
        }
        return tok;
    }

    Object parseAndEval(ConfigContainer configContainer, StreamTokenizer st, int level) {
        int tok;
        String file = configContainer.currentFileName;
        this.elements.clear();
        do {
            if ((tok = this.myNextToken(st, file)) == -1) {
                return Boolean.FALSE;
            }
            if (tok != 41) continue;
            this.syntaxError(st, file, "Premature closing parenthesis");
        } while (tok != 40);
        int i = 0;
        while (true) {
            if ((tok = this.myNextToken(st, file)) == -1) {
                this.syntaxError(st, file, "Missing closing parenthesis");
                break;
            }
            if (tok == 40) {
                st.pushBack();
                ConfigSexpression cs = new ConfigSexpression();
                this.elements.add(cs.parseAndEval(configContainer, st, level + 1));
            } else {
                if (tok == 41) break;
                if (i >= 20) {
                    this.syntaxError(st, file, "Too many arguments");
                }
                if (tok == -2) {
                    this.elements.add(new Double(st.nval));
                } else if (tok != -3 && tok != 34 && tok != 39) {
                    String badToken = String.valueOf((char)tok);
                    this.elements.add(badToken);
                    this.syntaxError(st, file, "Invalid token \"" + badToken + "\" must be enclosed in quotes");
                } else {
                    String s = this.scanJavaProperties(st, file, st.sval);
                    if (s != null) {
                        if (s.equalsIgnoreCase("true")) {
                            this.elements.add(new Boolean(true));
                        } else if (s.equalsIgnoreCase("false")) {
                            this.elements.add(new Boolean(false));
                        } else {
                            this.elements.add(s);
                        }
                    }
                }
            }
            ++i;
        }
        if (this.elements.size() == 0) {
            this.syntaxError(st, file, "Null command");
        }
        if (this.elements.get(0) instanceof String) {
            try {
                if (level == 0) {
                    configContainer.evaluateCommand(this.elements, st.lineno());
                    return Boolean.TRUE;
                }
                return this.evaluateBuiltIn(configContainer, this.elements, st.lineno());
            }
            catch (IllegalArgumentException e) {
                this.syntaxError(st, file, e.getMessage());
                if (level == 0) {
                    return Boolean.TRUE;
                }
                return this;
            }
        }
        if (level == 0) {
            this.syntaxError(st, file, "Malformed top-level command name");
        }
        if (this.elements.get(0) instanceof Double) {
            if (this.elements.size() == 1) {
                this.syntaxError(st, file, "Can't have single-element vector");
            }
            if (this.elements.size() == 2) {
                if (!(this.elements.get(1) instanceof Double)) {
                    this.syntaxError(st, file, "Both elements must be numbers");
                }
                return new Point2d(((Double)this.elements.get(0)).doubleValue(), ((Double)this.elements.get(1)).doubleValue());
            }
            if (this.elements.size() == 3) {
                if (!(this.elements.get(1) instanceof Double) || !(this.elements.get(2) instanceof Double)) {
                    this.syntaxError(st, file, "All elements must be numbers");
                }
                return new Point3d(((Double)this.elements.get(0)).doubleValue(), ((Double)this.elements.get(1)).doubleValue(), ((Double)this.elements.get(2)).doubleValue());
            }
            if (this.elements.size() == 4) {
                if (!(this.elements.get(1) instanceof Double && this.elements.get(2) instanceof Double && this.elements.get(3) instanceof Double)) {
                    this.syntaxError(st, file, "All elements must be numbers");
                }
                return new Point4d(((Double)this.elements.get(0)).doubleValue(), ((Double)this.elements.get(1)).doubleValue(), ((Double)this.elements.get(2)).doubleValue(), ((Double)this.elements.get(3)).doubleValue());
            }
            this.syntaxError(st, file, "Too many vector elements");
        }
        if (this.elements.get(0) instanceof Point3d) {
            if (this.elements.size() != 3) {
                this.syntaxError(st, file, "Matrix must have three rows");
            }
            if (!(this.elements.get(1) instanceof Point3d) || !(this.elements.get(2) instanceof Point3d)) {
                this.syntaxError(st, file, "All rows must have three elements");
            }
            return new Matrix3d(((Point3d)this.elements.get((int)0)).x, ((Point3d)this.elements.get((int)0)).y, ((Point3d)this.elements.get((int)0)).z, ((Point3d)this.elements.get((int)1)).x, ((Point3d)this.elements.get((int)1)).y, ((Point3d)this.elements.get((int)1)).z, ((Point3d)this.elements.get((int)2)).x, ((Point3d)this.elements.get((int)2)).y, ((Point3d)this.elements.get((int)2)).z);
        }
        if (this.elements.get(0) instanceof Point4d) {
            if (this.elements.size() == 3) {
                if (!(this.elements.get(1) instanceof Point4d) || !(this.elements.get(2) instanceof Point4d)) {
                    this.syntaxError(st, file, "All rows must have four elements");
                }
                return new Matrix4d(((Point4d)this.elements.get((int)0)).x, ((Point4d)this.elements.get((int)0)).y, ((Point4d)this.elements.get((int)0)).z, ((Point4d)this.elements.get((int)0)).w, ((Point4d)this.elements.get((int)1)).x, ((Point4d)this.elements.get((int)1)).y, ((Point4d)this.elements.get((int)1)).z, ((Point4d)this.elements.get((int)1)).w, ((Point4d)this.elements.get((int)2)).x, ((Point4d)this.elements.get((int)2)).y, ((Point4d)this.elements.get((int)2)).z, ((Point4d)this.elements.get((int)2)).w, 0.0, 0.0, 0.0, 1.0);
            }
            if (this.elements.size() != 4) {
                this.syntaxError(st, file, "Matrix must have three or four rows");
            }
            if (!(this.elements.get(1) instanceof Point4d && this.elements.get(2) instanceof Point4d && this.elements.get(3) instanceof Point4d)) {
                this.syntaxError(st, file, "All rows must have four elements");
            }
            return new Matrix4d(((Point4d)this.elements.get((int)0)).x, ((Point4d)this.elements.get((int)0)).y, ((Point4d)this.elements.get((int)0)).z, ((Point4d)this.elements.get((int)0)).w, ((Point4d)this.elements.get((int)1)).x, ((Point4d)this.elements.get((int)1)).y, ((Point4d)this.elements.get((int)1)).z, ((Point4d)this.elements.get((int)1)).w, ((Point4d)this.elements.get((int)2)).x, ((Point4d)this.elements.get((int)2)).y, ((Point4d)this.elements.get((int)2)).z, ((Point4d)this.elements.get((int)2)).w, ((Point4d)this.elements.get((int)3)).x, ((Point4d)this.elements.get((int)3)).y, ((Point4d)this.elements.get((int)3)).z, ((Point4d)this.elements.get((int)3)).w);
        }
        this.syntaxError(st, file, "Syntax error");
        return null;
    }

    private String scanJavaProperties(StreamTokenizer st, String f, String s) {
        int open = s.indexOf("${");
        if (open == -1) {
            return s;
        }
        int close = 0;
        StringBuffer buf = new StringBuffer();
        while (open != -1) {
            buf.append(s.substring(close, open));
            close = s.indexOf(125, open);
            if (close == -1) {
                this.elements.add(s);
                this.syntaxError(st, f, "Java property substitution syntax error");
                return null;
            }
            String property = s.substring(open + 2, close);
            String value = ConfigCommand.evaluateJavaProperty(property);
            if (value == null) {
                this.elements.add(s);
                this.syntaxError(st, f, "Java property \"" + property + "\" has a null value");
                return null;
            }
            buf.append(value);
            open = s.indexOf("${", close);
            ++close;
        }
        buf.append(s.substring(close));
        return buf.toString();
    }

    private Object evaluateBuiltIn(ConfigContainer configContainer, ArrayList elements, int lineNumber) {
        int argc = elements.size();
        String functionName = (String)elements.get(0);
        if (functionName.equals("Rotate")) {
            return this.makeRotate(elements);
        }
        if (functionName.equals("Translate")) {
            return this.makeTranslate(elements);
        }
        if (functionName.equals("RotateTranslate") || functionName.equals("TranslateRotate") || functionName.equals("Concatenate")) {
            return this.concatenate(elements);
        }
        if (functionName.equals("BoundingSphere")) {
            return this.makeBoundingSphere(elements);
        }
        return new ConfigCommand(elements, configContainer.currentFileName, lineNumber);
    }

    private Matrix4d makeTranslate(ArrayList elements) {
        if (elements.size() != 4) {
            throw new IllegalArgumentException("Incorrect number of arguments to Translate");
        }
        if (!(elements.get(1) instanceof Double && elements.get(2) instanceof Double && elements.get(3) instanceof Double)) {
            throw new IllegalArgumentException("All arguments to Translate must be numbers");
        }
        Matrix4d m4d = new Matrix4d();
        m4d.set(new Vector3d(((Double)elements.get(1)).doubleValue(), ((Double)elements.get(2)).doubleValue(), ((Double)elements.get(3)).doubleValue()));
        return m4d;
    }

    private Matrix4d makeRotate(ArrayList elements) {
        if (elements.size() != 4) {
            throw new IllegalArgumentException("Incorrect number of arguments to Rotate");
        }
        if (!(elements.get(1) instanceof Double && elements.get(2) instanceof Double && elements.get(3) instanceof Double)) {
            throw new IllegalArgumentException("All arguments to Rotate must be numbers");
        }
        double x = Math.toRadians((Double)elements.get(1));
        double y = Math.toRadians((Double)elements.get(2));
        double z = Math.toRadians((Double)elements.get(3));
        Transform3D t3d = new Transform3D();
        t3d.setEuler(new Vector3d(x, y, z));
        Matrix4d m4d = new Matrix4d();
        t3d.get(m4d);
        return m4d;
    }

    private Matrix4d concatenate(ArrayList elements) {
        String functionName = (String)elements.get(0);
        if (elements.size() != 3) {
            throw new IllegalArgumentException("Incorrect number of arguments to " + functionName);
        }
        if (!(elements.get(1) instanceof Matrix4d) || !(elements.get(2) instanceof Matrix4d)) {
            throw new IllegalArgumentException("Both arguments to " + functionName + " must be Matrix4d");
        }
        Matrix4d m4d = new Matrix4d((Matrix4d)elements.get(2));
        m4d.mul((Matrix4d)elements.get(1));
        return m4d;
    }

    private BoundingSphere makeBoundingSphere(ArrayList elements) {
        if (elements.size() != 3) {
            throw new IllegalArgumentException("Incorrect number of arguments to BoundingSphere");
        }
        if (!(elements.get(1) instanceof Point3d) || !(elements.get(2) instanceof Double) && !(elements.get(2) instanceof String)) {
            throw new IllegalArgumentException("BoundingSphere needs a Point3d center followed by a Double radius or the String \"infinite\"");
        }
        double r = elements.get(2) instanceof Double ? (Double)elements.get(2) : Double.POSITIVE_INFINITY;
        return new BoundingSphere((Point3d)elements.get(1), r);
    }

    void print() {
        System.out.print("(");
        int argc = this.elements.size();
        for (int i = 0; i < argc; ++i) {
            String[] rows;
            if (this.elements.get(i) instanceof Matrix3d) {
                rows = ConfigCommand.formatMatrixRows((Matrix3d)this.elements.get(i));
                System.out.println("\n ((" + rows[0] + ")");
                System.out.println("  (" + rows[1] + ")");
                System.out.print("  (" + rows[2] + "))");
                if (i == argc - 1) continue;
                System.out.println();
                continue;
            }
            if (this.elements.get(i) instanceof Matrix4d) {
                rows = ConfigCommand.formatMatrixRows((Matrix4d)this.elements.get(i));
                System.out.println("\n ((" + rows[0] + ")");
                System.out.println("  (" + rows[1] + ")");
                System.out.println("  (" + rows[2] + ")");
                System.out.print("  (" + rows[3] + "))");
                if (i == argc - 1) continue;
                System.out.println();
                continue;
            }
            if (this.elements.get(i) instanceof ConfigSexpression) {
                if (i > 0) {
                    System.out.print(" ");
                }
                ((ConfigSexpression)this.elements.get(i)).print();
                if (i == argc - 1) continue;
                System.out.println();
                continue;
            }
            if (this.elements.get(i) instanceof ConfigCommand) {
                if (i > 0) {
                    System.out.print(" ");
                }
                System.out.print(this.elements.get(i).toString());
                if (i == argc - 1) continue;
                System.out.println();
                continue;
            }
            if (i > 0) {
                System.out.print(" ");
            }
            System.out.print(this.elements.get(i).toString());
        }
        System.out.print(")");
    }
}

