/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.log;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.scijava.log.IgnoreAsCallingClass;
import org.scijava.log.LogListener;
import org.scijava.log.LogMessage;
import org.scijava.log.LogSource;
import org.scijava.log.Logger;

@IgnoreAsCallingClass
public class DefaultLogger
implements Logger,
LogListener {
    private final LogListener destination;
    private final LogSource source;
    private final int level;
    private final List<LogListener> listeners = new CopyOnWriteArrayList<LogListener>();

    public DefaultLogger(LogListener destination, LogSource source, int level) {
        this.destination = destination;
        this.source = source;
        this.level = level;
    }

    @Override
    public LogSource getSource() {
        return this.source;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void alwaysLog(int level, Object msg, Throwable t) {
        this.messageLogged(new LogMessage(this.source, level, msg, t));
    }

    @Override
    public Logger subLogger(String name, int level) {
        LogSource source = this.getSource().subSource(name);
        int actualLevel = source.hasLogLevel() ? source.logLevel() : level;
        return new DefaultLogger(this, source, actualLevel);
    }

    @Override
    public void addLogListener(LogListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeLogListener(LogListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void notifyListeners(LogMessage message) {
        for (LogListener listener : this.listeners) {
            listener.messageLogged(message);
        }
    }

    @Override
    public void messageLogged(LogMessage message) {
        this.notifyListeners(message);
        this.destination.messageLogged(message);
    }
}

