/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.loops;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.imglib2.Cursor;
import net.imglib2.RandomAccess;
import net.imglib2.loops.ClassCopyProvider;
import net.imglib2.loops.LoopBuilder;

final class FastCursorRandomAccessLoops {
    private static final List<ClassCopyProvider<LongConsumer>> factories = Arrays.asList(new ClassCopyProvider<LongConsumer>(OneCursorLoop.class, LongConsumer.class, new Class[0]), new ClassCopyProvider<LongConsumer>(TwoCursorLoop.class, LongConsumer.class, new Class[0]), new ClassCopyProvider<LongConsumer>(ThreeCursorLoop.class, LongConsumer.class, new Class[0]));

    private FastCursorRandomAccessLoops() {
    }

    static void loop(Object action, long n, Cursor<?> cursor, List<? extends RandomAccess<?>> randomAccesses) {
        FastCursorRandomAccessLoops.createLoop(action, cursor, randomAccesses).accept(n);
    }

    private static LongConsumer createLoop(Object action, Cursor<?> cursor, List<? extends RandomAccess<?>> randomAccesses) {
        Object[] arguments = Stream.concat(Stream.of(action, cursor), randomAccesses.stream()).toArray();
        ClassCopyProvider<LongConsumer> factory = factories.get(randomAccesses.size());
        List key = Stream.of(arguments).map(Object::getClass).collect(Collectors.toList());
        return factory.newInstanceForKey(key, arguments);
    }

    public static class ThreeCursorLoop<A, B, C>
    implements LongConsumer {
        private final LoopBuilder.TriConsumer<A, B, C> action;
        private final Cursor<A> cursorA;
        private final RandomAccess<B> randomAccessB;
        private final RandomAccess<C> randomAccessC;

        public ThreeCursorLoop(LoopBuilder.TriConsumer<A, B, C> action, Cursor<A> cursorA, RandomAccess<B> randomAccessB, RandomAccess<C> randomAccessC) {
            this.action = action;
            this.cursorA = cursorA;
            this.randomAccessB = randomAccessB;
            this.randomAccessC = randomAccessC;
        }

        @Override
        public void accept(long n) {
            while (--n >= 0L) {
                Object a = this.cursorA.next();
                this.randomAccessB.setPosition(this.cursorA);
                this.randomAccessC.setPosition(this.cursorA);
                this.action.accept(a, this.randomAccessB.get(), this.randomAccessC.get());
            }
        }
    }

    public static class TwoCursorLoop<A, B>
    implements LongConsumer {
        private final BiConsumer<A, B> action;
        private final Cursor<A> cursorA;
        private final RandomAccess<B> randomAccessB;

        public TwoCursorLoop(BiConsumer<A, B> action, Cursor<A> cursorA, RandomAccess<B> randomAccessB) {
            this.action = action;
            this.cursorA = cursorA;
            this.randomAccessB = randomAccessB;
        }

        @Override
        public void accept(long n) {
            while (--n >= 0L) {
                Object a = this.cursorA.next();
                this.randomAccessB.setPosition(this.cursorA);
                this.action.accept(a, this.randomAccessB.get());
            }
        }
    }

    public static class OneCursorLoop<A>
    implements LongConsumer {
        private final Consumer<A> action;
        private final Cursor<A> cursorA;

        public OneCursorLoop(Consumer<A> action, Cursor<A> cursorA) {
            this.action = action;
            this.cursorA = cursorA;
        }

        @Override
        public void accept(long n) {
            while (--n >= 0L) {
                this.action.accept(this.cursorA.next());
            }
        }
    }
}

