/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.neighborsearch;

import net.imglib2.KDTree;
import net.imglib2.KDTreeNode;
import net.imglib2.RealLocalizable;
import net.imglib2.Sampler;
import net.imglib2.kdtree.NearestNeighborSearchImpl;
import net.imglib2.neighborsearch.NearestNeighborSearch;

public class NearestNeighborSearchOnKDTree<T>
implements NearestNeighborSearch<T> {
    private final KDTree<T> tree;
    private final NearestNeighborSearchImpl impl;
    private final KDTreeNode<T> bestPoint;

    public NearestNeighborSearchOnKDTree(KDTree<T> tree) {
        this.tree = tree;
        this.impl = new NearestNeighborSearchImpl(tree.impl());
        this.bestPoint = tree.createNode();
    }

    private NearestNeighborSearchOnKDTree(NearestNeighborSearchOnKDTree<T> nn) {
        this.tree = nn.tree;
        this.impl = nn.impl.copy();
        this.bestPoint = this.tree.createNode();
        this.bestPoint.setNodeIndex(nn.impl.bestIndex());
    }

    @Override
    public int numDimensions() {
        return this.tree.numDimensions();
    }

    @Override
    public void search(RealLocalizable p) {
        this.impl.search(p);
        this.bestPoint.setNodeIndex(this.impl.bestIndex());
    }

    @Override
    public Sampler<T> getSampler() {
        return this.bestPoint;
    }

    @Override
    public RealLocalizable getPosition() {
        return this.bestPoint;
    }

    @Override
    public double getSquareDistance() {
        return this.impl.bestSquDistance();
    }

    @Override
    public NearestNeighborSearchOnKDTree<T> copy() {
        return new NearestNeighborSearchOnKDTree<T>(this);
    }
}

