/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.flim.impl;

import flimlib.FLIMLib;
import flimlib.NoiseType;
import net.imglib2.type.numeric.RealType;
import org.scijava.ops.flim.AbstractFitRAI;
import org.scijava.ops.flim.FitParams;
import org.scijava.ops.flim.FitResults;
import org.scijava.ops.flim.FitWorker;
import org.scijava.ops.flim.impl.AbstractSingleFitWorker;

public class RLDFit {

    public static class RLDFitWorker<I extends RealType<I>>
    extends AbstractSingleFitWorker<I> {
        private final float[] z = new float[1];
        private final float[] a = new float[1];
        private final float[] tau = new float[1];

        public RLDFitWorker(FitParams<I> params, FitResults results) {
            super(params, results);
        }

        @Override
        protected void beforeFit() {
            super.beforeFit();
            this.z[0] = this.paramBuffer[0];
            this.a[0] = this.paramBuffer[1];
            this.tau[0] = this.paramBuffer[2];
        }

        @Override
        protected void doFit() {
            int retCode = FLIMLib.GCI_triple_integral_fitting_engine((float)this.params.xInc, (float[])this.transBuffer, (int)this.adjFitStart, (int)this.adjFitEnd, (float[])this.params.instr, (NoiseType)this.params.noise, (float[])this.params.sig, (float[])this.z, (float[])this.a, (float[])this.tau, (float[])this.fittedBuffer, (float[])this.residualBuffer, (float[])this.chisqBuffer, (float)this.rawChisq_target);
            this.results.retCode = retCode < 0 ? (retCode == -1 ? -5 : -6) : 0;
        }

        @Override
        protected void afterFit() {
            if (this.params.paramFree[0]) {
                this.paramBuffer[0] = this.z[0];
            }
            if (this.params.paramFree[1]) {
                this.paramBuffer[1] = this.a[0];
            }
            if (this.params.paramFree[2]) {
                this.paramBuffer[2] = this.tau[0];
            }
            if (this.params.nComp >= 2) {
                if (this.params.paramFree[1]) {
                    this.paramBuffer[1] = this.a[0] * 3.0f / 4.0f;
                }
                if (this.params.paramFree[3]) {
                    this.paramBuffer[3] = this.a[0] * 1.0f / 4.0f;
                }
                if (this.params.paramFree[4]) {
                    this.paramBuffer[4] = this.tau[0] * 2.0f / 3.0f;
                }
            }
            if (this.params.nComp >= 3) {
                if (this.params.paramFree[3]) {
                    this.paramBuffer[3] = this.a[0] * 1.0f / 6.0f;
                }
                if (this.params.paramFree[5]) {
                    this.paramBuffer[5] = this.a[0] * 1.0f / 6.0f;
                }
                if (this.params.paramFree[6]) {
                    this.paramBuffer[6] = this.tau[0] * 1.0f / 3.0f;
                }
            }
            if (this.params.nComp >= 4) {
                for (int i = 7; i < this.nParam; i += 2) {
                    if (this.params.paramFree[i]) {
                        this.paramBuffer[i] = this.a[0] / (float)i;
                    }
                    if (!this.params.paramFree[i]) continue;
                    this.paramBuffer[i] = this.tau[0] / (float)i;
                }
            }
            super.afterFit();
        }

        @Override
        protected AbstractSingleFitWorker<I> duplicate(FitParams<I> params, FitResults rslts) {
            return new RLDFitWorker<I>(params, rslts);
        }
    }

    public static class RLDSingleFitRAI<I extends RealType<I>, K extends RealType<K>>
    extends AbstractFitRAI<I, K> {
        @Override
        public FitWorker<I> createWorker(FitParams<I> params, FitResults results) {
            return new RLDFitWorker<I>(params, results);
        }
    }
}

