/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.ij;

import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.io.FileInfo;
import ij.plugin.PlugIn;
import ij.plugin.frame.Recorder;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JTree;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.cache.img.CachedCellImg;
import net.imglib2.converter.Converter;
import net.imglib2.converter.Converters;
import net.imglib2.converter.RealFloatConverter;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.img.imageplus.ImagePlusImg;
import net.imglib2.img.imageplus.ImagePlusImgFactory;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.parallel.DefaultTaskExecutor;
import net.imglib2.parallel.TaskExecutor;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedLongType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Pair;
import net.imglib2.view.Views;
import org.apache.commons.lang.ArrayUtils;
import org.janelia.saalfeldlab.n5.DataType;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.N5URI;
import org.janelia.saalfeldlab.n5.converters.LabelMultisetLongConverter;
import org.janelia.saalfeldlab.n5.converters.UnsignedShortLUTConverter;
import org.janelia.saalfeldlab.n5.imglib2.N5LabelMultisets;
import org.janelia.saalfeldlab.n5.imglib2.N5Utils;
import org.janelia.saalfeldlab.n5.metadata.imagej.CanonicalMetadataToImagePlus;
import org.janelia.saalfeldlab.n5.metadata.imagej.CosemToImagePlus;
import org.janelia.saalfeldlab.n5.metadata.imagej.ImagePlusLegacyMetadataParser;
import org.janelia.saalfeldlab.n5.metadata.imagej.ImageplusMetadata;
import org.janelia.saalfeldlab.n5.metadata.imagej.N5ImagePlusMetadata;
import org.janelia.saalfeldlab.n5.metadata.imagej.N5ViewerToImagePlus;
import org.janelia.saalfeldlab.n5.metadata.imagej.NgffToImagePlus;
import org.janelia.saalfeldlab.n5.ui.DataSelection;
import org.janelia.saalfeldlab.n5.ui.DatasetSelectorDialog;
import org.janelia.saalfeldlab.n5.ui.N5DatasetTreeCellRenderer;
import org.janelia.saalfeldlab.n5.ui.N5SwingTreeNode;
import org.janelia.saalfeldlab.n5.universe.N5DatasetDiscoverer;
import org.janelia.saalfeldlab.n5.universe.N5Factory;
import org.janelia.saalfeldlab.n5.universe.N5TreeNode;
import org.janelia.saalfeldlab.n5.universe.StorageFormat;
import org.janelia.saalfeldlab.n5.universe.metadata.N5CosemMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5CosemMetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.N5CosemMultiScaleMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5DatasetMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5GenericSingleScaleMetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.N5Metadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5MetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.N5SingleScaleMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5SingleScaleMetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.N5ViewerMultiscaleMetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.AxisMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.AxisUtils;
import org.janelia.saalfeldlab.n5.universe.metadata.canonical.CanonicalDatasetMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.canonical.CanonicalMetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.canonical.CanonicalSpatialDatasetMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.NgffSingleScaleAxesMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.OmeNgffMetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.OmeNgffMultiScaleMetadata;

public class N5Importer
implements PlugIn {
    private static final String[] axisNames = new String[]{"dim1", "dim2", "dim3", "dim4", "dim5"};
    public static final String n5PathKey = "url";
    public static final String virtualKey = "virtual";
    public static final String hideKey = "hide";
    public static final String minKey = "min";
    public static final String maxKey = "max";
    public static final String COMMAND_NAME = "HDF5/N5/Zarr/OME-NGFF ... ";
    public static final String BDV_OPTION = "BigDataViewer";
    public static final String IP_OPTION = "ImagePlus";
    public static final String MetadataAutoKey = "Auto-detect";
    public static final String MetadataOmeZarrKey = "OME-NGFF";
    public static final String MetadataImageJKey = "ImageJ";
    public static final String MetadataN5CosemKey = "COSEM";
    public static final String MetadataN5ViewerKey = "N5Viewer";
    public static final String MetadataCustomKey = "Custom";
    public static final String MetadataDefaultKey = "Default";
    public static final N5MetadataParser<?>[] PARSERS = new N5MetadataParser[]{new ImagePlusLegacyMetadataParser(), new N5CosemMetadataParser(), new N5SingleScaleMetadataParser(), new CanonicalMetadataParser(), new N5GenericSingleScaleMetadataParser()};
    public static final N5MetadataParser<?>[] GROUP_PARSERS = new N5MetadataParser[]{new OmeNgffMetadataParser(), new N5CosemMultiScaleMetadata.CosemMultiScaleParser(), new OmeNgffMetadataParser(), new N5ViewerMultiscaleMetadataParser(), new CanonicalMetadataParser()};
    private static final Predicate<N5Metadata> ALL_PASS = x -> true;
    private N5Reader n5;
    private DatasetSelectorDialog selectionDialog;
    private DataSelection selection;
    private final Map<Class<?>, ImageplusMetadata<?>> impMetaWriterTypes;
    private ImageplusMetadata<?> impMeta;
    private Interval cropInterval;
    private boolean asVirtual;
    private boolean show = true;
    private boolean cropOption;
    private Thread loaderThread;
    private final ExecutorService exec;
    private boolean initialRecorderState = Recorder.record;
    private int numDimensionsForCrop;
    private long[] initMaxValuesForCrop;
    private List<ImagePlus> lastResult;
    private static String lastOpenedContainer = "";

    public N5Importer() {
        Recorder.record = false;
        this.impMetaWriterTypes = N5Importer.defaultImagePlusMetadataWriters();
        this.numDimensionsForCrop = 5;
        this.initMaxValuesForCrop = new long[this.numDimensionsForCrop];
        Arrays.fill(this.initMaxValuesForCrop, Long.MAX_VALUE);
        this.exec = Executors.newFixedThreadPool(Prefs.getThreads());
    }

    private static HashMap<Class<?>, ImageplusMetadata<?>> defaultImagePlusMetadataWriters() {
        HashMap impMetaWriterTypes = new HashMap();
        impMetaWriterTypes.put(N5ImagePlusMetadata.class, new ImagePlusLegacyMetadataParser());
        impMetaWriterTypes.put(NgffSingleScaleAxesMetadata.class, new NgffToImagePlus());
        impMetaWriterTypes.put(N5CosemMetadata.class, new CosemToImagePlus());
        impMetaWriterTypes.put(N5SingleScaleMetadata.class, new N5ViewerToImagePlus());
        impMetaWriterTypes.put(CanonicalDatasetMetadata.class, new CanonicalMetadataToImagePlus());
        impMetaWriterTypes.put(CanonicalSpatialDatasetMetadata.class, new CanonicalMetadataToImagePlus());
        return impMetaWriterTypes;
    }

    public N5Reader getN5() {
        return this.n5;
    }

    public List<ImagePlus> getResult() {
        return this.lastResult;
    }

    public Map<Class<?>, ImageplusMetadata<?>> getImagePlusMetadataWriterMap() {
        return this.impMetaWriterTypes;
    }

    public void setNumDimensionsForCropDialog(int numDimensionsForCrop) {
        this.numDimensionsForCrop = numDimensionsForCrop;
    }

    public void setShow(boolean show) {
        this.show = show;
    }

    public void runWithDialog(String pathToContainer, List<String> selectThisSubPath) {
        boolean isDiscoveryFinished;
        lastOpenedContainer = pathToContainer;
        this.selectionDialog = null;
        this.run(null);
        if (this.selectionDialog == null) {
            throw new RuntimeException("The \"Open N5\" didn't come up when it should.");
        }
        this.selectionDialog.detectDatasets();
        if (selectThisSubPath != null && (isDiscoveryFinished = this.selectionDialog.waitUntilDiscoveryIsFinished(60000L))) {
            this.selectTreeItem(selectThisSubPath);
        }
    }

    private void selectTreeItem(List<String> itemPath) {
        JTree t = this.selectionDialog.getJTree();
        int currRow = 0;
        block0: for (String subPath : itemPath) {
            int r = currRow;
            while (r < t.getRowCount()) {
                N5SwingTreeNode n = (N5SwingTreeNode)t.getPathForRow(r).getLastPathComponent();
                if (n.getNodeName().equals(subPath)) {
                    t.expandRow(r);
                    t.setSelectionRow(r);
                    ++currRow;
                    continue block0;
                }
                ++r;
                ++currRow;
            }
        }
    }

    public void run(String args) {
        boolean isCrop;
        String macroOptions = Macro.getOptions();
        String options = args;
        if (options == null || options.isEmpty()) {
            options = macroOptions;
        }
        boolean isMacro = options != null && !options.isEmpty();
        boolean bl = isCrop = options != null && options.contains("cropDialog");
        if (!isMacro && !isCrop) {
            this.selectionDialog = new DatasetSelectorDialog((Function<String, N5Reader>)new N5ViewerReaderFun(), (Function<String, String>)new N5BasePathFun(), lastOpenedContainer, new N5MetadataParser[]{new OmeNgffMetadataParser()}, PARSERS);
            this.selectionDialog.setLoaderExecutor(this.exec);
            this.selectionDialog.setTreeRenderer(new N5DatasetTreeCellRenderer(true));
            this.selectionDialog.getTranslationPanel().setFilter(x -> x instanceof CanonicalDatasetMetadata);
            this.selectionDialog.setSelectionFilter(x -> x instanceof N5DatasetMetadata);
            this.selectionDialog.setContainerPathUpdateCallback(x -> {
                if (x != null) {
                    lastOpenedContainer = x;
                }
            });
            this.selectionDialog.setCancelCallback(x -> {
                Recorder.record = this.initialRecorderState;
            });
            this.selectionDialog.setVirtualOption(true);
            this.selectionDialog.setCropOption(true);
            this.selectionDialog.run(this::datasetSelectorCallBack);
        } else {
            this.initialRecorderState = Recorder.record;
            Recorder.record = false;
            String n5Path = Macro.getValue((String)options, (String)n5PathKey, (String)"");
            Interval thisDatasetCropInterval = null;
            boolean openAsVirtual = options.contains(" virtual");
            if (isCrop) {
                int i;
                int i2;
                GenericDialog gd = new GenericDialog("Import N5");
                gd.addStringField("N5 path", n5Path);
                gd.addCheckbox("Virtual", openAsVirtual);
                gd.addMessage(" ");
                gd.addMessage("Crop parameters.");
                gd.addMessage("[0,Infinity] loads the whole volume.");
                gd.addMessage("Min:");
                for (i2 = 0; i2 < this.numDimensionsForCrop; ++i2) {
                    gd.addNumericField("min_" + axisNames[i2], 0.0);
                }
                gd.addMessage("Max:");
                for (i2 = 0; i2 < this.numDimensionsForCrop; ++i2) {
                    if (this.initMaxValuesForCrop != null) {
                        gd.addNumericField("max_" + axisNames[i2], (double)this.initMaxValuesForCrop[i2]);
                        continue;
                    }
                    gd.addNumericField("max_" + axisNames[i2], Double.POSITIVE_INFINITY);
                }
                gd.showDialog();
                if (gd.wasCanceled()) {
                    Recorder.record = this.initialRecorderState;
                    return;
                }
                n5Path = gd.getNextString();
                openAsVirtual = gd.getNextBoolean();
                long[] cropMin = new long[this.numDimensionsForCrop];
                long[] cropMax = new long[this.numDimensionsForCrop];
                for (i = 0; i < this.numDimensionsForCrop; ++i) {
                    cropMin[i] = Math.max(0L, (long)Math.floor(gd.getNextNumber()));
                }
                for (i = 0; i < this.numDimensionsForCrop; ++i) {
                    double v = gd.getNextNumber();
                    cropMax[i] = Double.isInfinite(v) ? Long.MAX_VALUE : (long)Math.ceil(v);
                }
                thisDatasetCropInterval = new FinalInterval(cropMin, cropMax);
            } else {
                String minString = Macro.getValue((String)options, (String)minKey, (String)"");
                String maxString = Macro.getValue((String)options, (String)maxKey, (String)"");
                if (minString != null && !minString.isEmpty()) {
                    thisDatasetCropInterval = N5Importer.parseCropParameters(minString, maxString);
                }
                this.show = !options.contains(" hide");
            }
            Recorder.record = this.initialRecorderState;
            N5Reader n5ForThisDataset = new N5ViewerReaderFun().apply(n5Path);
            String rootPath = n5ForThisDataset.getURI().toString();
            String dset = new N5BasePathFun().apply(n5Path);
            N5DatasetDiscoverer discoverer = new N5DatasetDiscoverer(n5ForThisDataset, N5DatasetDiscoverer.fromParsers(PARSERS), Collections.singletonList(new OmeNgffMetadataParser()));
            N5Metadata meta = null;
            try {
                N5TreeNode root = discoverer.discoverAndParseRecursive("");
                Optional<N5Metadata> metaOpt = root.getDescendant(dset).filter(x -> x.getMetadata() != null).map(N5TreeNode::getMetadata);
                if (metaOpt.isPresent()) {
                    meta = metaOpt.get();
                }
            }
            catch (Exception e) {
                throw new N5Exception("Failure to parse or find data at " + dset, (Throwable)e);
            }
            if (meta != null && meta instanceof N5DatasetMetadata) {
                this.lastResult = N5Importer.process(n5ForThisDataset, rootPath, this.exec, Collections.singletonList((N5DatasetMetadata)meta), openAsVirtual, thisDatasetCropInterval, this.show, this.impMetaWriterTypes);
            } else {
                System.err.println("not a dataset : " + n5Path);
            }
        }
    }

    public static boolean isTypeOpenable(N5DatasetMetadata meta, boolean showMessage) {
        DataType type = meta.getAttributes().getDataType();
        if (type != DataType.FLOAT32 && type != DataType.UINT8 && type != DataType.UINT16 && type != DataType.UINT32) {
            if (showMessage) {
                IJ.error((String)("Cannot open datasets of type (" + type + ").\nImageJ supports uint8, uint16, uint32(rgb), or float32."));
            }
            return false;
        }
        return true;
    }

    private void datasetSelectorCallBack(DataSelection selection) {
        Recorder.record = this.initialRecorderState;
        this.selection = selection;
        this.n5 = selection.n5;
        this.asVirtual = this.selectionDialog.isVirtual();
        this.cropOption = this.selectionDialog.isCropSelected();
        if (this.cropOption) {
            this.processWithCrops();
        } else {
            this.processThread();
        }
    }

    public static String generateAndStoreOptions(String n5RootAndDataset, boolean virtual, Interval cropInterval) {
        return N5Importer.generateAndStoreOptions(n5RootAndDataset, virtual, cropInterval, false);
    }

    public static String generateAndStoreOptions(String n5RootAndDataset, boolean virtual, Interval cropInterval, boolean hide) {
        Recorder.resetCommandOptions();
        Recorder.recordOption((String)n5PathKey, (String)n5RootAndDataset);
        if (virtual) {
            Recorder.recordOption((String)virtualKey);
        }
        if (hide) {
            Recorder.recordOption((String)hideKey);
        }
        if (cropInterval != null) {
            String[] cropParams = N5Importer.minMaxStrings(cropInterval);
            Recorder.recordOption((String)minKey, (String)cropParams[0]);
            Recorder.recordOption((String)maxKey, (String)cropParams[1]);
        }
        return Recorder.getCommandOptions();
    }

    private static String[] minMaxStrings(Interval interval) {
        long[] tmp = new long[interval.numDimensions()];
        interval.min(tmp);
        String minString = Arrays.stream(tmp).mapToObj(Long::toString).collect(Collectors.joining(","));
        interval.max(tmp);
        String maxString = Arrays.stream(tmp).mapToObj(Long::toString).collect(Collectors.joining(","));
        return new String[]{minString, maxString};
    }

    private static Interval parseCropParameters(String minParam, String maxParam) {
        return new FinalInterval(Arrays.stream(minParam.split(",")).mapToLong(Long::parseLong).toArray(), Arrays.stream(maxParam.split(",")).mapToLong(Long::parseLong).toArray());
    }

    public static void record(String n5RootAndDataset, boolean virtual, Interval cropInterval) {
        if (!Recorder.record) {
            return;
        }
        Recorder.setCommand((String)COMMAND_NAME);
        N5Importer.generateAndStoreOptions(n5RootAndDataset, virtual, cropInterval);
        Recorder.saveCommand();
    }

    public static <T extends NumericType<T> & NativeType<T>, M extends N5DatasetMetadata, A extends AxisMetadata & N5Metadata> ImagePlus read(N5Reader n5, ExecutorService exec, N5DatasetMetadata datasetMetaArg, Interval cropIntervalIn, boolean asVirtual, ImageplusMetadata<M> ipMeta) throws IOException {
        ImagePlus imp;
        boolean isRGB;
        N5DatasetMetadata datasetMeta;
        CachedCellImg img;
        CachedCellImg imgC;
        CachedCellImg imgNorm;
        String d = datasetMetaArg.getPath();
        CachedCellImg imgRaw = N5Utils.open((N5Reader)n5, (String)d);
        if (OmeNgffMultiScaleMetadata.fOrder((DatasetAttributes)datasetMetaArg.getAttributes())) {
            imgNorm = AxisUtils.reverseDimensions((RandomAccessibleInterval)imgRaw);
            ArrayUtils.reverse((long[])datasetMetaArg.getAttributes().getDimensions());
        } else {
            imgNorm = imgRaw;
        }
        Interval cropInterval = null;
        if (cropIntervalIn != null) {
            cropInterval = N5Importer.processCropInterval(imgNorm, cropIntervalIn);
            imgC = Views.interval((RandomAccessible)imgNorm, (Interval)cropInterval);
        } else {
            imgC = imgNorm;
        }
        if (datasetMetaArg != null && datasetMetaArg instanceof AxisMetadata) {
            int[] p = AxisUtils.findImagePlusPermutation((AxisMetadata)((AxisMetadata)datasetMetaArg));
            Pair res = AxisUtils.permuteImageAndMetadataForImagePlus((int[])p, (RandomAccessibleInterval)imgC, (N5Metadata)datasetMetaArg);
            img = (RandomAccessibleInterval)res.getA();
            datasetMeta = (N5DatasetMetadata)res.getB();
        } else {
            img = imgC;
            datasetMeta = datasetMetaArg;
        }
        DataType type = datasetMeta.getAttributes().getDataType();
        boolean bl = isRGB = datasetMeta instanceof N5ImagePlusMetadata && ((N5ImagePlusMetadata)datasetMeta).getType() == 4;
        Object convImg = N5LabelMultisets.isLabelMultisetType((N5Reader)n5, (String)datasetMeta.getPath()) ? N5Importer.convertToUShortLUT(Converters.convert2((RandomAccessibleInterval)img, (Converter)new LabelMultisetLongConverter(), UnsignedLongType::new)) : (type == DataType.FLOAT64 ? N5Importer.convertDouble((RandomAccessibleInterval<DoubleType>)img) : (isRGB && type == DataType.UINT32 ? N5Importer.convertToRGB((RandomAccessibleInterval<UnsignedIntType>)img) : (type == DataType.INT32 || type == DataType.UINT32 || type == DataType.INT64 || type == DataType.UINT64 ? N5Importer.convertToUShortLUT(img) : img)));
        if (asVirtual) {
            imp = ImageJFunctions.wrap(convImg, (String)d, (ExecutorService)exec);
        } else {
            ImagePlusImg ipImg = new ImagePlusImgFactory((NativeType)convImg.getType()).create(convImg);
            LoopBuilder.setImages((RandomAccessibleInterval)convImg, (RandomAccessibleInterval)ipImg).multiThreaded((TaskExecutor)new DefaultTaskExecutor(exec)).forEachPixel((x, y) -> y.set((Type)x));
            imp = ipImg.getImagePlus();
        }
        if (ipMeta != null) {
            try {
                ipMeta.writeMetadata(datasetMeta, imp);
            }
            catch (Exception e) {
                System.err.println("Failed to convert metadata to Imageplus for " + d);
            }
        }
        if (cropInterval != null) {
            imp.getCalibration().xOrigin -= (double)cropInterval.min(0);
            imp.getCalibration().yOrigin -= (double)cropInterval.min(1);
            if (cropInterval.numDimensions() >= 3) {
                imp.getCalibration().zOrigin -= (double)cropInterval.min(2);
            }
        }
        return imp;
    }

    public static RandomAccessibleInterval<FloatType> convertDouble(RandomAccessibleInterval<DoubleType> img) {
        return Converters.convert(img, (Converter)new RealFloatConverter(), (Type)new FloatType());
    }

    public static RandomAccessibleInterval<ARGBType> convertToRGB(RandomAccessibleInterval<UnsignedIntType> img) {
        return Converters.convert(img, (Converter)new IntegerToaRGBConverter(), (Type)new ARGBType());
    }

    public static <T extends NumericType<T> & NativeType<T>> RandomAccessibleInterval<UnsignedShortType> convertToUShortLUT(RandomAccessibleInterval<T> img) {
        return Converters.convert(img, new UnsignedShortLUTConverter(Views.flatIterable(img)), (Type)new UnsignedShortType());
    }

    private static Interval processCropInterval(RandomAccessibleInterval<?> img, Interval cropInterval) {
        assert (img.numDimensions() == cropInterval.numDimensions());
        int nd = img.numDimensions();
        long[] min = new long[nd];
        long[] max = new long[nd];
        for (int i = 0; i < nd; ++i) {
            min[i] = Math.max(img.min(i), cropInterval.min(i));
            max[i] = Math.min(img.max(i), cropInterval.max(i));
        }
        return new FinalInterval(min, max);
    }

    public void processWithCrops() {
        this.asVirtual = this.selectionDialog.isVirtual();
        URI rootUri = this.selectionDialog.getN5Reader().getURI();
        if (!rootUri.toString().endsWith("/")) {
            rootUri = URI.create(rootUri.toString() + "/");
        }
        for (N5Metadata datasetMeta : this.selection.metadata) {
            String datasetPath = N5URI.normalizeGroupPath((String)datasetMeta.getPath());
            String pathToN5Dataset = rootUri.resolve(datasetPath).toString();
            this.numDimensionsForCrop = ((N5DatasetMetadata)datasetMeta).getAttributes().getNumDimensions();
            this.initMaxValuesForCrop = Arrays.stream(((N5DatasetMetadata)datasetMeta).getAttributes().getDimensions()).map(x -> x - 1L).toArray();
            this.run("cropDialog " + N5Importer.generateAndStoreOptions(pathToN5Dataset, this.asVirtual, null, !this.show));
        }
    }

    public static ImagePlus open(String uri) {
        return N5Importer.open(uri, true);
    }

    public static ImagePlus open(String uri, boolean show) {
        try {
            N5URI n5uri = new N5URI(uri);
            String grp = N5URI.normalizeGroupPath((String)n5uri.getGroupPath());
            if (!grp.isEmpty()) {
                return N5Importer.open(uri, grp, show);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return N5Importer.open(uri, ALL_PASS);
    }

    public static ImagePlus open(String uri, String dataset) {
        return N5Importer.open(uri, dataset, true);
    }

    public static ImagePlus open(String uri, String dataset, boolean show) {
        return N5Importer.open(uri, (N5Metadata x) -> N5Importer.norm(x.getPath()).equals(N5Importer.norm(dataset)), show);
    }

    public static ImagePlus open(String uri, Predicate<N5Metadata> filter) {
        return N5Importer.open(uri, filter, true);
    }

    public static ImagePlus open(String uri, Predicate<N5Metadata> filter, boolean show) {
        N5Reader n5;
        try {
            n5 = new N5ViewerReaderFun().apply(uri);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        N5TreeNode node = N5DatasetDiscoverer.discover((N5Reader)n5);
        Predicate<N5Metadata> datasetFilter = x -> x instanceof N5DatasetMetadata;
        Predicate<N5Metadata> totalFilter = filter == null || filter == ALL_PASS ? datasetFilter : datasetFilter.and(filter);
        Stream<N5DatasetMetadata> metaStream = N5TreeNode.flattenN5Tree((N5TreeNode)node).filter(x -> totalFilter.test(x.getMetadata())).map(x -> (N5DatasetMetadata)x.getMetadata());
        try {
            N5URI n5uri = new N5URI(uri);
            String grp = N5URI.normalizeGroupPath((String)n5uri.getGroupPath());
            if (!grp.isEmpty()) {
                metaStream = metaStream.filter(x -> N5URI.normalizeGroupPath((String)x.getPath()).equals(grp));
            }
        }
        catch (URISyntaxException grp) {
            // empty catch block
        }
        Optional<N5DatasetMetadata> meta = metaStream.findFirst();
        if (meta.isPresent()) {
            return N5Importer.open(n5, uri, meta.get(), show);
        }
        System.err.println("No arrays matching criteria found in container at: " + uri);
        return null;
    }

    public static ImagePlus open(N5Reader n5, String uri, N5DatasetMetadata metadata) {
        return N5Importer.open(n5, uri, metadata, true);
    }

    public static ImagePlus open(N5Reader n5, String uri, N5DatasetMetadata metadata, boolean show) {
        ExecutorService exec = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() / 2);
        return N5Importer.process(n5, uri, exec, Collections.singletonList(metadata), false, show, null).get(0);
    }

    private static String norm(String groupPath) {
        return groupPath.equals("/") ? groupPath : groupPath.replaceAll("^/", "");
    }

    public static List<ImagePlus> process(N5Reader n5, String rootPath, ExecutorService exec, List<N5DatasetMetadata> datasetMetadataList, boolean asVirtual, Interval cropInterval) {
        return N5Importer.process(n5, rootPath, exec, datasetMetadataList, asVirtual, cropInterval, true, N5Importer.defaultImagePlusMetadataWriters());
    }

    public static List<ImagePlus> process(N5Reader n5, String rootPath, ExecutorService exec, List<N5DatasetMetadata> datasetMetadataList, boolean asVirtual, boolean show, Interval cropInterval) {
        return N5Importer.process(n5, rootPath, exec, datasetMetadataList, asVirtual, cropInterval, show, N5Importer.defaultImagePlusMetadataWriters());
    }

    public static List<ImagePlus> process(N5Reader n5, String rootPath, ExecutorService exec, List<N5DatasetMetadata> datasetMetadataList, boolean asVirtual, Interval cropInterval, Map<Class<?>, ImageplusMetadata<?>> impMetaWriterTypes) {
        return N5Importer.process(n5, rootPath, exec, datasetMetadataList, asVirtual, cropInterval, true, impMetaWriterTypes);
    }

    public static List<ImagePlus> process(N5Reader n5, String rootPathArg, ExecutorService exec, List<N5DatasetMetadata> datasetMetadataList, boolean asVirtual, Interval cropInterval, boolean show, Map<Class<?>, ImageplusMetadata<?>> impMetaWriterTypes) {
        String rootPath = rootPathArg;
        ArrayList<ImagePlus> imgList = new ArrayList<ImagePlus>();
        for (N5DatasetMetadata datasetMeta : datasetMetadataList) {
            if (datasetMeta == null) continue;
            String d = N5Importer.normalPathName(datasetMeta.getPath(), n5.getGroupSeparator());
            try {
                StorageFormat fmt = StorageFormat.guessStorageFromUri((URI)URI.create(rootPathArg));
                String fmtPrefix = fmt == null ? "" : fmt.toString().toLowerCase() + "://";
                String n5Url = fmtPrefix + N5URI.from((String)n5.getURI().toString(), (String)d, null).toString();
                ImageplusMetadata<?> impMeta = impMetaWriterTypes.get(datasetMeta.getClass());
                ImagePlus imp = N5Importer.read(n5, exec, datasetMeta, cropInterval, asVirtual, impMeta);
                FileInfo fileInfo = imp.getOriginalFileInfo();
                if (fileInfo == null) {
                    fileInfo = new FileInfo();
                }
                fileInfo.url = n5Url;
                imp.setFileInfo(fileInfo);
                N5Importer.record(n5Url, asVirtual, cropInterval);
                imgList.add(imp);
                if (!show) continue;
                ImageStatistics stats = ImageStatistics.getStatistics((ImageProcessor)imp.getProcessor());
                double[] hist = stats.histogram();
                N5Importer.toCumulativeHistogram(hist);
                double min = stats.histMin;
                double max = min + stats.binSize * (double)N5Importer.nthPercentile(hist, 0.98);
                imp.setDisplayRange(min, max);
                imp.show();
            }
            catch (IOException e) {
                IJ.error((String)"failed to read n5");
            }
            catch (URISyntaxException e1) {
                IJ.error((String)("unable to parse url: " + rootPath + "?" + d));
            }
        }
        return imgList;
    }

    private static double toCumulativeHistogram(double[] histogram) {
        double total = 0.0;
        for (int i = 0; i < histogram.length; ++i) {
            histogram[i] = total += histogram[i];
        }
        return total;
    }

    private static int nthPercentile(double[] cumulativeHistogram, double percentile) {
        int N = cumulativeHistogram.length - 1;
        double total = cumulativeHistogram[N];
        for (int i = N; i >= 0; --i) {
            if (!(cumulativeHistogram[i] <= percentile * total)) continue;
            return i + 1;
        }
        return 0;
    }

    public void process() {
        N5Importer.process(this.n5, this.selectionDialog.getN5RootPath(), this.exec, this.selection.metadata, this.asVirtual, this.cropInterval, this.impMetaWriterTypes);
    }

    public List<ImagePlus> process(String n5FullPath, boolean asVirtual) {
        return this.process(n5FullPath, asVirtual, null);
    }

    public List<ImagePlus> process(String n5FullPath, boolean asVirtual, Interval cropInterval) {
        return this.process(n5FullPath, asVirtual, cropInterval, true);
    }

    public List<ImagePlus> process(String n5FullPath, boolean asVirtual, Interval cropInterval, boolean parseAllMetadata) {
        N5DatasetMetadata metadata;
        this.n5 = new N5ViewerReaderFun().apply(n5FullPath);
        String dataset = new N5BasePathFun().apply(n5FullPath);
        try {
            N5DatasetDiscoverer discoverer = new N5DatasetDiscoverer(this.n5, N5DatasetDiscoverer.fromParsers(PARSERS), Collections.singletonList(new OmeNgffMetadataParser()));
            if (parseAllMetadata) {
                N5TreeNode root = discoverer.discoverAndParseRecursive("");
                metadata = (N5DatasetMetadata)((N5TreeNode)root.getDescendant(dataset).get()).getMetadata();
            } else {
                metadata = (N5DatasetMetadata)discoverer.parse(dataset).getMetadata();
            }
        }
        catch (Exception e) {
            System.err.println("Could not parse metadata.");
            return null;
        }
        List<ImagePlus> result = N5Importer.process(this.n5, dataset, this.exec, Collections.singletonList(metadata), asVirtual, cropInterval, this.show, this.getImagePlusMetadataWriterMap());
        this.n5.close();
        return result;
    }

    public List<ImagePlus> process(String n5FullPath, List<N5DatasetMetadata> metadataList, boolean asVirtual, Interval cropInterval) {
        this.n5 = new N5ViewerReaderFun().apply(n5FullPath);
        String dataset = new N5BasePathFun().apply(n5FullPath);
        if (metadataList == null || metadataList.size() < 1) {
            return null;
        }
        List<ImagePlus> result = N5Importer.process(this.n5, dataset, this.exec, metadataList, asVirtual, cropInterval, this.show, this.getImagePlusMetadataWriterMap());
        this.n5.close();
        return result;
    }

    public void processThread() {
        this.loaderThread = new Thread(){

            @Override
            public void run() {
                N5Importer.this.process();
            }
        };
        this.loaderThread.run();
    }

    private static String upToLastExtension(String pathArg) {
        int j;
        String path;
        String scheme = null;
        String host = null;
        try {
            URI uri = URI.create(pathArg);
            path = uri.getPath();
            scheme = uri.getScheme();
            host = uri.getHost();
        }
        catch (Exception e) {
            path = pathArg;
        }
        String newPath = path;
        int i = path.lastIndexOf(46);
        if (i >= 0 && (j = path.substring(i).indexOf(47)) >= 0) {
            newPath = path.substring(0, i + j);
        }
        try {
            return new URI(scheme, host, newPath, null).toString();
        }
        catch (URISyntaxException e) {
            return newPath;
        }
    }

    private static String afterLastExtension(String pathArg) {
        int j;
        String path;
        try {
            URI uri = URI.create(pathArg);
            path = uri.getPath();
        }
        catch (Exception e) {
            path = pathArg;
        }
        String group = "";
        int i = path.lastIndexOf(46);
        if (i >= 0 && (j = path.substring(i).indexOf(47)) >= 0) {
            group = path.substring(i + j);
        }
        return group;
    }

    public static String h5DatasetPath(String h5PathAndDataset) {
        return N5Importer.h5DatasetPath(h5PathAndDataset, false);
    }

    public static String h5DatasetPath(String h5PathAndDataset, boolean getFilePath) {
        int len = 3;
        int i = h5PathAndDataset.lastIndexOf(".h5");
        if (i < 0) {
            i = h5PathAndDataset.lastIndexOf(".hdf5");
            len = 5;
        }
        if (i < 0) {
            i = h5PathAndDataset.lastIndexOf(".hdf");
            len = 4;
        }
        if (i < 0) {
            return "";
        }
        if (getFilePath) {
            return h5PathAndDataset.substring(0, i + len);
        }
        return h5PathAndDataset.substring(i + len);
    }

    private static String normalPathName(String fullPath, String groupSeparator) {
        return fullPath.replaceAll("(^" + groupSeparator + "*)|(" + groupSeparator + "*$)", "");
    }

    public static class IntegerToaRGBConverter
    implements Converter<UnsignedIntType, ARGBType> {
        public void convert(UnsignedIntType input, ARGBType output) {
            output.set(input.getInt());
        }
    }

    public static class N5BasePathFun
    implements Function<String, String> {
        public String message;

        @Override
        public String apply(String n5UriOrPath) {
            if (n5UriOrPath.contains("?")) {
                Pair fmtUri = StorageFormat.parseUri((String)n5UriOrPath);
                N5URI n5uri = new N5URI(URI.create(((URI)fmtUri.getB()).toString()));
                return n5uri.getGroupPath();
            }
            if (n5UriOrPath.contains(".h5") || n5UriOrPath.contains(".hdf5") || n5UriOrPath.contains(".hdf")) {
                return N5Importer.h5DatasetPath(n5UriOrPath);
            }
            return N5Importer.afterLastExtension(n5UriOrPath);
        }
    }

    public static class N5ViewerReaderFun
    implements Function<String, N5Reader> {
        public String message;

        @Override
        public N5Reader apply(String n5UriOrPath) {
            N5Reader n5;
            if (n5UriOrPath == null || n5UriOrPath.isEmpty()) {
                return null;
            }
            String rootPath = null;
            if (n5UriOrPath.contains("?")) {
                Pair fmtUri = StorageFormat.parseUri((String)n5UriOrPath);
                StorageFormat format = (StorageFormat)fmtUri.getA();
                N5URI n5uri = new N5URI(URI.create(((URI)fmtUri.getB()).toString()));
                String string = rootPath = format == null ? n5uri.getContainerPath() : format.toString().toLowerCase() + ":" + n5uri.getContainerPath();
            }
            if (rootPath == null) {
                rootPath = N5Importer.upToLastExtension(n5UriOrPath);
            }
            N5Factory factory = new N5Factory().cacheAttributes(true);
            try {
                n5 = factory.openReader(rootPath);
            }
            catch (N5Exception e) {
                IJ.error((String)e.getMessage());
                return null;
            }
            return n5;
        }
    }
}

