/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.metadata.imagej;

import ij.ImagePlus;
import ij.measure.Calibration;
import ij.process.LUT;
import java.awt.Color;
import java.io.IOException;
import java.util.Arrays;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineTransform;
import net.imglib2.type.numeric.ARGBType;
import org.janelia.saalfeldlab.n5.Compression;
import org.janelia.saalfeldlab.n5.DataType;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.GzipCompression;
import org.janelia.saalfeldlab.n5.metadata.imagej.ImageplusMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.Axis;
import org.janelia.saalfeldlab.n5.universe.metadata.canonical.CanonicalDatasetMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.canonical.CanonicalSpatialDatasetMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.canonical.SpatialMetadataCanonical;
import org.janelia.saalfeldlab.n5.universe.metadata.transforms.AffineSpatialTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.transforms.SpatialTransform;

public class CanonicalMetadataToImagePlus
implements ImageplusMetadata<CanonicalDatasetMetadata> {
    private final boolean setDims;

    public CanonicalMetadataToImagePlus(boolean setDims) {
        this.setDims = setDims;
    }

    public CanonicalMetadataToImagePlus() {
        this(false);
    }

    @Override
    public void writeMetadata(CanonicalDatasetMetadata t, ImagePlus ip) throws IOException {
        if (t instanceof CanonicalSpatialDatasetMetadata) {
            this.writeSpatialMetadata((CanonicalSpatialDatasetMetadata)t, ip);
        }
        ip.setDisplayRange(t.minIntensity(), t.maxIntensity());
        if (t.getColorMetadata() != null) {
            int c = t.getColor().get();
            ip.setLut(LUT.createLutFromColor((Color)new Color(ARGBType.red((int)c), ARGBType.green((int)c), ARGBType.blue((int)c), ARGBType.alpha((int)c))));
        }
    }

    public void writeSpatialMetadata(CanonicalSpatialDatasetMetadata t, ImagePlus ip) throws IOException {
        int nd = t.getAttributes().getNumDimensions();
        AffineGet xfm = t.getSpatialTransform().spatialTransform();
        String unit = t.getSpatialTransform().unit();
        ip.setTitle(t.getPath());
        Calibration cal = ip.getCalibration();
        cal.pixelWidth = xfm.get(0, 0);
        cal.xOrigin = xfm.get(0, nd);
        cal.pixelHeight = xfm.get(1, 1);
        cal.yOrigin = xfm.get(1, nd);
        cal.setUnit(unit);
        Axis[] axes = t.getSpatialTransform().getAxes();
        long[] dims = t.getAttributes().getDimensions();
        if (axes != null) {
            ip.getCalibration().setXUnit(axes[0].getUnit());
            ip.getCalibration().setYUnit(axes[1].getUnit());
            int nz = 0;
            int nc = 0;
            int nt = 0;
            for (int i = 2; i < axes.length; ++i) {
                if (axes[i].getType().equals("space")) {
                    nz += (int)dims[i];
                    cal.pixelDepth = xfm.get(i, i);
                    cal.zOrigin = xfm.get(i, i + 1);
                    continue;
                }
                if (axes[i].getType().equals("time")) {
                    nt += (int)dims[i];
                    cal.frameInterval = xfm.get(i, i);
                    continue;
                }
                nc += (int)dims[i];
            }
            nc = nc == 0 ? 1 : nc;
            nz = nz == 0 ? 1 : nz;
            int n = nt = nt == 0 ? 1 : nt;
            if (this.setDims) {
                ip.setDimensions(nc, nz, nt);
            }
        } else if (this.setDims) {
            if (nd == 3) {
                ip.setDimensions(1, (int)dims[2], 1);
                cal.pixelDepth = xfm.get(2, 2);
                cal.zOrigin = xfm.get(2, nd);
            } else if (nd == 4) {
                ip.setDimensions((int)dims[3], (int)dims[2], 1);
                cal.pixelDepth = xfm.get(3, 3);
                cal.zOrigin = xfm.get(3, nd);
            }
        }
    }

    public Axis[] axesFromImageplus(ImagePlus imp) {
        int nd = imp.getNDimensions();
        Axis[] axes = new Axis[nd];
        axes[0] = new Axis("X", "space", imp.getCalibration().getXUnit());
        axes[1] = new Axis("Y", "space", imp.getCalibration().getYUnit());
        int i = 2;
        if (imp.getNChannels() > 1) {
            axes[i++] = new Axis("channels", "C", "null");
        }
        if (imp.getNSlices() > 1) {
            axes[i++] = new Axis("space", "Z", imp.getCalibration().getZUnit());
        }
        if (imp.getNFrames() > 1) {
            axes[i++] = new Axis("time", "T", imp.getCalibration().getTimeUnit());
        }
        return axes;
    }

    public AffineTransform getAffine(ImagePlus imp) {
        int nd = imp.getNDimensions();
        AffineTransform affine = new AffineTransform(nd);
        affine.set(imp.getCalibration().pixelWidth, 0, 0);
        affine.set(imp.getCalibration().xOrigin, 0, nd);
        affine.set(imp.getCalibration().pixelHeight, 1, 1);
        affine.set(imp.getCalibration().yOrigin, 1, nd);
        int i = 2;
        if (imp.getNChannels() > 1) {
            ++i;
        }
        if (imp.getNSlices() > 1) {
            affine.set(imp.getCalibration().pixelDepth, i, i);
            affine.set(imp.getCalibration().zOrigin, i, nd);
            ++i;
        }
        if (imp.getNFrames() > 1) {
            affine.set(imp.getCalibration().frameInterval, i, i);
            ++i;
        }
        return affine;
    }

    @Override
    public CanonicalSpatialDatasetMetadata readMetadata(ImagePlus imp) throws IOException {
        int nd = imp.getNDimensions();
        double[] params = this.getAffine(imp).getRowPackedCopy();
        int[] impDims = Arrays.stream(imp.getDimensions()).filter(x -> x > 1).toArray();
        long[] dims = Arrays.stream(impDims).mapToLong(x -> x).toArray();
        DatasetAttributes attributes = new DatasetAttributes(dims, impDims, DataType.FLOAT32, (Compression)new GzipCompression());
        SpatialMetadataCanonical spatialMeta = new SpatialMetadataCanonical("", (SpatialTransform)new AffineSpatialTransform(params), imp.getCalibration().getUnit(), this.axesFromImageplus(imp));
        return new CanonicalSpatialDatasetMetadata("", spatialMeta, attributes);
    }
}

