/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.types.extract;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.scijava.discovery.Discoverer;
import org.scijava.types.extract.TypeExtractor;
import org.scijava.types.extract.TypeReifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTypeReifier
implements TypeReifier {
    private Map<Class<?>, TypeExtractor> extractors;
    private final Collection<Discoverer> discoverers;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public DefaultTypeReifier(Discoverer ... discoverers) {
        this(Arrays.asList(discoverers));
    }

    public DefaultTypeReifier(Collection<Discoverer> discoverers) {
        this.discoverers = discoverers;
    }

    @Override
    public Optional<TypeExtractor> getExtractor(Class<?> c) {
        return Optional.ofNullable(this.extractors().getOrDefault(c, null));
    }

    private Map<Class<?>, TypeExtractor> extractors() {
        if (this.extractors == null) {
            this.initExtractors();
        }
        return this.extractors;
    }

    private synchronized void initExtractors() {
        if (this.extractors != null) {
            return;
        }
        this.extractors = this.getInstances();
    }

    private Map<Class<?>, TypeExtractor> getInstances() {
        HashMap instances = new HashMap();
        this.discoverers.stream().flatMap(d -> d.discover(TypeExtractor.class).stream()).sorted().forEach(e -> {
            TypeExtractor existing = instances.putIfAbsent(e.baseClass(), (TypeExtractor)e);
            if (existing != null) {
                this.log.warn("TypeExtractor " + e + " ignored - " + existing + " has already declared responsibility for reifying Class " + e.baseClass());
            }
        });
        return instances;
    }
}

