/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.types.infer;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.scijava.common3.Types;

public final class FunctionalInterfaces {
    private FunctionalInterfaces() {
    }

    public static Class<?> findFrom(Type type) {
        return FunctionalInterfaces.findFrom(Types.raw(type));
    }

    private static Class<?> findFrom(Class<?> type) {
        if (type == null) {
            return null;
        }
        if (type.getAnnotation(FunctionalInterface.class) != null) {
            return type;
        }
        for (Class<?> iface : type.getInterfaces()) {
            Class<?> result = FunctionalInterfaces.findFrom(iface);
            if (result == null) continue;
            return result;
        }
        return FunctionalInterfaces.findFrom(type.getSuperclass());
    }

    public static Method functionalMethodOf(Type type) {
        Class<?> functionalInterface = FunctionalInterfaces.findFrom(type);
        if (functionalInterface != null) {
            return FunctionalInterfaces.functionalMethodOf(functionalInterface);
        }
        throw new IllegalArgumentException(type + " does not implement a FunctionalInterface!");
    }

    private static Method functionalMethodOf(Class<?> functionalInterface) {
        Method[] typeMethods = (Method[])Arrays.stream(functionalInterface.getMethods()).filter(method -> Modifier.isAbstract(method.getModifiers())).toArray(Method[]::new);
        if (typeMethods.length != 1) {
            throw new IllegalArgumentException(functionalInterface + " should be a FunctionalInterface, however it has " + typeMethods.length + " abstract declared methods");
        }
        return typeMethods[0];
    }
}

