/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.types.infer;

import com.google.common.base.Objects;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import org.scijava.common3.Any;
import org.scijava.common3.Types;
import org.scijava.types.infer.TypeInferenceException;

class TypeMapping {
    protected final TypeVariable<?> typeVar;
    protected Type mappedType;
    boolean malleable;

    TypeMapping(TypeVariable<?> typeVar, Type mappedType, boolean malleable) {
        this.typeVar = typeVar;
        this.mappedType = mappedType;
        this.malleable = malleable;
    }

    public void refine(Type otherType, boolean newTypeMalleability) {
        if (Any.is(this.mappedType)) {
            this.mappedType = otherType;
            return;
        }
        if (Any.is(otherType)) {
            if (otherType instanceof Any) {
                Any casted = (Any)otherType;
                for (Type t : casted.getUpperBounds()) {
                    if (Types.isAssignable(this.mappedType, t)) continue;
                    throw new TypeInferenceException("Any " + casted + " has an upper bound on " + t + ", which is outside of the current mapped type " + this.mappedType + " of TypeVariable " + this.typeVar);
                }
                for (Type t : casted.getLowerBounds()) {
                    if (Types.isAssignable(t, this.mappedType)) continue;
                    throw new TypeInferenceException("Any " + casted + " has an lower bound on " + t + ", which is outside of the current mapped type " + this.mappedType + " of TypeVariable " + this.typeVar);
                }
            }
            return;
        }
        if (otherType instanceof WildcardType) {
            this.malleable &= newTypeMalleability;
            WildcardType wType = (WildcardType)otherType;
            if (wType.getLowerBounds().length == 0 && wType.getUpperBounds().length == 1 && wType.getUpperBounds()[0].equals(this.mappedType)) {
                return;
            }
        }
        if (this.malleable && Types.isAssignable(this.mappedType, otherType)) {
            this.malleable &= newTypeMalleability;
            this.mappedType = otherType;
            return;
        }
        if (Objects.equal((Object)this.mappedType, (Object)otherType)) {
            this.malleable &= newTypeMalleability;
            return;
        }
        throw new TypeInferenceException(this.typeVar + " cannot simultaneously be mapped to " + otherType + " and " + this.mappedType);
    }

    public Type getType() {
        return this.mappedType;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.typeVar, this.mappedType, this.malleable});
    }

    public boolean equals(Object o) {
        if (!(o instanceof TypeMapping)) {
            return false;
        }
        TypeMapping that = (TypeMapping)o;
        return Objects.equal(this.typeVar, that.typeVar) && Objects.equal((Object)this.mappedType, (Object)that.mappedType) && Objects.equal((Object)this.malleable, (Object)that.malleable);
    }

    public String toString() {
        return this.mappedType.toString();
    }
}

