/*
 * Decompiled with CFR 0.152.
 */
package bdv.tools.boundingbox;

import bdv.tools.boundingbox.AbstractTransformedBoxModel;
import bdv.tools.boundingbox.DragBoxCornerBehaviour;
import bdv.tools.boundingbox.TransformedBoxOverlay;
import bdv.tools.boundingbox.TransformedBoxOverlaySource;
import bdv.viewer.AbstractViewerPanel;
import bdv.viewer.ConverterSetups;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.scijava.listeners.ChangeListener;
import org.scijava.listeners.ListenableVar;
import org.scijava.ui.behaviour.Behaviour;
import org.scijava.ui.behaviour.BehaviourMap;
import org.scijava.ui.behaviour.InputTrigger;
import org.scijava.ui.behaviour.InputTriggerAdder;
import org.scijava.ui.behaviour.io.InputTriggerConfig;
import org.scijava.ui.behaviour.util.Behaviours;
import org.scijava.ui.behaviour.util.TriggerBehaviourBindings;

public class TransformedBoxEditor {
    private static final String BOUNDING_BOX_TOGGLE_EDITOR = "edit bounding-box";
    private static final String[] BOUNDING_BOX_TOGGLE_EDITOR_KEYS = new String[]{"button1"};
    private static final String BOUNDING_BOX_MAP = "bounding-box";
    private static final String BLOCKING_MAP = "bounding-box-blocking";
    private final TransformedBoxOverlay boxOverlay;
    private final TransformedBoxOverlaySource boxSource;
    private final AbstractViewerPanel viewer;
    private final TriggerBehaviourBindings triggerbindings;
    private final Behaviours behaviours;
    private final BehaviourMap blockMap;
    private boolean editable = true;

    public TransformedBoxEditor(InputTriggerConfig keyconf, AbstractViewerPanel viewer, ConverterSetups converterSetups, int setupId, TriggerBehaviourBindings triggerbindings, AbstractTransformedBoxModel model) {
        this(keyconf, viewer, converterSetups, setupId, triggerbindings, model, "selection", BoxSourceType.PLACEHOLDER);
    }

    public TransformedBoxEditor(InputTriggerConfig keyconf, AbstractViewerPanel viewer, ConverterSetups converterSetups, int setupId, TriggerBehaviourBindings triggerbindings, AbstractTransformedBoxModel model, String boxSourceName, BoxSourceType boxSourceType) {
        this.viewer = viewer;
        this.triggerbindings = triggerbindings;
        this.boxOverlay = new TransformedBoxOverlay(model);
        this.boxOverlay.setPerspective(0.0);
        this.boxOverlay.boxDisplayMode().listeners().add(() -> {
            viewer.requestRepaint();
            this.updateEditability();
        });
        switch (boxSourceType) {
            case PLACEHOLDER: {
                this.boxSource = new TransformedBoxOverlaySource(boxSourceName, this.boxOverlay, model, viewer, converterSetups, setupId);
                break;
            }
            default: {
                this.boxSource = null;
            }
        }
        this.behaviours = new Behaviours((InputTriggerAdder.Factory)keyconf, new String[]{"bdv"});
        this.behaviours.behaviour((Behaviour)new DragBoxCornerBehaviour(this.boxOverlay, model), BOUNDING_BOX_TOGGLE_EDITOR, BOUNDING_BOX_TOGGLE_EDITOR_KEYS);
        this.blockMap = new BehaviourMap();
    }

    public void install() {
        this.viewer.getDisplay().overlays().add((Object)this.boxOverlay);
        this.viewer.renderTransformListeners().add((Object)this.boxOverlay);
        this.viewer.getDisplay().addHandler(this.boxOverlay.getCornerHighlighter());
        this.refreshBlockMap();
        this.updateEditability();
        if (this.boxSource != null) {
            this.boxSource.addToViewer();
        }
    }

    public void uninstall() {
        this.viewer.getDisplay().overlays().remove((Object)this.boxOverlay);
        this.viewer.renderTransformListeners().remove((Object)this.boxOverlay);
        this.viewer.getDisplay().removeHandler(this.boxOverlay.getCornerHighlighter());
        this.triggerbindings.removeInputTriggerMap(BOUNDING_BOX_MAP);
        this.triggerbindings.removeBehaviourMap(BOUNDING_BOX_MAP);
        this.unblock();
        if (this.boxSource != null) {
            this.boxSource.removeFromViewer();
        }
    }

    public boolean getFillIntersection() {
        return this.boxOverlay.getFillIntersection();
    }

    public void setFillIntersection(boolean fill) {
        this.boxOverlay.fillIntersection(fill);
    }

    public ListenableVar<TransformedBoxOverlay.BoxDisplayMode, ChangeListener> boxDisplayMode() {
        return this.boxOverlay.boxDisplayMode();
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        if (this.editable == editable) {
            return;
        }
        this.editable = editable;
        this.boxOverlay.showCornerHandles(editable);
        this.updateEditability();
    }

    public void setPerspective(double perspective, double sourceSize) {
        this.boxOverlay.setPerspective(perspective);
        this.boxOverlay.setSourceSize(sourceSize);
    }

    private void updateEditability() {
        if (this.editable && this.boxOverlay.boxDisplayMode().get() == TransformedBoxOverlay.BoxDisplayMode.FULL) {
            this.boxOverlay.setHighlightedCornerListener(this::highlightedCornerChanged);
            this.behaviours.install(this.triggerbindings, BOUNDING_BOX_MAP);
            this.highlightedCornerChanged();
        } else {
            this.boxOverlay.setHighlightedCornerListener(null);
            this.triggerbindings.removeInputTriggerMap(BOUNDING_BOX_MAP);
            this.triggerbindings.removeBehaviourMap(BOUNDING_BOX_MAP);
            this.unblock();
        }
    }

    private void block() {
        this.triggerbindings.addBehaviourMap(BLOCKING_MAP, this.blockMap);
    }

    private void unblock() {
        this.triggerbindings.removeBehaviourMap(BLOCKING_MAP);
    }

    private void highlightedCornerChanged() {
        int index = this.boxOverlay.getHighlightedCornerIndex();
        if (index < 0) {
            this.unblock();
        } else {
            this.block();
        }
    }

    private void refreshBlockMap() {
        this.triggerbindings.removeBehaviourMap(BLOCKING_MAP);
        HashSet<InputTrigger> moveCornerTriggers = new HashSet<InputTrigger>();
        for (String s : BOUNDING_BOX_TOGGLE_EDITOR_KEYS) {
            moveCornerTriggers.add(InputTrigger.getFromString((String)s));
        }
        Map bindings = this.triggerbindings.getConcatenatedInputTriggerMap().getAllBindings();
        HashSet behavioursToBlock = new HashSet();
        for (InputTrigger t : moveCornerTriggers) {
            behavioursToBlock.addAll(bindings.getOrDefault(t, Collections.emptySet()));
        }
        this.blockMap.clear();
        Behaviour block = new Behaviour(){};
        for (String key : behavioursToBlock) {
            this.blockMap.put(key, block);
        }
    }

    public static enum BoxSourceType {
        NONE,
        PLACEHOLDER;

    }
}

