/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

import bdv.util.AbstractSource;
import bdv.viewer.Interpolation;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.view.Views;

public class RandomAccessibleSource<T extends NumericType<T>>
extends AbstractSource<T> {
    private final RandomAccessible<T> source;
    private final Interval interval;
    private final RealRandomAccessible<T>[] interpolatedSources;
    private final AffineTransform3D sourceTransform;

    public RandomAccessibleSource(RandomAccessible<T> img, Interval interval, T type, String name) {
        this(img, interval, type, new AffineTransform3D(), name, false);
    }

    public RandomAccessibleSource(RandomAccessible<T> img, Interval interval, T type, AffineTransform3D sourceTransform, String name) {
        this(img, interval, type, sourceTransform, name, false);
    }

    public RandomAccessibleSource(RandomAccessible<T> img, Interval interval, T type, AffineTransform3D sourceTransform, String name, boolean doBoundingBoxCulling) {
        super(type, name, doBoundingBoxCulling);
        this.source = img;
        this.interval = interval;
        this.sourceTransform = sourceTransform;
        this.interpolatedSources = new RealRandomAccessible[Interpolation.values().length];
        for (Interpolation method : Interpolation.values()) {
            this.interpolatedSources[method.ordinal()] = Views.interpolate(this.source, this.interpolators.get(method));
        }
    }

    @Override
    public RandomAccessibleInterval<T> getSource(int t, int level) {
        return Views.interval(this.source, (Interval)this.interval);
    }

    @Override
    public RealRandomAccessible<T> getInterpolatedSource(int t, int level, Interpolation method) {
        return this.interpolatedSources[method.ordinal()];
    }

    @Override
    public synchronized void getSourceTransform(int t, int level, AffineTransform3D transform) {
        transform.set(this.sourceTransform);
    }
}

