/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

import bdv.viewer.Interpolation;
import bdv.viewer.Source;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.Type;
import net.imglib2.view.Views;

public abstract class RealRandomAccessibleSource<T extends Type<T>>
implements Source<T> {
    protected RealRandomAccessible<T> accessible;
    protected final T type;
    protected final String name;
    protected final VoxelDimensions voxelDimensions;
    protected final boolean doBoundingBoxIntersectionCheck;

    public RealRandomAccessibleSource(RealRandomAccessible<T> accessible, T type, String name) {
        this(accessible, type, name, null, false);
    }

    public RealRandomAccessibleSource(RealRandomAccessible<T> accessible, T type, String name, VoxelDimensions voxelDimensions) {
        this(accessible, type, name, voxelDimensions, false);
    }

    public RealRandomAccessibleSource(RealRandomAccessible<T> accessible, T type, String name, VoxelDimensions voxelDimensions, boolean doBoundingBoxIntersectionCheck) {
        this.accessible = accessible;
        this.type = type.createVariable();
        this.name = name;
        this.voxelDimensions = voxelDimensions;
        this.doBoundingBoxIntersectionCheck = doBoundingBoxIntersectionCheck;
    }

    @Override
    public boolean isPresent(int t) {
        return true;
    }

    public abstract Interval getInterval(int var1, int var2);

    @Override
    public RandomAccessibleInterval<T> getSource(int t, int level) {
        return Views.interval((RandomAccessible)Views.raster(this.accessible), (Interval)this.getInterval(t, level));
    }

    @Override
    public RealRandomAccessible<T> getInterpolatedSource(int t, int level, Interpolation method) {
        return this.accessible;
    }

    @Override
    public void getSourceTransform(int t, int level, AffineTransform3D transform) {
        transform.identity();
    }

    @Override
    public T getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public VoxelDimensions getVoxelDimensions() {
        return this.voxelDimensions;
    }

    @Override
    public int getNumMipmapLevels() {
        return 1;
    }

    @Override
    public boolean doBoundingBoxCulling() {
        return this.doBoundingBoxIntersectionCheck;
    }
}

