/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer;

import bdv.util.Affine3DHelpers;
import bdv.viewer.InteractiveDisplay;
import bdv.viewer.RequestRepaint;
import bdv.viewer.Source;
import bdv.viewer.TransformListener;
import bdv.viewer.ViewerState;
import bdv.viewer.animate.AbstractTransformAnimator;
import bdv.viewer.animate.OverlayAnimator;
import bdv.viewer.animate.RotationAnimator;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import net.imglib2.Positionable;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.util.LinAlgHelpers;
import org.scijava.listeners.Listeners;
import org.scijava.ui.behaviour.io.InputTriggerConfig;

public abstract class AbstractViewerPanel
extends JPanel
implements RequestRepaint {
    protected final MouseCoordinateListener mouseCoordinates = new MouseCoordinateListener();
    private static final double c = Math.cos(0.7853981633974483);

    public AbstractViewerPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    public AbstractViewerPanel(LayoutManager layout) {
        this(layout, true);
    }

    public abstract InputTriggerConfig getInputTriggerConfig();

    public abstract InteractiveDisplay getDisplay();

    public abstract Component getDisplayComponent();

    public abstract void addOverlayAnimator(OverlayAnimator var1);

    public abstract ViewerState state();

    public abstract Listeners<TransformListener<AffineTransform3D>> renderTransformListeners();

    public abstract Listeners<TransformListener<AffineTransform3D>> transformListeners();

    public abstract void setTransformAnimator(AbstractTransformAnimator var1);

    public abstract void showMessage(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void align(AlignPlane plane) {
        double centerY;
        double centerX;
        Source<?> source = this.state().getCurrentSource().getSpimSource();
        AffineTransform3D sourceTransform = new AffineTransform3D();
        source.getSourceTransform(this.state().getCurrentTimepoint(), 0, sourceTransform);
        double[] qSource = new double[4];
        Affine3DHelpers.extractRotationAnisotropic(sourceTransform, qSource);
        double[] qTmpSource = new double[4];
        Affine3DHelpers.extractApproximateRotationAffine(sourceTransform, qSource, plane.coerceAffineDimension);
        LinAlgHelpers.quaternionMultiply((double[])qSource, (double[])plane.qAlign, (double[])qTmpSource);
        double[] qTarget = new double[4];
        LinAlgHelpers.quaternionInvert((double[])qTmpSource, (double[])qTarget);
        AffineTransform3D transform = this.state().getViewerTransform();
        MouseCoordinateListener mouseCoordinateListener = this.mouseCoordinates;
        synchronized (mouseCoordinateListener) {
            if (this.mouseCoordinates.isMouseInsidePanel()) {
                centerX = this.mouseCoordinates.getX();
                centerY = this.mouseCoordinates.getY();
            } else {
                centerY = (double)this.getDisplayComponent().getHeight() / 2.0;
                centerX = (double)this.getDisplayComponent().getWidth() / 2.0;
            }
        }
        this.setTransformAnimator(new RotationAnimator(transform, centerX, centerY, qTarget, 300L));
    }

    public void getGlobalMouseCoordinates(RealPositionable gPos) {
        assert (gPos.numDimensions() == 3);
        RealPoint lPos = new RealPoint(3);
        this.mouseCoordinates.getMouseCoordinates((Positionable)lPos);
        this.state().getViewerTransform().applyInverse(gPos, (RealLocalizable)lPos);
    }

    public void getMouseCoordinates(Positionable p) {
        assert (p.numDimensions() == 2);
        this.mouseCoordinates.getMouseCoordinates(p);
    }

    protected void onMouseMoved() {
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.getDisplayComponent().requestFocusInWindow();
    }

    static /* synthetic */ double access$000() {
        return c;
    }

    protected class MouseCoordinateListener
    implements MouseMotionListener,
    MouseListener {
        private int x;
        private int y;
        private boolean isInside;

        protected MouseCoordinateListener() {
        }

        public synchronized void getMouseCoordinates(Positionable p) {
            p.setPosition(this.x, 0);
            p.setPosition(this.y, 1);
        }

        @Override
        public synchronized void mouseDragged(MouseEvent e) {
            this.x = e.getX();
            this.y = e.getY();
        }

        @Override
        public synchronized void mouseMoved(MouseEvent e) {
            this.x = e.getX();
            this.y = e.getY();
            AbstractViewerPanel.this.onMouseMoved();
        }

        public synchronized int getX() {
            return this.x;
        }

        public synchronized int getY() {
            return this.y;
        }

        public synchronized boolean isMouseInsidePanel() {
            return this.isInside;
        }

        @Override
        public synchronized void mouseEntered(MouseEvent e) {
            this.isInside = true;
        }

        @Override
        public synchronized void mouseExited(MouseEvent e) {
            this.isInside = false;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    public static enum AlignPlane {
        XY(2, new double[]{1.0, 0.0, 0.0, 0.0}),
        ZY(0, new double[]{AbstractViewerPanel.access$000(), 0.0, -AbstractViewerPanel.access$000(), 0.0}),
        XZ(1, new double[]{AbstractViewerPanel.access$000(), AbstractViewerPanel.access$000(), 0.0, 0.0});

        public final double[] qAlign;
        public final int coerceAffineDimension;

        private AlignPlane(int coerceAffineDimension, double[] qAlign) {
            this.coerceAffineDimension = coerceAffineDimension;
            this.qAlign = qAlign;
        }
    }
}

