/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.pointset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.imglib2.AbstractCursor;
import net.imglib2.ops.pointset.AbstractPointSet;
import net.imglib2.ops.pointset.PointSet;
import net.imglib2.ops.pointset.PointSetIterator;

@Deprecated
public class GeneralPointSet
extends AbstractPointSet {
    private final int numD;
    private long[] origin;
    private long[] boundMin;
    private long[] boundMax;
    private final List<long[]> points;

    public GeneralPointSet(long[] origin, List<long[]> pts) {
        if (pts.size() == 0) {
            throw new IllegalArgumentException("no points specified!");
        }
        this.numD = origin.length;
        this.origin = (long[])origin.clone();
        this.boundMin = new long[this.numD];
        this.boundMax = new long[this.numD];
        this.points = new ArrayList<long[]>();
        this.points.addAll(pts);
        this.calcBounds(pts);
    }

    @Override
    public long[] getOrigin() {
        return this.origin;
    }

    @Override
    public void translate(long[] deltas) {
        for (long[] pt : this.points) {
            for (int i = 0; i < this.numD; ++i) {
                int n = i;
                pt[n] = pt[n] + deltas[i];
            }
        }
        int i = 0;
        while (i < this.numD) {
            long delta = deltas[i];
            int n = i;
            this.origin[n] = this.origin[n] + delta;
            int n2 = i;
            this.boundMin[n2] = this.boundMin[n2] + delta;
            int n3 = i++;
            this.boundMax[n3] = this.boundMax[n3] + delta;
        }
        this.invalidateBounds();
    }

    @Override
    public PointSetIterator iterator() {
        return new GeneralPointSetIterator();
    }

    @Override
    public int numDimensions() {
        return this.numD;
    }

    @Override
    public boolean includes(long[] point) {
        for (long[] p : this.points) {
            if (!Arrays.equals(point, p)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected long[] findBoundMin() {
        return this.boundMin;
    }

    @Override
    protected long[] findBoundMax() {
        return this.boundMax;
    }

    @Override
    public long size() {
        return this.points.size();
    }

    @Override
    public GeneralPointSet copy() {
        ArrayList<long[]> pointsCopied = new ArrayList<long[]>();
        for (long[] p : this.points) {
            pointsCopied.add((long[])p.clone());
        }
        return new GeneralPointSet(this.origin, pointsCopied);
    }

    public static GeneralPointSet explode(PointSet ps) {
        ArrayList<long[]> points = new ArrayList<long[]>();
        PointSetIterator iter = ps.iterator();
        while (iter.hasNext()) {
            points.add((long[])((long[])iter.next()).clone());
        }
        return new GeneralPointSet(ps.getOrigin(), points);
    }

    private void calcBounds(List<long[]> pts) {
        int i;
        for (i = 0; i < this.numD; ++i) {
            long val;
            this.boundMin[i] = val = pts.get(0)[i];
            this.boundMax[i] = val;
        }
        for (i = 1; i < pts.size(); ++i) {
            long[] point = pts.get(i);
            for (int j = 0; j < this.numD; ++j) {
                if (point[j] < this.boundMin[j]) {
                    this.boundMin[j] = point[j];
                }
                if (point[j] <= this.boundMax[j]) continue;
                this.boundMax[j] = point[j];
            }
        }
    }

    private class GeneralPointSetIterator
    extends AbstractCursor<long[]>
    implements PointSetIterator {
        private int index;

        public GeneralPointSetIterator() {
            super(GeneralPointSet.this.numD);
            this.index = -1;
        }

        public boolean hasNext() {
            return this.index + 1 < GeneralPointSet.this.points.size();
        }

        public void reset() {
            this.index = -1;
        }

        public long[] get() {
            if (this.index < 0) {
                return null;
            }
            return (long[])GeneralPointSet.this.points.get(this.index);
        }

        public void fwd() {
            ++this.index;
        }

        public void localize(long[] position) {
            for (int i = 0; i < GeneralPointSet.this.numD; ++i) {
                position[i] = this.getLongPosition(i);
            }
        }

        public long getLongPosition(int d) {
            return this.get()[d];
        }

        public AbstractCursor<long[]> copy() {
            return new GeneralPointSetIterator();
        }

        public AbstractCursor<long[]> copyCursor() {
            return this.copy();
        }
    }
}

