/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.filter.pad;

import java.util.function.BiFunction;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.ComplexType;

public class PaddingIntervalOrigin<T extends ComplexType<T>, I extends RandomAccessibleInterval<T>, O extends Interval>
implements BiFunction<I, Interval, O> {
    @Override
    public O apply(I input, Interval centeredInterval) {
        int numDimensions = input.numDimensions();
        long[] min = new long[numDimensions];
        long[] max = new long[numDimensions];
        for (int d = 0; d < numDimensions; ++d) {
            min[d] = input.min(d) + input.dimension(d) / 2L;
            max[d] = min[d] + centeredInterval.dimension(d) - 1L;
        }
        return (O)new FinalInterval(min, max);
    }
}

