/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.geom.geom2d;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.function.Function;
import net.imglib2.RealLocalizable;
import net.imglib2.roi.geom.real.DefaultWritablePolygon2D;
import net.imglib2.roi.geom.real.Polygon2D;
import org.scijava.ops.image.geom.GeomUtils;

public class DefaultConvexHull2D
implements Function<Polygon2D, Polygon2D> {
    @Override
    public Polygon2D apply(Polygon2D input) {
        ArrayList<RealLocalizable> RealPoints = new ArrayList<RealLocalizable>(GeomUtils.vertices(input));
        Collections.sort(RealPoints, new Comparator<RealLocalizable>(){

            @Override
            public int compare(RealLocalizable o1, RealLocalizable o2) {
                Double o2x;
                Double o1x = new Double(o1.getDoublePosition(0));
                int result = o1x.compareTo(o2x = new Double(o2.getDoublePosition(0)));
                if (result == 0) {
                    return new Double(o1.getDoublePosition(1)).compareTo(new Double(o2.getDoublePosition(1)));
                }
                return result;
            }
        });
        ArrayList<RealLocalizable> U = new ArrayList<RealLocalizable>();
        ArrayList<RealLocalizable> L = new ArrayList<RealLocalizable>();
        for (RealLocalizable p : RealPoints) {
            while (L.size() >= 2 && this.ccw((RealLocalizable)L.get(L.size() - 2), (RealLocalizable)L.get(L.size() - 1), p) <= 0.0) {
                L.remove(L.size() - 1);
            }
            L.add(p);
        }
        Collections.reverse(RealPoints);
        for (RealLocalizable p : RealPoints) {
            while (U.size() >= 2 && this.ccw((RealLocalizable)U.get(U.size() - 2), (RealLocalizable)U.get(U.size() - 1), p) <= 0.0) {
                U.remove(U.size() - 1);
            }
            U.add(p);
        }
        L.remove(L.size() - 1);
        U.remove(U.size() - 1);
        L.addAll(U);
        return new DefaultWritablePolygon2D(L);
    }

    private double ccw(RealLocalizable o, RealLocalizable a, RealLocalizable b) {
        return (a.getDoublePosition(0) - o.getDoublePosition(0)) * (b.getDoublePosition(1) - o.getDoublePosition(1)) - (a.getDoublePosition(1) - o.getDoublePosition(1)) * (b.getDoublePosition(0) - o.getDoublePosition(0));
    }
}

