/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.image.distancetransform;

import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.RealType;

class Phase3Runnable3D<T extends RealType<T>>
implements Runnable {
    private final RandomAccessibleInterval<T> raOut;
    private final int[][][] tempValues;
    private final int xPos;
    private final int yPos;
    private final int deep;

    public Phase3Runnable3D(int[][][] tempValues, RandomAccessibleInterval<T> raOut, int xPos, int yPos) {
        this.tempValues = tempValues;
        this.raOut = raOut;
        this.xPos = xPos;
        this.yPos = yPos;
        this.deep = (int)raOut.dimension(2);
    }

    private int distancefunc(int x, int i, int raOutValue) {
        return (x - i) * (x - i) + raOutValue;
    }

    private int sep(int i, int u, int w, int v) {
        return (u * u - i * i + w - v) / (2 * (u - i));
    }

    @Override
    public void run() {
        int[] s = new int[this.deep];
        int[] t = new int[this.deep];
        int q = 0;
        s[0] = 0;
        t[0] = 0;
        for (int u = 1; u < this.deep; ++u) {
            while (q >= 0 && this.distancefunc(t[q], s[q], this.tempValues[this.xPos][this.yPos][s[q]]) > this.distancefunc(t[q], u, this.tempValues[this.xPos][this.yPos][u])) {
                --q;
            }
            if (q < 0) {
                q = 0;
                s[0] = u;
                continue;
            }
            int w = 1 + this.sep(s[q], u, this.tempValues[this.xPos][this.yPos][u], this.tempValues[this.xPos][this.yPos][s[q]]);
            if (w >= this.deep) continue;
            s[++q] = u;
            t[q] = w;
        }
        RandomAccess ra = this.raOut.randomAccess();
        for (int u = this.deep - 1; u >= 0; --u) {
            ra.setPosition(this.xPos, 0);
            ra.setPosition(this.yPos, 1);
            ra.setPosition(u, 2);
            ((RealType)ra.get()).setReal(Math.sqrt(this.distancefunc(u, s[q], this.tempValues[this.xPos][this.yPos][s[q]])));
            if (u != t[q]) continue;
            --q;
        }
    }
}

