/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.image.normalize;

import net.imglib2.converter.Converter;
import net.imglib2.type.numeric.RealType;
import org.scijava.function.Computers;

class NormalizeRealTypeComputer<I extends RealType<I>, O extends RealType<O>>
implements Computers.Arity1<I, O>,
Converter<I, O> {
    private double targetMin;
    private double targetMax;
    private double sourceMin;
    private double factor;

    public NormalizeRealTypeComputer() {
    }

    public NormalizeRealTypeComputer(double sourceMin, double sourceMax, double targetMin, double targetMax) {
        this.setup(sourceMin, sourceMax, targetMin, targetMax);
    }

    public void setup(double sourceMin, double sourceMax, double targetMin, double targetMax) {
        this.sourceMin = sourceMin;
        double tmp = sourceMax;
        this.targetMin = targetMin;
        this.targetMax = targetMax;
        this.factor = 1.0 / (tmp - this.sourceMin) * (this.targetMax - this.targetMin);
    }

    public void compute(I input, O output) {
        double res = (input.getRealDouble() - this.sourceMin) * this.factor + this.targetMin;
        if (res > this.targetMax) {
            output.setReal(this.targetMax);
        } else if (res < this.targetMin) {
            output.setReal(this.targetMin);
        } else {
            output.setReal(res);
        }
    }

    public void convert(I input, O output) {
        this.compute(input, output);
    }
}

