/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.morphology.thin;

import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.type.logic.BitType;
import org.scijava.ops.image.morphology.thin.Abstract3x3NeighbourhoodThinning;
import org.scijava.ops.image.morphology.thin.ThinningStrategy;

public class HilditchThinningStrategy
extends Abstract3x3NeighbourhoodThinning {
    public HilditchThinningStrategy() {
    }

    public HilditchThinningStrategy(boolean foreground) {
        super(foreground);
    }

    @Override
    public boolean removePixel(long[] position, RandomAccessible<BitType> accessible, int iteration) {
        RandomAccess<BitType> access = this.randomAccess(accessible);
        access.setPosition(position);
        boolean[] vals = this.getNeighbourhood(access);
        int numForeground = 0;
        for (int i = 1; i < vals.length; ++i) {
            if (vals[i] != this.m_foreground) continue;
            ++numForeground;
        }
        if (2 > numForeground || numForeground > 6) {
            return false;
        }
        int numPatterns = this.findPatternSwitches(vals);
        if (numPatterns != 1) {
            return false;
        }
        access.setPosition(position);
        access.move(-1, 1);
        int p2Patterns = this.findPatternSwitches(this.getNeighbourhood(access));
        if (vals[1] != this.m_background && vals[3] != this.m_background && vals[7] != this.m_background && p2Patterns == 1) {
            return false;
        }
        access.setPosition(position);
        access.move(1, 0);
        int p4Patterns = this.findPatternSwitches(this.getNeighbourhood(access));
        return vals[1] == this.m_background || vals[3] == this.m_background || vals[5] == this.m_background || p4Patterns != 1;
    }

    @Override
    public ThinningStrategy copy() {
        return new HilditchThinningStrategy(this.m_foreground);
    }
}

