/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.threshold.localNiblack;

import net.imglib2.algorithm.neighborhood.RectangleNeighborhood;
import net.imglib2.converter.RealDoubleConverter;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.AbstractRealType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.view.composite.Composite;
import org.scijava.function.Computers;
import org.scijava.ops.spi.OpDependency;

public class ComputeLocalNiblackThresholdIntegral<T extends RealType<T>, U extends RealType<U>>
implements Computers.Arity4<RectangleNeighborhood<? extends Composite<U>>, T, Double, Double, BitType> {
    @OpDependency(name="stats.integralMean")
    private Computers.Arity1<RectangleNeighborhood<? extends Composite<U>>, DoubleType> integralMeanOp;
    @OpDependency(name="stats.integralVariance")
    private Computers.Arity1<RectangleNeighborhood<? extends Composite<U>>, DoubleType> integralVarianceOp;

    public void compute(RectangleNeighborhood<? extends Composite<U>> inputNeighborhood, T inputCenterPixel, Double c, Double k, BitType output) {
        DoubleType threshold = new DoubleType(0.0);
        DoubleType mean = new DoubleType();
        this.integralMeanOp.compute(inputNeighborhood, (Object)mean);
        threshold.add((AbstractRealType)mean);
        DoubleType variance = new DoubleType();
        this.integralVarianceOp.compute(inputNeighborhood, (Object)variance);
        DoubleType stdDev = new DoubleType(Math.sqrt(variance.get()));
        stdDev.mul(k.doubleValue());
        threshold.add((AbstractRealType)stdDev);
        threshold.sub((AbstractRealType)new DoubleType(c.doubleValue()));
        RealDoubleConverter conv = new RealDoubleConverter();
        DoubleType centerPixelAsDoubleType = variance;
        conv.convert(inputCenterPixel, (Object)centerPixelAsDoubleType);
        output.set(centerPixelAsDoubleType.compareTo((AbstractRealType)threshold) > 0);
    }
}

