/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.utils;

import ij3d.Volume;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyValueFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.RealType;

public class ImgLibVolume<T extends RealType<T>>
extends Volume {
    final Image<T> img;
    LocalizableByDimCursor<T> cursor = null;
    protected int dataType = 1;

    public ImgLibVolume(Image<T> img, float[] origin) throws Exception {
        if (img.getNumDimensions() < 3) {
            throw new Exception("Image does not support at least 3 dimensions.");
        }
        this.img = img;
        this.xDim = img.getDimension(0);
        this.yDim = img.getDimension(1);
        this.zDim = img.getDimension(2);
        this.pw = img.getCalibration(0);
        this.ph = img.getCalibration(1);
        this.pd = img.getCalibration(2);
        System.out.println("dims: " + this.xDim + ", " + this.yDim + ", " + this.zDim + " :: " + this.pw + ", " + this.ph + ", " + this.pd);
        float xSpace = (float)this.pw;
        float ySpace = (float)this.ph;
        float zSpace = (float)this.pd;
        this.minCoord.x = origin[0];
        this.minCoord.y = origin[1];
        this.minCoord.z = origin[2];
        this.maxCoord.x = this.minCoord.x + (double)((float)this.xDim * xSpace);
        this.maxCoord.y = this.minCoord.y + (double)((float)this.yDim * ySpace);
        this.maxCoord.z = this.minCoord.z + (double)((float)this.zDim * zSpace);
        this.initLoader();
    }

    public Image<T> getImage() {
        return this.img;
    }

    protected void initLoader() {
        RealType val = (RealType)this.img.createType();
        val.setReal(0.0f);
        this.cursor = this.img.createLocalizableByDimCursor((OutOfBoundsStrategyFactory)new OutOfBoundsStrategyValueFactory((Type)val));
    }

    public boolean setAverage(boolean a) {
        return false;
    }

    public void setNoCheck(int x, int y, int z, int v) {
        this.cursor.setPosition(x, 0);
        this.cursor.setPosition(y, 1);
        this.cursor.setPosition(z, 2);
        ((RealType)this.cursor.getType()).setReal((float)v);
    }

    public void set(int x, int y, int z, int v) {
        this.setNoCheck(x, y, z, v);
    }

    public int load(int x, int y, int z) {
        this.cursor.setPosition(x, 0);
        this.cursor.setPosition(y, 1);
        this.cursor.setPosition(z, 2);
        return (int)((RealType)this.cursor.getType()).getRealFloat();
    }

    public int getDataType() {
        return this.dataType;
    }
}

