/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.utils;

import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.process.FloatPolygon;
import ini.trakem2.display.VectorDataTransform;
import ini.trakem2.persistence.Loader;
import ini.trakem2.utils.CircularSequence;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.Utils;
import ini.trakem2.vector.VectorString2D;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mpicbg.models.AffineModel2D;
import mpicbg.models.CoordinateTransform;
import mpicbg.models.CoordinateTransformList;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Tuple3d;
import org.jogamp.vecmath.Tuple3f;
import org.jogamp.vecmath.Vector3d;
import org.jogamp.vecmath.Vector3f;

public final class M {
    private static Polygon arrowhead = null;
    private static final float phi = (1.0f + (float)Math.sqrt(5.0)) / 2.0f;
    private static final float[][] icosahedron = new float[][]{{phi, 1.0f, 0.0f}, {-phi, 1.0f, 0.0f}, {phi, -1.0f, 0.0f}, {-phi, -1.0f, 0.0f}, {1.0f, 0.0f, phi}, {1.0f, 0.0f, -phi}, {-1.0f, 0.0f, phi}, {-1.0f, 0.0f, -phi}, {0.0f, phi, 1.0f}, {0.0f, -phi, 1.0f}, {0.0f, phi, -1.0f}, {0.0f, -phi, -1.0f}};
    private static final int[][] icosfaces = new int[][]{{0, 8, 4}, {0, 5, 10}, {2, 4, 9}, {2, 11, 5}, {1, 6, 8}, {1, 10, 7}, {3, 9, 6}, {3, 7, 11}, {0, 10, 8}, {1, 8, 10}, {2, 9, 11}, {3, 11, 9}, {4, 2, 0}, {5, 0, 2}, {6, 1, 3}, {7, 3, 1}, {8, 6, 4}, {9, 4, 6}, {10, 5, 7}, {11, 7, 5}};

    public static final double distancePointToSegment(double px, double py, double pz, double lx1, double ly1, double lz1, double lx2, double ly2, double lz2) {
        return M.distancePointToSegment(new Vector3d(px, py, pz), new Vector3d(lx1, ly1, lz1), new Vector3d(lx2, ly2, lz2));
    }

    public static final double distancePointToSegmentSq(double px, double py, double pz, double lx1, double ly1, double lz1, double lx2, double ly2, double lz2) {
        return M.distancePointToSegmentSq(new Vector3d(px, py, pz), new Vector3d(lx1, ly1, lz1), new Vector3d(lx2, ly2, lz2));
    }

    public static final double distancePointToSegment(Vector3d p, Vector3d v1, Vector3d v2) {
        Vector3d v = new Vector3d();
        v.sub((Tuple3d)v2, (Tuple3d)v1);
        Vector3d w = new Vector3d();
        w.sub((Tuple3d)p, (Tuple3d)v1);
        double c1 = w.dot(v);
        if (c1 <= 0.0) {
            return M.distance((Tuple3d)p, (Tuple3d)v1);
        }
        double c2 = v.dot(v);
        if (c2 <= c1) {
            return M.distance((Tuple3d)p, (Tuple3d)v2);
        }
        double b = c1 / c2;
        Vector3d pb = new Vector3d(v);
        pb.scale(b);
        pb.add((Tuple3d)v1);
        return M.distance((Tuple3d)p, (Tuple3d)pb);
    }

    public static final double distancePointToSegmentSq(Vector3d p, Vector3d v1, Vector3d v2) {
        Vector3d v = new Vector3d();
        v.sub((Tuple3d)v2, (Tuple3d)v1);
        Vector3d w = new Vector3d();
        w.sub((Tuple3d)p, (Tuple3d)v1);
        double c1 = w.dot(v);
        if (c1 <= 0.0) {
            return M.distanceSq((Tuple3d)p, (Tuple3d)v1);
        }
        double c2 = v.dot(v);
        if (c2 <= c1) {
            return M.distanceSq((Tuple3d)p, (Tuple3d)v2);
        }
        double b = c1 / c2;
        Vector3d pb = new Vector3d(v);
        pb.scale(b);
        pb.add((Tuple3d)v1);
        return M.distanceSq((Tuple3d)p, (Tuple3d)pb);
    }

    public static final double distance(Tuple3d t1, Tuple3d t2) {
        return Math.sqrt(Math.pow(t1.x - t2.x, 2.0) + Math.pow(t1.y - t2.y, 2.0) + Math.pow(t1.z - t2.z, 2.0));
    }

    public static final double distanceSq(Tuple3d t1, Tuple3d t2) {
        return Math.pow(t1.x - t2.x, 2.0) + Math.pow(t1.y - t2.y, 2.0) + Math.pow(t1.z - t2.z, 2.0);
    }

    public static final double distance(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.sqrt(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0) + Math.pow(z1 - z2, 2.0));
    }

    public static final double distance(double x1, double y1, double x2, double y2) {
        return Math.sqrt(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0));
    }

    public static final double distanceSq(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0) + Math.pow(z1 - z2, 2.0);
    }

    public static double distancePointToLine(double px, double py, double pz, double lx1, double ly1, double lz1, double lx2, double ly2, double lz2) {
        double segment_length = new Vector3d(lx2 - lx1, ly2 - ly1, lz2 - lz1).length();
        if (0.0 == segment_length) {
            return 0.0;
        }
        Vector3d cross = new Vector3d();
        cross.cross(new Vector3d(px - lx1, py - ly1, pz - lz1), new Vector3d(px - lx2, py - ly2, pz - lz2));
        return cross.length() / segment_length;
    }

    public static double distancePointToLine(double px, double py, double lx1, double ly1, double lx2, double ly2) {
        return Math.abs((lx2 - lx1) * (ly1 - py) - (lx1 - px) * (ly2 - ly1)) / Math.sqrt(Math.pow(lx2 - lx1, 2.0) + Math.pow(ly2 - ly1, 2.0));
    }

    public static double distancePointToSegment(double px, double py, double lx1, double ly1, double lx2, double ly2) {
        double xu = px - lx1;
        double xv = lx2 - lx1;
        double yu = py - ly1;
        double yv = ly2 - ly1;
        if (xu * xv + yu * yv < 0.0) {
            return Math.sqrt(Math.pow(px - lx1, 2.0) + Math.pow(py - ly1, 2.0));
        }
        xu = px - lx2;
        yu = py - ly2;
        if (xu * (xv = -xv) + yu * (yv = -yv) < 0.0) {
            return Math.sqrt(Math.pow(px - lx2, 2.0) + Math.pow(py - ly2, 2.0));
        }
        return Math.abs((px * (ly1 - ly2) + py * (lx2 - lx1) + (lx1 * ly2 - lx2 * ly1)) / Math.sqrt(Math.pow(lx2 - lx1, 2.0) + Math.pow(ly2 - ly1, 2.0)));
    }

    public static final boolean equals(double a, double b) {
        return Math.abs(a - b) < 1.0E-7;
    }

    public static final Point2D.Double transform(AffineTransform affine, double x, double y) {
        Point2D.Double pSrc = new Point2D.Double(x, y);
        if (affine.isIdentity()) {
            return pSrc;
        }
        Point2D.Double pDst = new Point2D.Double();
        affine.transform(pSrc, pDst);
        return pDst;
    }

    public static final Point2D.Double inverseTransform(AffineTransform affine, double x, double y) {
        Point2D.Double pSrc = new Point2D.Double(x, y);
        if (affine.isIdentity()) {
            return pSrc;
        }
        Point2D.Double pDst = new Point2D.Double();
        try {
            affine.createInverse().transform(pSrc, pDst);
        }
        catch (NoninvertibleTransformException nite) {
            IJError.print(nite);
        }
        return pDst;
    }

    public static final double getAngle(double x, double y) {
        double a = Math.atan2(x, y);
        if (a > Math.PI * 2) {
            a -= Math.PI * 2;
        }
        if (a >= 0.0 && a <= 1.5707963267948966) {
            a = 1.5707963267948966 - a;
        } else if (a < 0.0 && a >= -Math.PI) {
            a = 1.5707963267948966 - a;
        } else if (a > 1.5707963267948966 && a <= Math.PI) {
            a = 7.853981633974483 - a;
        }
        return a;
    }

    public static final boolean isEmpty(Area area) {
        Rectangle b = area.getBounds();
        return 0 == b.width || 0 == b.height;
    }

    public static final boolean intersects(Area a1, Area a2) {
        Area b = new Area(a1);
        b.intersect(a2);
        Rectangle r = b.getBounds();
        return 0 != r.width && 0 != r.height;
    }

    public static final Area getArea(Roi roi) {
        if (null == roi) {
            return null;
        }
        if (roi instanceof ShapeRoi) {
            return M.getArea((ShapeRoi)roi);
        }
        return M.getArea(new ShapeRoi(roi));
    }

    public static final Area getArea(ShapeRoi sroi) {
        if (null == sroi) {
            return null;
        }
        AffineTransform at = new AffineTransform();
        Rectangle bounds = sroi.getBounds();
        at.translate(bounds.x, bounds.y);
        Area area = new Area(sroi.getShape());
        area.transform(at);
        return area;
    }

    public static final double measureArea(Area area, Loader loader) {
        double sum = 0.0;
        try {
            Rectangle bounds = area.getBounds();
            double scale = 1.0;
            if (bounds.width > 2048 || bounds.height > 2048) {
                scale = 2048.0 / (double)bounds.width;
            }
            if (0.0 == scale) {
                Utils.log("Can't measure: area too large, out of scale range for approximation.");
                return sum;
            }
            AffineTransform at = new AffineTransform();
            at.translate(-bounds.x, -bounds.y);
            at.scale(scale, scale);
            area = area.createTransformedArea(at);
            bounds = area.getBounds();
            if (0 == bounds.width || 0 == bounds.height) {
                Utils.log("Can't measure: area too large, approximates zero.");
                return sum;
            }
            if (null != loader) {
                loader.releaseToFit(bounds.width * bounds.height * 3);
            }
            BufferedImage bi = new BufferedImage(bounds.width, bounds.height, 13);
            Graphics2D g = bi.createGraphics();
            g.setColor(Color.white);
            g.fill(area);
            byte[] pixels = ((DataBufferByte)bi.getRaster().getDataBuffer()).getData();
            for (int i = pixels.length - 1; i > -1; --i) {
                if (0 == pixels[i]) continue;
                sum += 1.0;
            }
            bi.flush();
            g.dispose();
            if (1.0 != scale) {
                sum /= scale * scale;
            }
        }
        catch (Throwable e) {
            IJError.print(e);
        }
        return sum;
    }

    public static final double measureArea(Point3f p1, Point3f p2, Point3f p3) {
        return 0.5 * M.distancePointToLine(p1.x, p1.y, p1.z, p2.x, p2.y, p2.z, p3.x, p3.y, p3.z) * (double)p2.distance(p3);
    }

    public static final boolean isAreaROI(Roi roi) {
        switch (roi.getType()) {
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                return false;
            }
        }
        return true;
    }

    public static final Collection<Polygon> getPolygons(Area area) {
        ArrayList<Polygon> pols = new ArrayList<Polygon>();
        Polygon pol = null;
        float[] coords = new float[6];
        PathIterator pit = area.getPathIterator(null);
        while (!pit.isDone()) {
            int seg_type = pit.currentSegment(coords);
            switch (seg_type) {
                case 0: {
                    pol = new Polygon();
                }
                case 1: {
                    pol.addPoint((int)coords[0], (int)coords[1]);
                    break;
                }
                case 4: {
                    pols.add(pol);
                    break;
                }
                default: {
                    Utils.log2("WARNING: unhandled seg type.");
                }
            }
            pit.next();
            if (!pit.isDone()) continue;
            break;
        }
        return pols;
    }

    public static final Area transform(CoordinateTransform ict, Area a) {
        GeneralPath path = new GeneralPath();
        float[] coords = new float[6];
        double[] fp = new double[2];
        PathIterator pit = a.getPathIterator(null);
        while (!pit.isDone()) {
            int seg_type = pit.currentSegment(coords);
            fp[0] = coords[0];
            fp[1] = coords[1];
            ict.applyInPlace(fp);
            switch (seg_type) {
                case 0: {
                    path.moveTo(fp[0], fp[1]);
                    break;
                }
                case 1: 
                case 4: {
                    path.lineTo(fp[0], fp[1]);
                    break;
                }
                default: {
                    Utils.log2("WARNING: unhandled seg type.");
                }
            }
            pit.next();
            if (!pit.isDone()) continue;
            break;
        }
        return new Area(path);
    }

    public static final void apply(CoordinateTransform ict, Area roi, Area a) {
        Area intersection = new Area(a);
        intersection.intersect(roi);
        a.subtract(intersection);
        a.add(M.transform(ict, intersection));
    }

    public static final void apply(VectorDataTransform vdt, Area a) {
        M.apply(vdt, a, false);
    }

    public static final void apply(VectorDataTransform vdt, Area a, boolean remove_outside) {
        Area b = new Area();
        for (VectorDataTransform.ROITransform rt : vdt.transforms) {
            Area intersection = new Area(a);
            intersection.intersect(rt.roi);
            a.subtract(intersection);
            b.add(M.transform(rt.ct, intersection));
        }
        if (!M.isEmpty(a)) {
            if (remove_outside) {
                Utils.log("WARNING: parts of an area in layer " + vdt.layer + "\n    did not intersect any transformation target\n    and where removed.");
                a.reset();
            } else {
                Utils.log("WARNING: parts of an area in layer " + vdt.layer + "\n    remain untransformed.");
            }
        }
        a.add(b);
    }

    public static final Polygon findPath(Area area, int x, int y) {
        Polygon pol = new Polygon();
        PathIterator pit = area.getPathIterator(null);
        while (!pit.isDone()) {
            float[] coords = new float[6];
            int seg_type = pit.currentSegment(coords);
            switch (seg_type) {
                case 0: 
                case 1: {
                    pol.addPoint((int)coords[0], (int)coords[1]);
                    break;
                }
                case 4: {
                    if (pol.contains(x, y)) {
                        return pol;
                    }
                    pol = new Polygon();
                    break;
                }
                default: {
                    Utils.log2("WARNING: unhandled seg type.");
                }
            }
            pit.next();
            if (!pit.isDone()) continue;
            break;
        }
        return null;
    }

    public static final Area areaInInts(Area area) {
        Area a = new Area();
        for (Polygon pol : M.getPolygons(area)) {
            a.exclusiveOr(new Area(pol));
        }
        return a;
    }

    public static final Area areaInIntsByRounding(Area area) {
        Path2D.Float pol = new Path2D.Float();
        float[] coords = new float[6];
        PathIterator pit = area.getPathIterator(null);
        while (!pit.isDone()) {
            int seg_type = pit.currentSegment(coords);
            switch (seg_type) {
                case 0: {
                    pol.moveTo(Math.round(coords[0]), Math.round(coords[1]));
                    break;
                }
                case 1: {
                    pol.lineTo(Math.round(coords[0]), Math.round(coords[1]));
                    break;
                }
                case 4: {
                    pol.closePath();
                    break;
                }
                default: {
                    Utils.log2("WARNING: unhandled seg type.");
                }
            }
            pit.next();
            if (!pit.isDone()) continue;
            break;
        }
        return new Area(pol);
    }

    public static void quicksort(float[] data, Object[] sortAlso) throws IllegalArgumentException {
        if (data.length != sortAlso.length) {
            throw new IllegalArgumentException("data and sortAlso arrays don't have the same length.");
        }
        M.quicksort(data, sortAlso, 0, data.length - 1);
    }

    public static void quicksort(float[] data, Object[] sortAlso, int left, int right) {
        if (data.length < 2) {
            return;
        }
        int i = left;
        int j = right;
        float x = data[(left + right) / 2];
        while (true) {
            if (data[i] < x) {
                ++i;
                continue;
            }
            while (x < data[j]) {
                --j;
            }
            if (i <= j) {
                float temp = data[i];
                data[i] = data[j];
                data[j] = temp;
                Object temp2 = sortAlso[i];
                sortAlso[i] = sortAlso[j];
                sortAlso[j] = temp2;
                ++i;
                --j;
            }
            if (i > j) break;
        }
        if (left < j) {
            M.quicksort(data, sortAlso, left, j);
        }
        if (i < right) {
            M.quicksort(data, sortAlso, i, right);
        }
    }

    public static final Shape createArrowhead(double x1, double y1, double x2, double y2) {
        return M.createArrowhead(x1, y1, x2, y2, 1.0);
    }

    public static final Shape createArrowhead(double x1, double y1, double x2, double y2, double magnification) {
        if (null == arrowhead) {
            arrowhead = new Polygon(new int[]{-14, -13, 0, -13, -14, -9}, new int[]{-5, -5, 0, 5, 5, 0}, 6);
        }
        AffineTransform aff = new AffineTransform();
        aff.translate(x2, y2);
        aff.rotate(M.getAngle(x2 - x1, y2 - y1));
        if (magnification < 1.0) {
            aff.scale(magnification, magnification);
        }
        return aff.createTransformedShape(arrowhead);
    }

    public static final List<Point3f> createIcosahedron(int subdivisions, float radius) {
        ArrayList<Point3f> ps = new ArrayList<Point3f>();
        for (int i = 0; i < icosfaces.length; ++i) {
            for (int k = 0; k < 3; ++k) {
                ps.add(new Point3f(icosahedron[icosfaces[i][k]]));
            }
        }
        while (subdivisions-- > 0) {
            ArrayList<Point3f> sub = new ArrayList<Point3f>();
            for (int i = 0; i < ps.size(); i += 3) {
                Point3f p0 = (Point3f)ps.get(i);
                Point3f p1 = (Point3f)ps.get(i + 1);
                Point3f p2 = (Point3f)ps.get(i + 2);
                Point3f p01 = new Point3f((p0.x + p1.x) / 2.0f, (p0.y + p1.y) / 2.0f, (p0.z + p1.z) / 2.0f);
                Point3f p02 = new Point3f((p0.x + p2.x) / 2.0f, (p0.y + p2.y) / 2.0f, (p0.z + p2.z) / 2.0f);
                Point3f p12 = new Point3f((p1.x + p2.x) / 2.0f, (p1.y + p2.y) / 2.0f, (p1.z + p2.z) / 2.0f);
                sub.add(p0);
                sub.add(p01);
                sub.add(p02);
                sub.add(new Point3f(p01));
                sub.add(p1);
                sub.add(p12);
                sub.add(new Point3f(p12));
                sub.add(p2);
                sub.add(new Point3f(p02));
                sub.add(new Point3f(p01));
                sub.add(new Point3f(p12));
                sub.add(new Point3f(p02));
            }
            ps = sub;
        }
        Vector3f v = new Vector3f();
        for (Point3f p : ps) {
            v.set((Tuple3f)p);
            v.normalize();
            v.scale(radius);
            p.set((Tuple3f)v);
        }
        return ps;
    }

    public static final void apply(CoordinateTransform ict, double[][] p, int i, double[] fp) {
        fp[0] = p[0][i];
        fp[1] = p[1][i];
        ict.applyInPlace(fp);
        p[0][i] = fp[0];
        p[1][i] = fp[1];
    }

    public static final CoordinateTransform wrap(AffineTransform to_world, CoordinateTransform ict, AffineTransform to_local) throws Exception {
        CoordinateTransformList chain = new CoordinateTransformList();
        AffineModel2D toworld = new AffineModel2D();
        toworld.set(to_world);
        chain.add((CoordinateTransform)toworld);
        chain.add(ict);
        AffineModel2D tolocal = new AffineModel2D();
        tolocal.set(to_local);
        chain.add((CoordinateTransform)tolocal);
        return chain;
    }

    public static final String shortest(float f, float precision) {
        return Math.abs(f - (float)((int)f)) < precision ? Integer.toString((int)f) : Float.toString(f);
    }

    public static final void appendShortest(float f, float precision, StringBuilder sb) {
        if (Math.abs(f - (float)((int)f)) < precision) {
            sb.append((int)f);
        } else {
            sb.append(f);
        }
    }

    public static final float[] computeSegmentsIntersection(float ax0, float ay0, float ax1, float ay1, float bx0, float by0, float bx1, float by1) {
        float d = (ax0 - ax1) * (by0 - by1) - (ay0 - ay1) * (bx0 - bx1);
        if (0.0f == d) {
            return null;
        }
        float xi = ((bx0 - bx1) * (ax0 * ay1 - ay0 * ax1) - (ax0 - ax1) * (bx0 * by1 - by0 * bx1)) / d;
        float yi = ((by0 - by1) * (ax0 * ay1 - ay0 * ax1) - (ay0 - ay1) * (bx0 * by1 - by0 * bx1)) / d;
        if (xi < Math.min(ax0, ax1) || xi > Math.max(ax0, ax1)) {
            return null;
        }
        if (xi < Math.min(bx0, bx1) || xi > Math.max(bx0, bx1)) {
            return null;
        }
        if (yi < Math.min(ay0, ay1) || yi > Math.max(ay0, ay1)) {
            return null;
        }
        if (yi < Math.min(by0, by1) || yi > Math.max(by0, by1)) {
            return null;
        }
        return new float[]{xi, yi};
    }

    public static final Area[] splitArea(Area a, PolygonRoi proi, Rectangle world) {
        int i1;
        int[] yb;
        int[] xb;
        int l;
        if (!a.getBounds().intersects(proi.getBounds())) {
            return new Area[]{a};
        }
        int[] x = proi.getXCoordinates();
        int[] y = proi.getYCoordinates();
        Rectangle rb = proi.getBounds();
        int len = proi.getNCoordinates();
        int x0 = x[0] + rb.x;
        int y0 = y[0] + rb.y;
        int xN = x[len - 1] + rb.x;
        int yN = y[len - 1] + rb.y;
        int[][] corners = new int[][]{{world.x, world.y}, {world.x + world.width, world.y}, {world.x + world.width, world.y + world.height}, {world.x, world.y + world.height}};
        double min_dist0 = Double.MAX_VALUE;
        int min_i0 = 0;
        int i = 0;
        double min_distN = Double.MAX_VALUE;
        int min_iN = 0;
        for (int[] corner : corners) {
            double d = M.distance(x0, y0, corner[0], corner[1]);
            if (d < min_dist0) {
                min_dist0 = d;
                min_i0 = i;
            }
            if ((d = M.distance(xN, yN, corner[0], corner[1])) < min_distN) {
                min_distN = d;
                min_iN = i;
            }
            ++i;
        }
        int i2 = -1;
        if (2 != Math.abs(min_iN - min_i0)) {
            l = len + 4;
            xb = new int[l];
            yb = new int[l];
            i1 = -4;
            xb[l - 4] = corners[min_iN][0];
            yb[l - 4] = corners[min_iN][1];
            xb[l - 3] = corners[min_iN][0];
            yb[l - 3] = corners[min_iN][1];
            xb[l - 2] = corners[min_i0][0];
            yb[l - 2] = corners[min_i0][1];
            xb[l - 1] = corners[min_i0][0];
            yb[l - 1] = corners[min_i0][1];
        } else {
            l = len + 5;
            xb = new int[l];
            yb = new int[l];
            i1 = -5;
            xb[l - 5] = corners[min_iN][0];
            yb[l - 5] = corners[min_iN][1];
            xb[l - 4] = corners[min_iN][0];
            yb[l - 4] = corners[min_iN][1];
            xb[l - 3] = corners[(min_iN + min_i0) / 2][0];
            yb[l - 3] = corners[(min_iN + min_i0) / 2][1];
            xb[l - 2] = corners[min_i0][0];
            yb[l - 2] = corners[min_i0][1];
            xb[l - 1] = corners[min_i0][0];
            yb[l - 1] = corners[min_i0][1];
        }
        for (int k = 0; k < len; ++k) {
            xb[k] = x[k] + rb.x;
            yb[k] = y[k] + rb.y;
        }
        int dx = Math.abs(xb[l + i1] - (x[len - 1] + rb.x));
        int dy = Math.abs(yb[l + i1] - (y[len - 1] + rb.y));
        if (dy < dx) {
            xb[l + i1] = x[len - 1] + rb.x;
        } else {
            yb[l + i1] = y[len - 1] + rb.y;
        }
        dx = Math.abs(xb[l + -1] - (x[0] + rb.x));
        dy = Math.abs(yb[l + -1] - (y[0] + rb.y));
        if (dy < dx) {
            xb[l + -1] = x[0] + rb.x;
        } else {
            yb[l + -1] = y[0] + rb.y;
        }
        Area b = new Area(new Polygon(xb, yb, xb.length));
        Area c = new Area(world);
        c.subtract(b);
        return new Area[]{b, c};
    }

    public static final VectorString2D asVectorString2D(Polygon pol, double z) throws Exception {
        double[] x = new double[pol.npoints];
        double[] y = new double[pol.npoints];
        for (int i = 0; i < x.length; ++i) {
            x[i] = pol.xpoints[i];
            y[i] = pol.ypoints[i];
        }
        return new VectorString2D(x, y, z, true);
    }

    public static final double volumeOfTruncatedCone(double r1, double r2, double height) {
        return Math.PI * (r1 * r1 + r1 * r2 + r2 * r2) * height / 3.0;
    }

    public static final double lateralAreaOfTruncatedCone(double r1, double r2, double height) {
        return Math.PI * (r1 + r2) * Math.sqrt(Math.pow(r2 - r1, 2.0) + height * height);
    }

    public static final double totalAreaOfTruncatedCone(double r1, double r2, double height) {
        return M.lateralAreaOfTruncatedCone(r1, r2, height) + Math.PI * (r1 * r1 + r2 * r2);
    }

    public static final void convolveGaussianSigma1(float[] in, float[] out, CircularSequence seq) {
        int i;
        float w2 = 0.05448869f;
        float w1 = 0.24420135f;
        float w0 = 0.40261993f;
        if (out.length < 5) {
            for (int i2 = 0; i2 < out.length; ++i2) {
                out[i2] = in[seq.setPosition(i2 - 2)] * 0.05448869f + in[seq.setPosition(i2 - 1)] * 0.24420135f + in[seq.setPosition(i2)] * 0.40261993f + in[seq.setPosition(i2 + 1)] * 0.24420135f + in[seq.setPosition(i2 + 2)] * 0.05448869f;
            }
            return;
        }
        for (int i3 = 0; i3 < 2; ++i3) {
            out[i3] = in[seq.setPosition(i3 - 2)] * 0.05448869f + in[seq.setPosition(i3 - 1)] * 0.24420135f + in[seq.setPosition(i3)] * 0.40261993f + in[seq.setPosition(i3 + 1)] * 0.24420135f + in[seq.setPosition(i3 + 2)] * 0.05448869f;
        }
        int cut = out.length - 2;
        for (i = 2; i < cut; ++i) {
            out[i] = in[i - 2] * 0.05448869f + in[i - 1] * 0.24420135f + in[i] * 0.40261993f + in[i + 1] * 0.24420135f + in[i + 2] * 0.05448869f;
        }
        for (i = cut; i < out.length; ++i) {
            out[i] = in[seq.setPosition(i - 2)] * 0.05448869f + in[seq.setPosition(i - 1)] * 0.24420135f + in[seq.setPosition(i)] * 0.40261993f + in[seq.setPosition(i + 1)] * 0.24420135f + in[seq.setPosition(i + 2)] * 0.05448869f;
        }
    }

    public static final FloatPolygon createInterpolatedPolygon(FloatPolygon p, double interval, boolean isLine) {
        double length = p.getLength(isLine);
        int npoints2 = (int)(length * 1.2 / interval);
        float[] xpoints2 = new float[npoints2];
        float[] ypoints2 = new float[npoints2];
        xpoints2[0] = p.xpoints[0];
        ypoints2[0] = p.ypoints[0];
        int n = 1;
        double inc = 0.01;
        double distance = 0.0;
        double distance2 = 0.0;
        double dx = 0.0;
        double dy = 0.0;
        double x2 = p.xpoints[0];
        double y2 = p.ypoints[0];
        int npoints = p.npoints;
        if (!isLine) {
            ++npoints;
        }
        for (int i = 1; i < npoints; ++i) {
            double x1 = x2;
            double y1 = y2;
            double x = x1;
            double y = y1;
            if (i < p.npoints) {
                x2 = p.xpoints[i];
                y2 = p.ypoints[i];
            } else {
                x2 = p.xpoints[0];
                y2 = p.ypoints[0];
            }
            dx = x2 - x1;
            dy = y2 - y1;
            distance = Math.sqrt(dx * dx + dy * dy);
            double xinc = dx * 0.01 / distance;
            double yinc = dy * 0.01 / distance;
            double lastx = xpoints2[n - 1];
            double lasty = ypoints2[n - 1];
            int n2 = (int)(distance / 0.01);
            if (npoints == 2) {
                ++n2;
            }
            do {
                if ((distance2 = Math.sqrt((dx = x - lastx) * dx + (dy = y - lasty) * dy)) >= interval - 0.005 && n < xpoints2.length - 1) {
                    xpoints2[n] = (float)x;
                    ypoints2[n] = (float)y;
                    ++n;
                    lastx = x;
                    lasty = y;
                }
                x += xinc;
                y += yinc;
            } while (--n2 > 0);
        }
        return new FloatPolygon(xpoints2, ypoints2, n);
    }
}

