/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.plugin;

import fiji.util.gui.GenericDialogPlus;
import ij.IJ;
import ij.ImageJ;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import java.awt.AWTEvent;
import java.awt.Choice;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.util.Pair;
import net.imglib2.util.ValuePair;
import spim.fiji.datasetmanager.DHM;
import spim.fiji.datasetmanager.LightSheetZ1;
import spim.fiji.datasetmanager.MicroManager;
import spim.fiji.datasetmanager.MultiViewDatasetDefinition;
import spim.fiji.datasetmanager.SlideBook6;
import spim.fiji.datasetmanager.StackList;
import spim.fiji.datasetmanager.StackListImageJ;
import spim.fiji.datasetmanager.StackListLOCI;
import spim.fiji.plugin.queryXML.GenericLoadParseQueryXML;
import spim.fiji.plugin.util.GUIHelper;
import spim.fiji.plugin.util.MyMultiLineLabel;
import spim.fiji.spimdata.SpimData2;

public class Define_Multi_View_Dataset
implements PlugIn {
    public static final ArrayList<MultiViewDatasetDefinition> staticDatasetDefinitions = new ArrayList();
    public static int defaultDatasetDef = 3;
    public static String defaultXMLName = "dataset.xml";
    final int numLinesDocumentation = 15;
    final int numCharacters = 80;

    public void run(String arg0) {
        this.defineDataset(true);
    }

    public Pair<SpimData2, String> defineDataset(boolean save) {
        ArrayList<MultiViewDatasetDefinition> datasetDefinitions = new ArrayList<MultiViewDatasetDefinition>();
        for (MultiViewDatasetDefinition mvd : staticDatasetDefinitions) {
            datasetDefinitions.add(mvd.newInstance());
        }
        int numDatasetDefinitions = datasetDefinitions.size();
        if (numDatasetDefinitions == 0) {
            IJ.log((String)"No Multi-View Dataset Definitions available.");
            return null;
        }
        String[] titles = new String[numDatasetDefinitions];
        for (int i = 0; i < datasetDefinitions.size(); ++i) {
            titles[i] = ((MultiViewDatasetDefinition)datasetDefinitions.get(i)).getTitle();
        }
        GenericDialogPlus gd1 = new GenericDialogPlus("Select type of multi-view dataset");
        if (defaultDatasetDef >= numDatasetDefinitions) {
            defaultDatasetDef = 0;
        }
        gd1.addChoice("Type_of_dataset: ", titles, titles[defaultDatasetDef]);
        gd1.addStringField("XML_filename", defaultXMLName, 30);
        GUIHelper.addWebsite((GenericDialog)gd1);
        gd1.showDialog();
        if (gd1.wasCanceled()) {
            return null;
        }
        defaultDatasetDef = gd1.getNextChoiceIndex();
        String xmlFileName = defaultXMLName = gd1.getNextString();
        MultiViewDatasetDefinition def = (MultiViewDatasetDefinition)datasetDefinitions.get(defaultDatasetDef);
        IOFunctions.println(defaultDatasetDef);
        SpimData2 spimData = def.createDataset();
        if (spimData == null) {
            IOFunctions.println("Defining multi-view dataset failed.");
            return null;
        }
        String xml = SpimData2.saveXML(spimData, xmlFileName, "");
        if (xml != null) {
            GenericLoadParseQueryXML.defaultXMLfilename = xml;
            return new ValuePair((Object)spimData, (Object)xml);
        }
        return null;
    }

    public static String[] formatEntry(String line, int numCharacters, int numLines) {
        String[] split;
        if (line == null) {
            line = "";
        }
        if ((split = line.split("\n")).length != numLines) {
            int j;
            String[] split2 = new String[numLines];
            for (j = 0; j < Math.min(split.length, numLines); ++j) {
                split2[j] = split[j];
            }
            for (j = Math.min(split.length, numLines); j < numLines; ++j) {
                split2[j] = "";
            }
            split = split2;
        }
        for (int j = 0; j < split.length; ++j) {
            String s = split[j];
            if (s.length() > 80) {
                s = s.substring(0, 80);
            }
            for (int i = s.length(); i < numCharacters + 3; ++i) {
                s = s + " ";
            }
            split[j] = s;
        }
        return split;
    }

    protected void addListeners(GenericDialog gd, final Choice choice, final MyMultiLineLabel label, final ArrayList<MultiViewDatasetDefinition> datasetDefinitions) {
        gd.addDialogListener(new DialogListener(){

            public boolean dialogItemChanged(GenericDialog dialog, AWTEvent e) {
                if (e instanceof ItemEvent && e.getID() == 701 && e.getSource() == choice) {
                    label.setText(Define_Multi_View_Dataset.formatEntry(((MultiViewDatasetDefinition)datasetDefinitions.get(choice.getSelectedIndex())).getExtendedDescription(), 80, 15));
                }
                return true;
            }
        });
    }

    public static void main(String[] args) {
        StackList.defaultDirectory = "/Users/preibischs/Documents/Microscopy/SPIM/HisYFP-SPIM";
        IOFunctions.printIJLog = true;
        new ImageJ();
        new Define_Multi_View_Dataset().run(null);
    }

    static {
        IOFunctions.printIJLog = true;
        staticDatasetDefinitions.add(new StackListLOCI());
        staticDatasetDefinitions.add(new StackListImageJ());
        staticDatasetDefinitions.add(new MicroManager());
        staticDatasetDefinitions.add(new LightSheetZ1());
        staticDatasetDefinitions.add(new DHM());
        staticDatasetDefinitions.add(new SlideBook6());
    }
}

