/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.spimdata.imgloaders;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import mpicbg.spim.data.XmlHelpers;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.ImgLoaderIo;
import mpicbg.spim.data.generic.sequence.XmlIoBasicImgLoader;
import org.jdom2.Content;
import org.jdom2.Element;
import spim.fiji.spimdata.imgloaders.DHMImgLoader;

@ImgLoaderIo(format="spimreconstruction.dhm", type=DHMImgLoader.class)
public class XmlIoDHMImgLoader
implements XmlIoBasicImgLoader<DHMImgLoader> {
    public static final String STACK_DIR_TAG = "stackDir";
    public static final String AMPLITUDE_DIR_TAG = "amplitudeDir";
    public static final String PHASE_DIR_TAG = "phaseDir";
    public static final String TIMEPOINTS_TAG = "timepoints";
    public static final String ZPLANES_TAG = "zplanes";
    public static final String EXTENSION_TAG = "ext";
    public static final String AMPLITUDE_ID_TAG = "amplitudeId";
    public static final String PHASE_ID_TAG = "phaseId";

    public Element toXml(DHMImgLoader imgLoader, File basePath) {
        Element elem = new Element("ImageLoader");
        elem.setAttribute("format", this.getClass().getAnnotation(ImgLoaderIo.class).format());
        elem.addContent((Content)XmlHelpers.textElement((String)STACK_DIR_TAG, (String)imgLoader.getStackDir()));
        elem.addContent((Content)XmlHelpers.textElement((String)AMPLITUDE_DIR_TAG, (String)imgLoader.getAmplitudeDir()));
        elem.addContent((Content)XmlHelpers.textElement((String)PHASE_DIR_TAG, (String)imgLoader.getPhaseDir()));
        elem.addContent((Content)XmlHelpers.textElement((String)TIMEPOINTS_TAG, (String)XmlIoDHMImgLoader.semicolonSeparatedList(imgLoader.getTimepoints())));
        elem.addContent((Content)XmlHelpers.textElement((String)ZPLANES_TAG, (String)XmlIoDHMImgLoader.semicolonSeparatedList(imgLoader.getZPlanes())));
        elem.addContent((Content)XmlHelpers.textElement((String)EXTENSION_TAG, (String)imgLoader.getExt()));
        elem.addContent((Content)XmlHelpers.intElement((String)AMPLITUDE_ID_TAG, (int)imgLoader.getAmpChannelId()));
        elem.addContent((Content)XmlHelpers.intElement((String)PHASE_ID_TAG, (int)imgLoader.getPhaseChannelId()));
        return elem;
    }

    public DHMImgLoader fromXml(Element elem, File basePath, AbstractSequenceDescription<?, ?, ?> sequenceDescription) {
        try {
            String stackDir = XmlHelpers.getText((Element)elem, (String)STACK_DIR_TAG);
            String amplitudeDir = XmlHelpers.getText((Element)elem, (String)AMPLITUDE_DIR_TAG);
            String phaseDir = XmlHelpers.getText((Element)elem, (String)PHASE_DIR_TAG);
            List<String> timepoints = XmlIoDHMImgLoader.fromSemicolonSeparatedString(XmlHelpers.getText((Element)elem, (String)TIMEPOINTS_TAG));
            List<String> zPlanes = XmlIoDHMImgLoader.fromSemicolonSeparatedString(XmlHelpers.getText((Element)elem, (String)ZPLANES_TAG));
            String extension = XmlHelpers.getText((Element)elem, (String)EXTENSION_TAG);
            int ampChannelId = XmlHelpers.getInt((Element)elem, (String)AMPLITUDE_ID_TAG);
            int phaseChannelId = XmlHelpers.getInt((Element)elem, (String)PHASE_ID_TAG);
            return new DHMImgLoader(basePath, stackDir, amplitudeDir, phaseDir, timepoints, zPlanes, extension, ampChannelId, phaseChannelId, sequenceDescription);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String semicolonSeparatedList(List<String> elements) {
        if (elements == null || elements.size() == 0) {
            return "";
        }
        if (elements.size() == 1) {
            return elements.get(0);
        }
        String s = elements.get(0);
        for (int i = 1; i < elements.size(); ++i) {
            s = s + ";" + elements.get(i);
        }
        return s;
    }

    public static List<String> fromSemicolonSeparatedString(String semicolonList) {
        ArrayList<String> list = new ArrayList<String>();
        for (String entry : semicolonList.trim().split(";")) {
            list.add(entry);
        }
        return list;
    }
}

