/*
 * Decompiled with CFR 0.152.
 */
package spim.process.fusion.boundingbox.automatic;

import ij.ImageJ;
import ij.ImagePlus;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.Cursor;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.interpolation.randomaccess.NearestNeighborInterpolatorFactory;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Util;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.Views;
import spim.Threads;
import spim.fiji.spimdata.SpimData2;
import spim.process.fusion.FusionHelper;
import spim.process.fusion.ImagePortion;
import spim.process.fusion.boundingbox.BoundingBoxGUI;
import spim.process.fusion.weightedavg.ProcessFusion;
import spim.process.fusion.weightedavg.ProcessParalell;
import spim.process.fusion.weightedavg.ProcessSequential;

public class MinFilterThreshold {
    final List<ViewId> viewIdsToProcess;
    final Channel channel;
    final TimePoint timepoint;
    final SpimData2 spimData;
    final BoundingBoxGUI bb;
    final double background;
    final int radiusMin;
    final boolean loadSequentially;
    final boolean displaySegmentationImage;
    int[] min;
    int[] max;

    public MinFilterThreshold(SpimData2 spimData, List<ViewId> viewIdsToProcess, Channel channel, TimePoint timepoint, BoundingBoxGUI bb, double background, int discardedObjectSize, boolean loadSequentially, boolean displaySegmentationImage) {
        this.spimData = spimData;
        this.viewIdsToProcess = viewIdsToProcess;
        this.channel = channel;
        this.timepoint = timepoint;
        this.bb = bb;
        this.background = background;
        this.radiusMin = discardedObjectSize / 2;
        this.loadSequentially = loadSequentially;
        this.displaySegmentationImage = displaySegmentationImage;
    }

    public int[] getMin() {
        return this.min;
    }

    public int[] getMax() {
        return this.max;
    }

    public boolean run() {
        ProcessFusion process = this.loadSequentially ? new ProcessSequential(this.spimData, this.viewIdsToProcess, this.bb, false, false, 1) : new ProcessParalell(this.spimData, this.viewIdsToProcess, this.bb, false, false);
        Img<FloatType> img = process.fuseStack(new FloatType(), new NearestNeighborInterpolatorFactory(), this.timepoint, this.channel);
        float[] minmax = FusionHelper.minMax(img);
        int effR = Math.max(this.radiusMin / this.bb.getDownSampling(), 1);
        double threshold = (double)(minmax[1] - minmax[0]) * (this.background / 100.0) + (double)minmax[0];
        IOFunctions.println("Fused image minimum: " + minmax[0]);
        IOFunctions.println("Fused image maximum: " + minmax[1]);
        IOFunctions.println("Threshold: " + threshold);
        IOFunctions.println("Computing minimum filter with effective radius of " + effR + " (downsampling=" + this.bb.getDownSampling() + ")");
        img = MinFilterThreshold.computeLazyMinFilter(img, effR);
        if (this.displaySegmentationImage) {
            ImageJFunctions.show(img);
        }
        this.min = new int[img.numDimensions()];
        this.max = new int[img.numDimensions()];
        if (!MinFilterThreshold.computeBoundingBox(img, threshold, this.min, this.max)) {
            return false;
        }
        IOFunctions.println("Bounding box dim scaled: [" + Util.printCoordinates((int[])this.min) + "] >> [" + Util.printCoordinates((int[])this.max) + "]");
        int d = 0;
        while (d < img.numDimensions()) {
            int n = d;
            this.min[n] = this.min[n] * this.bb.getDownSampling();
            int n2 = d;
            this.max[n2] = this.max[n2] * this.bb.getDownSampling();
            int n3 = d;
            this.min[n3] = (int)((long)this.min[n3] + this.bb.min(d));
            int n4 = d;
            this.max[n4] = (int)((long)this.max[n4] + this.bb.min(d));
            int n5 = d;
            this.min[n5] = this.min[n5] - this.radiusMin * 3;
            int n6 = d++;
            this.max[n6] = this.max[n6] + this.radiusMin * 3;
        }
        IOFunctions.println("Bounding box dim global: [" + Util.printCoordinates((int[])this.min) + "] >> [" + Util.printCoordinates((int[])this.max) + "]");
        return true;
    }

    public static final <T extends RealType<T>> boolean computeBoundingBox(final Img<T> img, final double threshold, int[] min, int[] max) {
        final int n = img.numDimensions();
        for (int d = 0; d < n; ++d) {
            min[d] = (int)img.dimension(d);
            max[d] = 0;
        }
        Vector<ImagePortion> portions = FusionHelper.divideIntoPortions(img.size(), Threads.numThreads() * 2);
        ExecutorService taskExecutor = Executors.newFixedThreadPool(Threads.numThreads());
        ArrayList<1> tasks = new ArrayList<1>();
        for (final ImagePortion portion : portions) {
            tasks.add(new Callable<int[][]>(){

                @Override
                public int[][] call() throws Exception {
                    int[] min = new int[n];
                    int[] max = new int[n];
                    for (int d = 0; d < n; ++d) {
                        min[d] = (int)img.dimension(d);
                        max[d] = 0;
                    }
                    Cursor c = img.localizingCursor();
                    c.jumpFwd(portion.getStartPosition());
                    for (long j = 0L; j < portion.getLoopSize(); ++j) {
                        double v = ((RealType)c.next()).getRealDouble();
                        if (!(v > threshold)) continue;
                        for (int d = 0; d < n; ++d) {
                            int l = c.getIntPosition(d);
                            min[d] = Math.min(min[d], l);
                            max[d] = Math.max(max[d], l);
                        }
                    }
                    return new int[][]{min, max};
                }
            });
            try {
                List futureList = taskExecutor.invokeAll(tasks);
                for (Future future : futureList) {
                    int[][] minmaxThread = (int[][])future.get();
                    for (int d = 0; d < n; ++d) {
                        min[d] = Math.min(min[d], minmaxThread[0][d]);
                        max[d] = Math.max(max[d], minmaxThread[1][d]);
                    }
                }
            }
            catch (Exception e) {
                IOFunctions.println("Failed to compute bounding box by thresholding: " + e);
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public static final <T extends RealType<T>> Img<T> computeLazyMinFilter(Img<T> tmp1, int radius) {
        int n = tmp1.numDimensions();
        int filterExtent = radius * 2 + 1;
        Img<T> tmp2 = tmp1.factory().create(tmp1, tmp1.firstElement());
        Vector<ImagePortion> portions = FusionHelper.divideIntoPortions(tmp1.size(), Threads.numThreads() * 2);
        ExecutorService taskExecutor = Executors.newFixedThreadPool(Threads.numThreads());
        for (int dim = 0; dim < n; ++dim) {
            Img<T> output;
            ExtendedRandomAccessibleInterval input;
            int d = dim;
            if (d % 2 == 0) {
                input = Views.extendZero(tmp1);
                output = tmp2;
            } else {
                input = Views.extendZero((RandomAccessibleInterval)tmp2);
                output = tmp1;
            }
            ArrayList<2> tasks = new ArrayList<2>();
            for (ImagePortion portion : portions) {
                tasks.add(new Callable<String>((RandomAccessible)input, n, output, portion, d, radius, filterExtent){
                    final /* synthetic */ RandomAccessible val$input;
                    final /* synthetic */ int val$n;
                    final /* synthetic */ Img val$output;
                    final /* synthetic */ ImagePortion val$portion;
                    final /* synthetic */ int val$d;
                    final /* synthetic */ int val$radius;
                    final /* synthetic */ int val$filterExtent;
                    {
                        this.val$input = randomAccessible;
                        this.val$n = n;
                        this.val$output = img;
                        this.val$portion = imagePortion;
                        this.val$d = n2;
                        this.val$radius = n3;
                        this.val$filterExtent = n4;
                    }

                    @Override
                    public String call() throws Exception {
                        RandomAccess r = this.val$input.randomAccess();
                        int[] tmp = new int[this.val$n];
                        Cursor c = this.val$output.localizingCursor();
                        c.jumpFwd(this.val$portion.getStartPosition());
                        for (long j = 0L; j < this.val$portion.getLoopSize(); ++j) {
                            RealType t = (RealType)c.next();
                            c.localize(tmp);
                            int n = this.val$d;
                            tmp[n] = tmp[n] - this.val$radius;
                            r.setPosition(tmp);
                            float min = Float.MAX_VALUE;
                            for (int i = 0; i < this.val$filterExtent; ++i) {
                                min = Math.min(min, ((RealType)r.get()).getRealFloat());
                                r.fwd(this.val$d);
                            }
                            t.setReal(min);
                        }
                        return "";
                    }
                });
            }
            try {
                taskExecutor.invokeAll(tasks);
                continue;
            }
            catch (InterruptedException e) {
                IOFunctions.println("Failed to compute lazy min filter: " + e);
                e.printStackTrace();
                return null;
            }
        }
        taskExecutor.shutdown();
        if (n % 2 == 0) {
            return tmp1;
        }
        return tmp2;
    }

    public static void main(String[] args) {
        new ImageJ();
        ImagePlus imp = new ImagePlus("/Users/preibischs/workspace/TestLucyRichardson/src/resources/dros-1.tif");
        Img img = ImageJFunctions.convertFloat((ImagePlus)imp);
        ImageJFunctions.show((RandomAccessibleInterval)img.copy());
        ImageJFunctions.show(MinFilterThreshold.computeLazyMinFilter(img, 5));
    }
}

