/*
 * Decompiled with CFR 0.152.
 */
package spim.process.fusion.weightedavg;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.ViewDescription;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.ViewSetup;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import spim.Threads;
import spim.fiji.spimdata.SpimData2;
import spim.process.fusion.FusionHelper;
import spim.process.fusion.ImagePortion;
import spim.process.fusion.boundingbox.BoundingBoxGUI;
import spim.process.fusion.export.FixedNameImgTitler;
import spim.process.fusion.export.ImgExport;
import spim.process.fusion.export.ImgExportTitle;
import spim.process.fusion.weightedavg.ProcessFusion;
import spim.process.fusion.weightedavg.ProcessIndependentPortion;

public class ProcessIndependent
extends ProcessFusion {
    final ImgExport export;
    final Map<ViewSetup, ViewSetup> newViewsetups;
    final FixedNameImgTitler titler;

    public ProcessIndependent(SpimData2 spimData, List<ViewId> viewIdsToProcess, BoundingBoxGUI bb, ImgExport export, Map<ViewSetup, ViewSetup> newViewsetups) {
        super(spimData, viewIdsToProcess, bb, false, false);
        this.export = export;
        this.newViewsetups = newViewsetups;
        this.titler = new FixedNameImgTitler("");
        if (this.export instanceof ImgExportTitle) {
            ((ImgExportTitle)this.export).setImgTitler(this.titler);
        }
    }

    @Override
    public <T extends RealType<T> & NativeType<T>> Img<T> fuseStack(T type, InterpolatorFactory<T, RandomAccessible<T>> interpolatorFactory, TimePoint timepoint, Channel channel) {
        ArrayList<ViewDescription> allInputData = FusionHelper.assembleInputData(this.spimData, timepoint, channel, this.viewIdsToProcess);
        for (int i = 0; i < allInputData.size(); ++i) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Fusing view " + i + " of " + (allInputData.size() - 1));
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Reserving memory for fused image.");
            Img fusedImg = this.bb.getImgFactory(type).create(this.bb.getDimensions(), type);
            if (fusedImg == null) {
                IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): WeightedAverageFusion: Cannot create output image.");
                return null;
            }
            ViewDescription inputData = allInputData.get(i);
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Requesting Img from ImgLoader (tp=" + inputData.getTimePointId() + ", setup=" + inputData.getViewSetupId() + ")");
            RandomAccessibleInterval<T> img = ProcessIndependent.getImage(type, this.spimData, (ViewId)inputData, false);
            Vector<ImagePortion> portions = FusionHelper.divideIntoPortions(fusedImg.size(), Threads.numThreads() * 4);
            ExecutorService taskExecutor = Executors.newFixedThreadPool(Threads.numThreads());
            ArrayList<ProcessIndependentPortion<T>> tasks = new ArrayList<ProcessIndependentPortion<T>>();
            for (ImagePortion portion : portions) {
                tasks.add(new ProcessIndependentPortion<T>(portion, img, interpolatorFactory, this.getTransform(inputData), fusedImg, this.bb));
            }
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Starting fusion process.");
            try {
                taskExecutor.invokeAll(tasks);
            }
            catch (InterruptedException e) {
                IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Failed to compute fusion: " + e);
                e.printStackTrace();
                return null;
            }
            taskExecutor.shutdown();
            this.titler.setTitle("TP" + inputData.getTimePointId() + "_Channel" + ((ViewSetup)inputData.getViewSetup()).getChannel().getName() + "_Illum" + ((ViewSetup)inputData.getViewSetup()).getIllumination().getName() + "_Angle" + ((ViewSetup)inputData.getViewSetup()).getAngle().getName());
            this.export.exportImage(fusedImg, this.bb, timepoint, this.newViewsetups.get(inputData.getViewSetup()));
        }
        return null;
    }

    protected int numBatches(int numViews, int sequentialViews) {
        return numViews / sequentialViews + Math.min(numViews % sequentialViews, 1);
    }
}

